/*
 * Decompiled with CFR 0.152.
 */
package biniu.vorbis;

import biniu.ogg.Buffer;

public class Comment {
    private static byte[] VORBIS = "vorbis".getBytes();
    public static final int OV_EFAULT = -129;
    public static final int OV_EIMPL = -130;
    public byte[][] user_comments;
    public int[] comment_lengths;
    public int comments;
    public byte[] vendor;

    public void init() {
        this.user_comments = null;
        this.comments = 0;
        this.vendor = null;
    }

    public void add(String comment) {
        this.add(comment.getBytes());
    }

    private void add(byte[] comment) {
        byte[][] foo = new byte[this.comments + 2][];
        if (this.user_comments != null) {
            System.arraycopy(this.user_comments, 0, foo, 0, this.comments);
        }
        this.user_comments = foo;
        int[] goo = new int[this.comments + 2];
        if (this.comment_lengths != null) {
            System.arraycopy(this.comment_lengths, 0, goo, 0, this.comments);
        }
        this.comment_lengths = goo;
        byte[] bar = new byte[comment.length + 1];
        System.arraycopy(comment, 0, bar, 0, comment.length);
        this.user_comments[this.comments] = bar;
        this.comment_lengths[this.comments] = comment.length;
        ++this.comments;
        this.user_comments[this.comments] = null;
    }

    public void addTag(String tag, String contents) {
        if (contents == null) {
            contents = "";
        }
        this.add(tag + "=" + contents);
    }

    private boolean tagCompare(byte[] s1, byte[] s2, int n) {
        int c = 0;
        while (c < n) {
            byte u1 = s1[c];
            byte u2 = s2[c];
            if (u1 >= 65) {
                u1 = (byte)(u1 - 65 + 97);
            }
            if (u2 >= 65) {
                u2 = (byte)(u2 - 65 + 97);
            }
            if (u1 != u2) {
                return false;
            }
            ++c;
        }
        return true;
    }

    public boolean packComment(Buffer opb) {
        byte[] temp = "Xiph.Org libVorbis I 20040629".getBytes();
        opb.write(3, 8);
        opb.write(VORBIS);
        opb.write(temp.length, 32);
        opb.write(temp);
        opb.write(this.comments, 32);
        if (this.comments != 0) {
            int i = 0;
            while (i < this.comments) {
                if (this.user_comments[i] != null) {
                    opb.write(this.comment_lengths[i], 32);
                    opb.write(this.user_comments[i]);
                } else {
                    opb.write(0, 32);
                }
                ++i;
            }
        } else {
            return false;
        }
        opb.write(1, 1);
        return true;
    }

    public void clear() {
        int i = 0;
        while (i < this.comments) {
            this.user_comments[i] = null;
            ++i;
        }
        this.user_comments = null;
        this.vendor = null;
        this.comments = 0;
    }

    public String getVendor() {
        return new String(this.vendor, 0, this.vendor.length - 1);
    }

    public String getComment(int i) {
        if (this.comments <= i) {
            return null;
        }
        return new String(this.user_comments[i], 0, this.user_comments[i].length - 1);
    }

    public String toString() {
        String foo = "Vendor: " + new String(this.vendor, 0, this.vendor.length - 1);
        int i = 0;
        while (i < this.comments) {
            foo = foo + "\nComment: " + new String(this.user_comments[i], 0, this.user_comments[i].length - 1);
            ++i;
        }
        foo = foo + "\n";
        return foo;
    }
}

