/*
 * Decompiled with CFR 0.152.
 */
package biniu.vorbis;

import biniu.ogg.Buffer;
import biniu.vorbis.Block;
import biniu.vorbis.CodeBook;
import biniu.vorbis.CodecSetupInfo;
import biniu.vorbis.DspState;
import biniu.vorbis.FuncFloor;
import biniu.vorbis.InfoFloor1;
import biniu.vorbis.InfoMode;
import biniu.vorbis.LookFloor1;
import biniu.vorbis.LsfitAcc;
import biniu.vorbis.PrivateState;
import biniu.vorbis.StaticCodeBook;
import biniu.vorbis.para;

class Floor1
extends FuncFloor {
    static final int floor1_rangedb = 140;
    static final int VIF_POSIT = 63;
    private static float[] FLOOR_fromdB_LOOKUP = new float[]{1.0649863E-7f, 1.1341951E-7f, 1.2079015E-7f, 1.2863978E-7f, 1.369995E-7f, 1.459025E-7f, 1.5538409E-7f, 1.6548181E-7f, 1.7623574E-7f, 1.8768856E-7f, 1.998856E-7f, 2.128753E-7f, 2.2670913E-7f, 2.4144197E-7f, 2.5713223E-7f, 2.7384212E-7f, 2.9163792E-7f, 3.1059022E-7f, 3.307741E-7f, 3.5226967E-7f, 3.7516213E-7f, 3.995423E-7f, 4.255068E-7f, 4.5315863E-7f, 4.8260745E-7f, 5.1397E-7f, 5.4737063E-7f, 5.829419E-7f, 6.208247E-7f, 6.611694E-7f, 7.041359E-7f, 7.4989464E-7f, 7.98627E-7f, 8.505263E-7f, 9.057983E-7f, 9.646621E-7f, 1.0273513E-6f, 1.0941144E-6f, 1.1652161E-6f, 1.2409384E-6f, 1.3215816E-6f, 1.4074654E-6f, 1.4989305E-6f, 1.5963394E-6f, 1.7000785E-6f, 1.8105592E-6f, 1.9282195E-6f, 2.053526E-6f, 2.1869757E-6f, 2.3290977E-6f, 2.4804558E-6f, 2.6416496E-6f, 2.813319E-6f, 2.9961443E-6f, 3.1908505E-6f, 3.39821E-6f, 3.619045E-6f, 3.8542307E-6f, 4.1047006E-6f, 4.371447E-6f, 4.6555283E-6f, 4.958071E-6f, 5.280274E-6f, 5.623416E-6f, 5.988857E-6f, 6.3780467E-6f, 6.7925284E-6f, 7.2339453E-6f, 7.704048E-6f, 8.2047E-6f, 8.737888E-6f, 9.305725E-6f, 9.910464E-6f, 1.0554501E-5f, 1.1240392E-5f, 1.1970856E-5f, 1.2748789E-5f, 1.3577278E-5f, 1.4459606E-5f, 1.5399271E-5f, 1.6400005E-5f, 1.7465769E-5f, 1.8600793E-5f, 1.9809577E-5f, 2.1096914E-5f, 2.2467912E-5f, 2.3928002E-5f, 2.5482977E-5f, 2.7139005E-5f, 2.890265E-5f, 3.078091E-5f, 3.2781227E-5f, 3.4911533E-5f, 3.718028E-5f, 3.9596467E-5f, 4.2169668E-5f, 4.491009E-5f, 4.7828602E-5f, 5.0936775E-5f, 5.424693E-5f, 5.7772202E-5f, 6.152657E-5f, 6.552491E-5f, 6.9783084E-5f, 7.4317984E-5f, 7.914758E-5f, 8.429104E-5f, 8.976875E-5f, 9.560242E-5f, 1.0181521E-4f, 1.0843174E-4f, 1.1547824E-4f, 1.2298267E-4f, 1.3097477E-4f, 1.3948625E-4f, 1.4855085E-4f, 1.5820454E-4f, 1.6848555E-4f, 1.7943469E-4f, 1.9109536E-4f, 2.0351382E-4f, 2.167393E-4f, 2.3082423E-4f, 2.4582449E-4f, 2.6179955E-4f, 2.7881275E-4f, 2.9693157E-4f, 3.1622787E-4f, 3.3677815E-4f, 3.5866388E-4f, 3.8197188E-4f, 4.0679457E-4f, 4.3323037E-4f, 4.613841E-4f, 4.913675E-4f, 5.2329927E-4f, 5.573062E-4f, 5.935231E-4f, 6.320936E-4f, 6.731706E-4f, 7.16917E-4f, 7.635063E-4f, 8.1312325E-4f, 8.6596457E-4f, 9.2223985E-4f, 9.821722E-4f, 0.0010459992f, 0.0011139743f, 0.0011863665f, 0.0012634633f, 0.0013455702f, 0.0014330129f, 0.0015261382f, 0.0016253153f, 0.0017309374f, 0.0018434235f, 0.0019632196f, 0.0020908006f, 0.0022266726f, 0.0023713743f, 0.0025254795f, 0.0026895993f, 0.0028643848f, 0.0030505287f, 0.003248769f, 0.0034598925f, 0.0036847359f, 0.0039241905f, 0.0041792067f, 0.004450795f, 0.004740033f, 0.005048067f, 0.0053761187f, 0.005725489f, 0.0060975635f, 0.0064938175f, 0.0069158226f, 0.0073652514f, 0.007843887f, 0.008353627f, 0.008896492f, 0.009474637f, 0.010090352f, 0.01074608f, 0.011444421f, 0.012188144f, 0.012980198f, 0.013823725f, 0.014722068f, 0.015678791f, 0.016697686f, 0.017782796f, 0.018938422f, 0.020169148f, 0.021479854f, 0.022875736f, 0.02436233f, 0.025945531f, 0.027631618f, 0.029427277f, 0.031339627f, 0.03337625f, 0.035545226f, 0.037855156f, 0.0403152f, 0.042935107f, 0.045725275f, 0.048696756f, 0.05186135f, 0.05523159f, 0.05882085f, 0.062643364f, 0.06671428f, 0.07104975f, 0.075666964f, 0.08058423f, 0.08582105f, 0.09139818f, 0.097337745f, 0.1036633f, 0.11039993f, 0.11757434f, 0.12521498f, 0.13335215f, 0.14201812f, 0.15124726f, 0.16107617f, 0.1715438f, 0.18269168f, 0.19456401f, 0.20720787f, 0.22067343f, 0.23501402f, 0.25028655f, 0.26655158f, 0.28387362f, 0.3023213f, 0.32196787f, 0.34289113f, 0.36517414f, 0.3889052f, 0.41417846f, 0.44109413f, 0.4697589f, 0.50028646f, 0.53279793f, 0.5674221f, 0.6042964f, 0.64356697f, 0.6853896f, 0.72993004f, 0.777365f, 0.8278826f, 0.88168305f, 0.9389798f, 1.0f};
    boolean TRAIN_FLOOR1 = false;
    private static int[] val200n = new int[]{-200};
    private static int[] val1 = new int[]{1};
    private static int[] val1n = new int[]{-1};

    public void pack(Object i, Buffer opb) {
        InfoFloor1 info = (InfoFloor1)i;
        int count = 0;
        int maxposit = info.postlist[1];
        int maxclass = -1;
        opb.write(info.partitions, 5);
        int j = 0;
        while (j < info.partitions) {
            opb.write(info.partitionclass[j], 4);
            if (maxclass < info.partitionclass[j]) {
                maxclass = info.partitionclass[j];
            }
            ++j;
        }
        int j2 = 0;
        while (j2 < maxclass + 1) {
            opb.write(info.class_dim[j2] - 1, 3);
            opb.write(info.class_subs[j2], 2);
            if (info.class_subs[j2] != 0) {
                opb.write(info.class_book[j2], 8);
            }
            int k = 0;
            while (k < 1 << info.class_subs[j2]) {
                opb.write(info.class_subbook[j2][k] + 1, 8);
                ++k;
            }
            ++j2;
        }
        opb.write(info.mult - 1, 2);
        opb.write(this.ilog2(maxposit), 4);
        int rangebits = this.ilog2(maxposit);
        int j3 = 0;
        int k = 0;
        while (j3 < info.partitions) {
            count += info.class_dim[info.partitionclass[j3]];
            while (k < count) {
                opb.write(info.postlist[k + 2], rangebits);
                ++k;
            }
            ++j3;
        }
    }

    public Object look(DspState vd, InfoMode mi, Object i) {
        return this.look(vd, i);
    }

    public Object look(DspState vd, Object mi) {
        int n = 0;
        int[] sortpointer = new int[65];
        InfoFloor1 info = (InfoFloor1)mi;
        LookFloor1 look = new LookFloor1();
        look.vi = info;
        look.n = info.postlist[1];
        int j = 0;
        while (j < info.partitions) {
            n += info.class_dim[info.partitionclass[j]];
            ++j;
        }
        look.posts = n += 2;
        int j2 = 0;
        while (j2 < n) {
            sortpointer[j2] = j2;
            ++j2;
        }
        int j3 = 0;
        while (j3 < n - 1) {
            int k = j3;
            while (k < n) {
                if (info.postlist[sortpointer[j3]] > info.postlist[sortpointer[k]]) {
                    int foo = sortpointer[k];
                    sortpointer[k] = sortpointer[j3];
                    sortpointer[j3] = foo;
                }
                ++k;
            }
            ++j3;
        }
        int j4 = 0;
        while (j4 < n) {
            look.forwardIndex[j4] = sortpointer[j4];
            ++j4;
        }
        int j5 = 0;
        while (j5 < n) {
            look.reverseIndex[look.forwardIndex[j5]] = j5;
            ++j5;
        }
        int j6 = 0;
        while (j6 < n) {
            look.sortedIndex[j6] = info.postlist[look.forwardIndex[j6]];
            ++j6;
        }
        switch (info.mult) {
            case 1: {
                look.quant_q = 256;
                break;
            }
            case 2: {
                look.quant_q = 128;
                break;
            }
            case 3: {
                look.quant_q = 86;
                break;
            }
            case 4: {
                look.quant_q = 64;
                break;
            }
            default: {
                look.quant_q = -1;
            }
        }
        int j7 = 0;
        while (j7 < n - 2) {
            int lo = 0;
            int hi = 1;
            int lx = 0;
            int hx = look.n;
            int currentx = info.postlist[j7 + 2];
            int k = 0;
            while (k < j7 + 2) {
                int x = info.postlist[k];
                if (x > lx && x < currentx) {
                    lo = k;
                    lx = x;
                }
                if (x < hx && x > currentx) {
                    hi = k;
                    hx = x;
                }
                ++k;
            }
            look.loneighBor[j7] = lo;
            look.hineighBor[j7] = hi;
            ++j7;
        }
        return look;
    }

    void clear(Object obj) {
        obj = null;
    }

    int forward(Block vb, Object i, float[] in, float[] out, Object vs) {
        return 0;
    }

    public Object inverse1(Block vb, Object ii, Object memo) {
        LookFloor1 look = (LookFloor1)ii;
        InfoFloor1 info = look.vi;
        CodeBook[] books = vb.dspState.fullbooks;
        if (vb.opb.read(1) == 1) {
            int i;
            int[] fit_value = null;
            if (memo instanceof int[]) {
                fit_value = (int[])memo;
            }
            if (fit_value == null || fit_value.length < look.posts) {
                fit_value = new int[look.posts];
            } else {
                i = 0;
                while (i < fit_value.length) {
                    fit_value[i] = 0;
                    ++i;
                }
            }
            fit_value[0] = vb.opb.read(this.ilog(look.quant_q - 1));
            fit_value[1] = vb.opb.read(this.ilog(look.quant_q - 1));
            i = 0;
            int j = 2;
            while (i < info.partitions) {
                int clss = info.partitionclass[i];
                int cdim = info.class_dim[clss];
                int csubbits = info.class_subs[clss];
                int csub = 1 << csubbits;
                int cval = 0;
                if (csubbits != 0 && (cval = books[info.class_book[clss]].decode(vb.opb)) == -1) {
                    return null;
                }
                int k = 0;
                while (k < cdim) {
                    int book = info.class_subbook[clss][cval & csub - 1];
                    cval >>>= csubbits;
                    if (book >= 0) {
                        fit_value[j + k] = books[book].decode(vb.opb);
                        if (fit_value[j + k] == -1) {
                            return null;
                        }
                    } else {
                        fit_value[j + k] = 0;
                    }
                    ++k;
                }
                j += cdim;
                ++i;
            }
            int i2 = 2;
            while (i2 < look.posts) {
                int loroom;
                int predicted = this.renderPoint(info.postlist[look.loneighBor[i2 - 2]], info.postlist[look.hineighBor[i2 - 2]], fit_value[look.loneighBor[i2 - 2]], fit_value[look.hineighBor[i2 - 2]], info.postlist[i2]);
                int hiroom = look.quant_q - predicted;
                int room = (hiroom < (loroom = predicted) ? hiroom : loroom) << 1;
                int val = fit_value[i2];
                if (val != 0) {
                    val = val >= room ? (hiroom > loroom ? (val -= loroom) : -1 - (val - hiroom)) : ((val & 1) != 0 ? -(val + 1 >>> 1) : (val >>= 1));
                    fit_value[i2] = val + predicted;
                    int n = look.loneighBor[i2 - 2];
                    fit_value[n] = fit_value[n] & Short.MAX_VALUE;
                    int n2 = look.hineighBor[i2 - 2];
                    fit_value[n2] = fit_value[n2] & Short.MAX_VALUE;
                } else {
                    fit_value[i2] = predicted | 0x8000;
                }
                ++i2;
            }
            return fit_value;
        }
        return null;
    }

    private int renderPoint(int x0, int x1, int y0, int y1, int x) {
        int dy = (y1 &= Short.MAX_VALUE) - (y0 &= Short.MAX_VALUE);
        int adx = x1 - x0;
        int ady = Math.abs(dy);
        int err = ady * (x - x0);
        int off = err / adx;
        if (dy < 0) {
            return y0 - off;
        }
        return y0 + off;
    }

    public int inverse2(Block vb, Object i, Object memo, float[] out) {
        LookFloor1 look = (LookFloor1)i;
        InfoFloor1 info = look.vi;
        int n = vb.dspState.vi.blocksizes[vb.mode] / 2;
        if (memo != null) {
            int[] fit_value = (int[])memo;
            int hx = 0;
            int lx = 0;
            int ly = fit_value[0] * info.mult;
            int j = 1;
            while (j < look.posts) {
                int current = look.forwardIndex[j];
                int hy = fit_value[current] & Short.MAX_VALUE;
                if (hy == fit_value[current]) {
                    hx = info.postlist[current];
                    this.renderLine(lx, hx, ly, hy *= info.mult, out);
                    lx = hx;
                    ly = hy;
                }
                ++j;
            }
            int j2 = hx;
            while (j2 < n) {
                int n2 = j2;
                out[n2] = out[n2] * out[j2 - 1];
                ++j2;
            }
            return 1;
        }
        int j = 0;
        while (j < n) {
            out[j] = 0.0f;
            ++j;
        }
        return 0;
    }

    private void renderLine(int x0, int x1, int y0, int y1, float[] d) {
        int dy = y1 - y0;
        int adx = x1 - x0;
        int ady = Math.abs(dy);
        int base = dy / adx;
        int sy = dy < 0 ? base - 1 : base + 1;
        int x = x0;
        int y = y0;
        int err = 0;
        ady -= Math.abs(base * adx);
        int n = x;
        d[n] = d[n] * FLOOR_fromdB_LOOKUP[y];
        while (++x < x1) {
            if ((err += ady) >= adx) {
                err -= adx;
                y += sy;
            } else {
                y += base;
            }
            int n2 = x;
            d[n2] = d[n2] * FLOOR_fromdB_LOOKUP[y];
        }
    }

    /*
     * Unable to fully structure code
     */
    private int inspectError(int x0, int x1, int y0, int y1, float[] mask, float[] mdct, int pmdct, InfoFloor1 info) {
        dy = y1 - y0;
        adx = x1 - x0;
        ady = Math.abs(dy);
        base = dy / adx;
        sy = dy < 0 ? base - 1 : base + 1;
        x = x0;
        y = y0;
        err = 0;
        val = this.dBquant(mask, x);
        mse = 0;
        n = 0;
        ady -= Math.abs(base * adx);
        mse = y - val;
        mse *= mse;
        ++n;
        if (!(mdct[x + pmdct] + info.twofitatten >= mask[x])) ** GOTO lbl34
        if ((float)y + info.maxover < (float)val) {
            return 1;
        }
        if (!((float)y - info.maxunder > (float)val)) ** GOTO lbl34
        return 1;
lbl-1000:
        // 1 sources

        {
            if ((err += ady) >= adx) {
                err -= adx;
                y += sy;
            } else {
                y += base;
            }
            val = this.dBquant(mask, x);
            mse += (y - val) * (y - val);
            ++n;
            if (!(mdct[x + pmdct] + info.twofitatten >= mask[x]) || val == 0) continue;
            if ((float)y + info.maxover < (float)val) {
                return 1;
            }
            if (!((float)y - info.maxunder > (float)val)) continue;
            return 1;
lbl34:
            // 4 sources

            ** while (++x < x1)
        }
lbl35:
        // 1 sources

        if (info.maxover * info.maxover / (float)n > info.maxerr) {
            return 0;
        }
        if (info.maxunder * info.maxunder / (float)n > info.maxerr) {
            return 0;
        }
        if ((float)(mse / n) > info.maxerr) {
            return 1;
        }
        return 0;
    }

    int dBquant(float[] x, int px) {
        int i = (int)(x[px] * 7.3142858f + 1023.5f);
        if (i > 1023) {
            return 1023;
        }
        if (i < 0) {
            return 0;
        }
        return i;
    }

    private int accumulateFit(float[] flr, float[] mdct, int pmdct, int x0, int x1, LsfitAcc a, int n, InfoFloor1 info) {
        int quantized = this.dBquant(flr, x0);
        int xa = 0;
        int ya = 0;
        int x2a = 0;
        int y2a = 0;
        int xya = 0;
        int na = 0;
        int xb = 0;
        int yb = 0;
        int x2b = 0;
        int y2b = 0;
        int xyb = 0;
        int nb = 0;
        a.x0 = x0;
        a.x1 = x1;
        if (x1 >= n) {
            x1 = n - 1;
        }
        int i = x0;
        while (i <= x1) {
            quantized = this.dBquant(flr, i);
            if (quantized != 0) {
                if (mdct[i + pmdct] + info.twofitatten >= flr[i]) {
                    xa += i;
                    ya += quantized;
                    x2a += i * i;
                    y2a += quantized * quantized;
                    xya += i * quantized;
                    ++na;
                } else {
                    xb += i;
                    yb += quantized;
                    x2b += i * i;
                    y2b += quantized * quantized;
                    xyb += i * quantized;
                    ++nb;
                }
            }
            ++i;
        }
        xb += xa;
        yb += ya;
        x2b += x2a;
        y2b += y2a;
        xyb += xya;
        int weight = (int)((float)(nb += na) * info.twofitweight / (float)(na + 1));
        a.xa = xa * weight + xb;
        a.ya = ya * weight + yb;
        a.x2a = x2a * weight + x2b;
        a.y2a = y2a * weight + y2b;
        a.xya = xya * weight + xyb;
        a.an = na * weight + nb;
        return na;
    }

    private void fitLine(LsfitAcc[] ac, int pfits, int fits, para yy) {
        int x = 0;
        int y = 0;
        int x2 = 0;
        int y2 = 0;
        int xy = 0;
        int an = 0;
        int x0 = ac[pfits].x0;
        int x1 = ac[fits - 1 + pfits].x1;
        int i = 0;
        while (i < fits) {
            x += ac[i + pfits].xa;
            y += ac[i + pfits].ya;
            x2 += ac[i + pfits].x2a;
            y2 += ac[i + pfits].y2a;
            xy += ac[i + pfits].xya;
            an += ac[i + pfits].an;
            ++i;
        }
        if (yy.y0 >= 0) {
            x += x0;
            y += yy.y0;
            x2 += x0 * x0;
            y2 += yy.y0 * yy.y0;
            xy += yy.y0 * x0;
            ++an;
        }
        if (yy.y1 >= 0) {
            x += x1;
            y += yy.y1;
            x2 += x1 * x1;
            y2 += yy.y1 * yy.y1;
            xy += yy.y1 * x1;
            ++an;
        }
        if (an != 0) {
            double fx = x;
            double fy = y;
            double fx2 = x2;
            double fxy = xy;
            double denom = 1.0 / ((double)an * fx2 - fx * fx);
            double a = (fy * fx2 - fxy * fx) * denom;
            double b = ((double)an * fxy - fx * fy) * denom;
            yy.y0 = (int)Math.rint(a + b * (double)x0);
            yy.y1 = (int)Math.rint(a + b * (double)x1);
            if (yy.y0 > 1023) {
                yy.y0 = 1023;
            }
            if (yy.y1 > 1023) {
                yy.y1 = 1023;
            }
            if (yy.y0 < 0) {
                yy.y0 = 0;
            }
            if (yy.y1 < 0) {
                yy.y1 = 0;
            }
        } else {
            yy.y0 = 0;
            yy.y1 = 0;
        }
    }

    int post_Y(int[] A, int[] B, int pos) {
        if (A[pos] < 0) {
            return B[pos];
        }
        if (B[pos] < 0) {
            return A[pos];
        }
        return A[pos] + B[pos] >> 1;
    }

    private void renderLine0(int x0, int x1, int y0, int y1, int[] d) {
        int dy = y1 - y0;
        int adx = x1 - x0;
        int ady = Math.abs(dy);
        int base = dy / adx;
        int sy = dy < 0 ? base - 1 : base + 1;
        int x = x0;
        int y = y0;
        int err = 0;
        ady -= Math.abs(base * adx);
        d[x] = y;
        while (++x < x1) {
            if ((err += ady) >= adx) {
                err -= adx;
                y += sy;
            } else {
                y += base;
            }
            d[x] = y;
        }
    }

    public int encode(Block vb, Buffer opb, int inlook, int[] post, int[] ilogmask) {
        CodecSetupInfo ci = vb.dspState.vi.getCodecSetup();
        StaticCodeBook[] sbooks = ci.bookParam;
        CodeBook[] books = ci.fullBooks;
        PrivateState backEndState = vb.dspState.backEndState;
        LookFloor1 lookFloor1 = (LookFloor1)vb.dspState.backEndState.flr[inlook];
        InfoFloor1 info = lookFloor1.vi;
        int n = lookFloor1.n;
        int posts = lookFloor1.posts;
        int[] out = new int[65];
        int seq = 0;
        if (post != null) {
            int i = 0;
            while (i < posts) {
                int val = post[i] & Short.MAX_VALUE;
                switch (info.mult) {
                    case 1: {
                        val >>= 2;
                        break;
                    }
                    case 2: {
                        val >>= 3;
                        break;
                    }
                    case 3: {
                        val /= 12;
                        break;
                    }
                    case 4: {
                        val >>= 4;
                    }
                }
                post[i] = val | post[i] & 0x8000;
                ++i;
            }
            out[0] = post[0];
            out[1] = post[1];
            i = 2;
            while (i < posts) {
                int ln = lookFloor1.loneighBor[i - 2];
                int hn = lookFloor1.hineighBor[i - 2];
                int x0 = info.postlist[ln];
                int x1 = info.postlist[hn];
                int y0 = post[ln];
                int y1 = post[hn];
                int predicted = this.renderPoint(x0, x1, y0, y1, info.postlist[i]);
                if ((post[i] & 0x8000) != 0 || predicted == post[i]) {
                    post[i] = predicted | 0x8000;
                    out[i] = 0;
                } else {
                    int headroom = lookFloor1.quant_q - predicted < predicted ? lookFloor1.quant_q - predicted : predicted;
                    int val = post[i] - predicted;
                    val = val < 0 ? (val < -headroom ? headroom - val - 1 : -1 - (val << 1)) : (val >= headroom ? (val += headroom) : (val <<= 1));
                    out[i] = val;
                    int n2 = ln;
                    post[n2] = post[n2] & Short.MAX_VALUE;
                    int n3 = hn;
                    post[n3] = post[n3] & Short.MAX_VALUE;
                }
                ++i;
            }
            opb.write(1, 1);
            ++lookFloor1.frames;
            lookFloor1.postbits += this.ilog(lookFloor1.quant_q - 1) * 2;
            opb.write(out[0], this.ilog(lookFloor1.quant_q - 1));
            opb.write(out[1], this.ilog(lookFloor1.quant_q - 1));
            i = 0;
            int j = 2;
            while (i < info.partitions) {
                int k;
                int clas = info.partitionclass[i];
                int cdim = info.class_dim[clas];
                int csubbits = info.class_subs[clas];
                int csub = 1 << csubbits;
                int[] bookas = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
                int cval = 0;
                int cshift = 0;
                if (csubbits != 0) {
                    int[] maxval = new int[8];
                    k = 0;
                    while (k < csub) {
                        int booknum = info.class_subbook[clas][k];
                        maxval[k] = booknum < 0 ? 1 : sbooks[info.class_subbook[clas][k]].entries;
                        ++k;
                    }
                    k = 0;
                    while (k < cdim) {
                        int l = 0;
                        while (l < csub) {
                            int val = out[j + k];
                            if (val < maxval[l]) {
                                bookas[k] = l;
                                break;
                            }
                            ++l;
                        }
                        cval |= bookas[k] << cshift;
                        cshift += csubbits;
                        ++k;
                    }
                    lookFloor1.phrasebits += books[info.class_book[clas]].bookEncode(cval, opb);
                }
                k = 0;
                while (k < cdim) {
                    int book = info.class_subbook[clas][bookas[k]];
                    if (book >= 0 && out[j + k] < books[book].entries) {
                        lookFloor1.postbits += books[book].bookEncode(out[j + k], opb);
                    }
                    ++k;
                }
                j += cdim;
                ++i;
            }
            int hx = 0;
            int lx = 0;
            int ly = post[0] * info.mult;
            j = 1;
            while (j < lookFloor1.posts) {
                int current = lookFloor1.forwardIndex[j];
                int hy = post[current] & Short.MAX_VALUE;
                if (hy == post[current]) {
                    hx = info.postlist[current];
                    this.renderLine0(lx, hx, ly, hy *= info.mult, ilogmask);
                    lx = hx;
                    ly = hy;
                }
                ++j;
            }
            j = hx;
            while (j < vb.pcmEnd / 2) {
                ilogmask[j] = ly;
                ++j;
            }
            ++seq;
            return 1;
        }
        opb.write(0, 1);
        ilogmask = new int[vb.pcmEnd / 2];
        ++seq;
        return 0;
    }

    public int[] fit(Block vb, int inlook, float[] logmdct, int plogmdct, float[] logmask) {
        int i;
        LookFloor1 _look = (LookFloor1)vb.dspState.backEndState.flr[inlook];
        InfoFloor1 info = _look.vi;
        int n = _look.n;
        int posts = _look.posts;
        int nonzero = 0;
        LsfitAcc[] fits = new LsfitAcc[64];
        int[] fit_valueA = new int[65];
        int[] fit_valueB = new int[65];
        int[] loneighbor = new int[65];
        int[] hineighbor = new int[65];
        int[] output = null;
        int[] memo = new int[65];
        if (val1.length < posts) {
            val200n = new int[posts];
            val1 = new int[posts];
            val1n = new int[posts];
            i = 0;
            while (i < posts) {
                Floor1.val200n[i] = -200;
                Floor1.val1[i] = 1;
                Floor1.val1n[i] = -1;
                ++i;
            }
        }
        System.arraycopy(val200n, 0, fit_valueA, 0, posts);
        System.arraycopy(val200n, 0, fit_valueB, 0, posts);
        System.arraycopy(val1, 0, hineighbor, 0, posts);
        System.arraycopy(val1n, 0, memo, 0, posts);
        if (posts == 0) {
            fits[0] = new LsfitAcc();
            nonzero += this.accumulateFit(logmask, logmdct, plogmdct, 0, n, fits[0], n, info);
        } else {
            i = 0;
            while (i < posts - 1) {
                fits[i] = new LsfitAcc();
                nonzero += this.accumulateFit(logmask, logmdct, plogmdct, _look.sortedIndex[i], _look.sortedIndex[i + 1], fits[i], n, info);
                ++i;
            }
        }
        if (nonzero != 0) {
            int y0 = -200;
            int y1 = -200;
            para yy = new para(y0, y1);
            this.fitLine(fits, 0, posts - 1, yy);
            fit_valueA[0] = yy.y0;
            fit_valueB[0] = yy.y0;
            fit_valueB[1] = yy.y1;
            fit_valueA[1] = yy.y1;
            i = 2;
            while (i < posts) {
                int sortpos = _look.reverseIndex[i];
                int ln = loneighbor[sortpos];
                int hn = hineighbor[sortpos];
                if (memo[ln] != hn) {
                    int lsortpos = _look.reverseIndex[ln];
                    int hsortpos = _look.reverseIndex[hn];
                    memo[ln] = hn;
                    int lx = info.postlist[ln];
                    int hx = info.postlist[hn];
                    int ly = this.post_Y(fit_valueA, fit_valueB, ln);
                    int hy = this.post_Y(fit_valueA, fit_valueB, hn);
                    if (ly == -1 || hy == -1) {
                        System.exit(1);
                    }
                    if (this.inspectError(lx, hx, ly, hy, logmask, logmdct, plogmdct, info) != 0) {
                        int ly0 = -200;
                        int ly1 = -200;
                        int hy0 = -200;
                        int hy1 = -200;
                        para lyy = new para(ly0, ly1);
                        this.fitLine(fits, lsortpos, sortpos - lsortpos, lyy);
                        para hyy = new para(hy0, hy1);
                        this.fitLine(fits, sortpos, hsortpos - sortpos, hyy);
                        fit_valueB[ln] = lyy.y0;
                        if (ln == 0) {
                            fit_valueA[ln] = lyy.y0;
                        }
                        fit_valueA[i] = lyy.y1;
                        fit_valueB[i] = hyy.y0;
                        fit_valueA[hn] = hyy.y1;
                        if (hn == 1) {
                            fit_valueB[hn] = hyy.y1;
                        }
                        if (lyy.y1 >= 0 || hyy.y0 >= 0) {
                            int j = sortpos - 1;
                            while (j >= 0) {
                                if (hineighbor[j] != hn) break;
                                hineighbor[j] = i;
                                --j;
                            }
                            j = sortpos + 1;
                            while (j < posts) {
                                if (loneighbor[j] == ln) {
                                    loneighbor[j] = i;
                                    ++j;
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        fit_valueA[i] = -200;
                        fit_valueB[i] = -200;
                    }
                }
                ++i;
            }
            output = new int[posts];
            output[0] = this.post_Y(fit_valueA, fit_valueB, 0);
            output[1] = this.post_Y(fit_valueA, fit_valueB, 1);
            i = 2;
            while (i < posts) {
                int ln = _look.loneighBor[i - 2];
                int hn = _look.hineighBor[i - 2];
                int x0 = info.postlist[ln];
                int x1 = info.postlist[hn];
                y0 = output[ln];
                y1 = output[hn];
                int predicted = this.renderPoint(x0, x1, y0, y1, info.postlist[i]);
                int vx = this.post_Y(fit_valueA, fit_valueB, i);
                output[i] = vx >= 0 && predicted != vx ? vx : predicted | 0x8000;
                ++i;
            }
        }
        return output;
    }

    public int[] interpolate(Block vb, int inlook, int[] A, int[] B, int del) {
        LookFloor1 _look = (LookFloor1)vb.dspState.backEndState.flr[inlook];
        int posts = _look.posts;
        int[] output = null;
        if (A != null && B != null) {
            output = new int[posts];
            int i = 0;
            while (i < posts) {
                output[i] = (65536 - del) * (A[i] & Short.MAX_VALUE) + del * (B[i] & Short.MAX_VALUE) + 32768 >> 16;
                if ((A[i] & 0x8000) != 0 && (B[i] & 0x8000) != 0) {
                    int n = i;
                    output[n] = output[n] | 0x8000;
                }
                ++i;
            }
        }
        return output;
    }

    private int ilog(int v) {
        int ret = 0;
        while (v != 0) {
            ++ret;
            v >>>= 1;
        }
        return ret;
    }

    private int ilog2(int v) {
        int ret = 0;
        while (v > 1) {
            ++ret;
            v >>>= 1;
        }
        return ret;
    }
}

