/*
 * Decompiled with CFR 0.152.
 */
package biniu.vorbis;

import biniu.vorbis.Drft;

public class Lpc {
    private Drft fft = new Drft();
    private int ln;
    private int m;

    public void init(int mapped, int m) {
        this.ln = mapped;
        this.m = m;
        this.fft.init(mapped * 2);
    }

    public void clear() {
        this.fft.clear();
    }

    public void lpcToCurve(float[] curve, float[] lpc, float amp) {
        int i = 0;
        while (i < this.ln * 2) {
            curve[i] = 0.0f;
            ++i;
        }
        if (amp == 0.0f) {
            return;
        }
        int i2 = 0;
        while (i2 < this.m) {
            curve[i2 * 2 + 1] = lpc[i2] / (4.0f * amp);
            curve[i2 * 2 + 2] = -lpc[i2] / (4.0f * amp);
            ++i2;
        }
        this.fft.backward(curve);
        int l2 = this.ln * 2;
        float unit = (float)(1.0 / (double)amp);
        curve[0] = (float)(1.0 / (double)(curve[0] * 2.0f + unit));
        int i3 = 1;
        while (i3 < this.ln) {
            float real = curve[i3] + curve[l2 - i3];
            float imag = curve[i3] - curve[l2 - i3];
            float a = real + unit;
            curve[i3] = (float)(1.0 / (double)this.fastHypot(a, imag));
            ++i3;
        }
    }

    public float lpcFromCurve(float[] curve, float[] lpc) {
        int n = this.ln;
        float[] work = new float[n + n];
        float fscale = (float)(0.5 / (double)n);
        int i = 0;
        while (i < n) {
            work[i * 2] = curve[i] * fscale;
            work[i * 2 + 1] = 0.0f;
            ++i;
        }
        work[n * 2 - 1] = curve[n - 1] * fscale;
        this.fft.backward(work);
        i = 0;
        int j = (n *= 2) / 2;
        while (i < n / 2) {
            float temp = work[i];
            work[i++] = work[j];
            work[j++] = temp;
        }
        return Lpc.lpcFromData(work, 0, lpc, n, this.m);
    }

    static float lpcFromData(float[] data, int ndata, float[] lpc, int n, int m) {
        int i;
        double[] aut = new double[m + 1];
        int j = m + 1;
        while (j-- != 0) {
            double d = 0.0;
            i = j;
            while (i < n) {
                d += (double)(data[i + ndata] * data[i - j + ndata]);
                ++i;
            }
            aut[j] = d;
        }
        double error = aut[0];
        i = 0;
        while (i < m) {
            double r = -aut[i + 1];
            if (error == 0.0) {
                int k = 0;
                while (k < m) {
                    lpc[k] = 0.0f;
                    ++k;
                }
                return 0.0f;
            }
            j = 0;
            while (j < i) {
                r -= (double)lpc[j] * aut[i - j];
                ++j;
            }
            lpc[i] = (float)(r /= error);
            j = 0;
            while (j < i / 2) {
                float tmp = lpc[j];
                int n2 = j;
                lpc[n2] = (float)((double)lpc[n2] + r * (double)lpc[i - 1 - j]);
                int n3 = i - 1 - j;
                lpc[n3] = (float)((double)lpc[n3] + r * (double)tmp);
                ++j;
            }
            if (i % 2 != 0) {
                int n4 = j;
                lpc[n4] = (float)((double)lpc[n4] + (double)lpc[j] * r);
            }
            error *= 1.0 - r * r;
            ++i;
        }
        return (float)error;
    }

    static float lpcFromDataZ(float[] data, float[] lpci, int n, int m, int current) {
        int i;
        double[] aut = new double[m + 1];
        double[] lpc = new double[m];
        int j = m + 1;
        int gr = current - n;
        while (j-- != 0) {
            double d = 0.0;
            i = current + 10;
            while (i-- > gr) {
                d += (double)data[i - j] * (double)data[i];
            }
            aut[j] = d;
        }
        double error = aut[0];
        i = 0;
        while (i < m) {
            double r = -aut[i + 1];
            if (error == 0.0) {
                int k = m;
                while (--k >= 0) {
                    lpci[k] = 0.0f;
                }
                return 0.0f;
            }
            j = 0;
            while (j < i) {
                r -= lpc[j] * aut[i - j];
                ++j;
            }
            lpc[i] = r /= error;
            j = 0;
            while (j < i / 2) {
                double tmp = lpc[j];
                int n2 = j;
                lpc[n2] = lpc[n2] + r * lpc[i - 1 - j];
                int n3 = i - 1 - j;
                lpc[n3] = lpc[n3] + r * tmp;
                ++j;
            }
            if (i % 2 != 0) {
                int n4 = j;
                lpc[n4] = lpc[n4] + lpc[j] * r;
            }
            error *= 1.0 - r * r;
            ++i;
        }
        j = 0;
        while (j < m) {
            lpci[j] = (float)lpc[j];
            ++j;
        }
        return (float)error;
    }

    static void lpcPredict(float[] coeff, float[] prime, int nprime, int m, float[] data, int ndata, int n) {
        float[] work = new float[m + n];
        if (prime != null) {
            System.arraycopy(prime, nprime, work, 0, m);
        }
        int i = 0;
        while (i < n) {
            float y = 0.0f;
            int o = i;
            int p = m;
            int j = 0;
            while (j < m) {
                y -= work[o++] * coeff[--p];
                ++j;
            }
            data[i + ndata] = work[o] = y;
            ++i;
        }
    }

    static void lpcPredictZ(float[] coeff, float[] prime, int nprime, int m, float[] data, int ndata, int n) {
        float[] work = new float[m + n];
        int i = m + n;
        while (i-- > n) {
            work[i] = prime[i];
        }
        i = n;
        while (i-- > 0) {
            float y = 0.0f;
            int o = i + m;
            int j = m;
            while (--j >= 0) {
                y -= work[o--] * coeff[j];
            }
            data[ndata--] = work[o] = y;
        }
    }

    private float fastHypot(float a, float b) {
        return (float)Math.sqrt(a * a + b * b);
    }
}

