/*
 * Decompiled with CFR 0.152.
 */
package biniu.vorbis;

import biniu.vorbis.AdjStereo;
import biniu.vorbis.Att3;
import biniu.vorbis.CodecSetupInfo;
import biniu.vorbis.CompandBlock;
import biniu.vorbis.HighlevelEncodeSetup;
import biniu.vorbis.Info;
import biniu.vorbis.InfoFloor1;
import biniu.vorbis.InfoMapping0;
import biniu.vorbis.InfoMode;
import biniu.vorbis.InfoPsyGlobal;
import biniu.vorbis.InfoResidue0;
import biniu.vorbis.Noise3;
import biniu.vorbis.NoiseGuard;
import biniu.vorbis.OvectlRatemanageArg;
import biniu.vorbis.OvectlRatemanageArg2;
import biniu.vorbis.PsyInfo;
import biniu.vorbis.StaticCodeBook;
import biniu.vorbis.VeSetupDataTemplate;
import biniu.vorbis.VorbisMappingTemplate;
import biniu.vorbis.VorbisResidueTemplate;
import biniu.vorbis.VpAdjBlock;
import biniu.vorbis.modes.Psych44;
import biniu.vorbis.modes.Setup11;
import biniu.vorbis.modes.Setup16;
import biniu.vorbis.modes.Setup22;
import biniu.vorbis.modes.Setup32;
import biniu.vorbis.modes.Setup44;
import biniu.vorbis.modes.Setup44u;
import biniu.vorbis.modes.Setup8;
import biniu.vorbis.modes.SetupX;

public class VorbisEnc {
    private CodecSetupInfo ci;
    private Info vi;
    private HighlevelEncodeSetup hi;
    static InfoMode[] _mode_template = new InfoMode[]{new InfoMode(0, 0, 0, 0), new InfoMode(1, 0, 0, 1)};
    public static VeSetupDataTemplate[] setupList = new VeSetupDataTemplate[]{Setup44.ve_setup_44_stereo, Setup44u.ve_setup_44_uncoupled, Setup32.ve_setup_32_stereo, Setup32.ve_setup_32_uncoupled, Setup22.ve_setup_22_stereo, Setup22.ve_setup_22_uncoupled, Setup16.ve_setup_16_stereo, Setup16.ve_setup_16_uncoupled, Setup11.ve_setup_11_stereo, Setup11.ve_setup_11_uncoupled, Setup8.ve_setup_8_stereo, Setup8.ve_setup_8_uncoupled, SetupX.ve_setup_X_stereo, SetupX.ve_setup_X_uncoupled, SetupX.ve_setup_XX_stereo, SetupX.ve_setup_XX_uncoupled, null};

    private int setTopLevel(int ch, int rate) {
        this.vi.version = 0;
        this.vi.channels = ch;
        this.vi.rate = rate;
        return 0;
    }

    private void setFloor(double s, int block, StaticCodeBook[][] books, InfoFloor1[] in, int[] x) {
        int is = (int)s;
        InfoFloor1 f = new InfoFloor1();
        f.setValue(in[x[is]]);
        f.n = this.ci.blocksizes[block] >> 1;
        int partitions = f.partitions;
        int maxclass = -1;
        int maxbook = -1;
        int i = 0;
        while (i < partitions) {
            if (f.partitionclass[i] > maxclass) {
                maxclass = f.partitionclass[i];
            }
            ++i;
        }
        i = 0;
        while (i <= maxclass) {
            if (f.class_book[i] > maxbook) {
                maxbook = f.class_book[i];
            }
            int n = i;
            f.class_book[n] = f.class_book[n] + this.ci.books;
            int k = 0;
            while (k < 1 << f.class_subs[i]) {
                if (f.class_subbook[i][k] > maxbook) {
                    maxbook = f.class_subbook[i][k];
                }
                if (f.class_subbook[i][k] >= 0) {
                    int[] nArray = f.class_subbook[i];
                    int n2 = k;
                    nArray[n2] = nArray[n2] + this.ci.books;
                }
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i <= maxbook) {
            this.ci.bookParam[this.ci.books++] = books[x[is]][i];
            ++i;
        }
        this.ci.floorType[this.ci.floors] = 1;
        this.ci.floorParam[this.ci.floors] = f;
        ++this.ci.floors;
    }

    private void setGlobalPsych(double s, InfoPsyGlobal[] in, double[] x) {
        int is = (int)s;
        double ds = s - (double)is;
        InfoPsyGlobal g = this.ci.psyGlobParam;
        g.setValue(in[(int)x[is]]);
        ds = x[is] * (1.0 - ds) + x[is + 1] * ds;
        is = (int)ds;
        if ((ds -= (double)is) == 0.0 && is > 0) {
            --is;
            ds = 1.0;
        }
        int i = 0;
        while (i < 4) {
            g.preecho_thresh[i] = (float)((double)in[is].preecho_thresh[i] * (1.0 - ds) + (double)in[is + 1].preecho_thresh[i] * ds);
            g.postecho_thresh[i] = (float)((double)in[is].postecho_thresh[i] * (1.0 - ds) + (double)in[is + 1].postecho_thresh[i] * ds);
            ++i;
        }
        g.ampmax_att_per_sec = (float)this.ci.hiEncSet.amplitude_track_dBpersec;
    }

    private void initGlobalStereo(AdjStereo[] p) {
        float s = (float)this.hi.stereo_point_setting;
        int is = (int)s;
        double ds = s - (float)is;
        InfoPsyGlobal g = this.ci.psyGlobParam;
        if (p != null) {
            g.coupling_prepointamp = p[is].pre;
            g.coupling_postpointamp = p[is].post;
            if (this.hi.managed == 1) {
                int i = 0;
                while (i < 15) {
                    float kHz = (float)((double)p[is].kHz[i] * (1.0 - ds) + (double)p[is + 1].kHz[i] * ds);
                    g.coupling_pointlimit[0][i] = (int)((double)kHz * 1000.0 / (double)this.vi.rate * (double)this.ci.blocksizes[0]);
                    g.coupling_pointlimit[1][i] = (int)((double)kHz * 1000.0 / (double)this.vi.rate * (double)this.ci.blocksizes[1]);
                    g.coupling_pkHz[i] = (int)kHz;
                    kHz = (int)((double)p[is].lowpasskHz[i] * (1.0 - ds) + (double)p[is + 1].lowpasskHz[i] * ds);
                    g.sliding_lowpass[0][i] = (int)((double)kHz * 1000.0 / (double)this.vi.rate * (double)this.ci.blocksizes[0]);
                    g.sliding_lowpass[1][i] = (int)((double)kHz * 1000.0 / (double)this.vi.rate * (double)this.ci.blocksizes[1]);
                    ++i;
                }
            } else {
                float kHz = (float)((double)p[is].kHz[7] * (1.0 - ds) + (double)p[is + 1].kHz[7] * ds);
                int i = 0;
                while (i < 15) {
                    g.coupling_pointlimit[0][i] = (int)((double)kHz * 1000.0 / (double)this.vi.rate * (double)this.ci.blocksizes[0]);
                    g.coupling_pointlimit[1][i] = (int)((double)kHz * 1000.0 / (double)this.vi.rate * (double)this.ci.blocksizes[1]);
                    g.coupling_pkHz[i] = (int)kHz;
                    ++i;
                }
                kHz = (int)((double)p[is].lowpasskHz[7] * (1.0 - ds) + (double)p[is + 1].lowpasskHz[7] * ds);
                i = 0;
                while (i < 15) {
                    g.sliding_lowpass[0][i] = (int)((double)kHz * 1000.0 / (double)this.vi.rate * (double)this.ci.blocksizes[0]);
                    g.sliding_lowpass[1][i] = (int)((double)kHz * 1000.0 / (double)this.vi.rate * (double)this.ci.blocksizes[1]);
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < 15) {
                g.sliding_lowpass[0][i] = this.ci.blocksizes[0];
                g.sliding_lowpass[1][i] = this.ci.blocksizes[1];
                ++i;
            }
        }
    }

    private void setPsyset(double s, int[] nn_start, int[] nn_partition, double[] nn_thresh, int block) {
        PsyInfo p = this.ci.psyParam[block];
        int is = (int)s;
        if (block >= this.ci.psys) {
            this.ci.psys = block + 1;
        }
        if (p != null) {
            this.ci.psyParam[block] = p;
        }
        p.setValues(Psych44._psy_info_template);
        p.blockflag = block >> 1;
        if (this.hi.noise_normalize_p == 1) {
            p.normal_channel_p = 1;
            p.normal_point_p = 1;
            p.normal_start = nn_start[is];
            p.normal_partition = nn_partition[is];
            p.normal_thresh = nn_thresh[is];
        }
    }

    private void setTonemask(double s, int block, Att3[] att, int[] max, VpAdjBlock[] in) {
        int is = (int)s;
        double ds = s - (double)is;
        PsyInfo p = this.ci.psyParam[block];
        p.tone_masteratt[0] = (float)((double)att[is].att[0] * (1.0 - ds) + (double)att[is + 1].att[0] * ds);
        p.tone_masteratt[1] = (float)((double)att[is].att[1] * (1.0 - ds) + (double)att[is + 1].att[1] * ds);
        p.tone_masteratt[2] = (float)((double)att[is].att[2] * (1.0 - ds) + (double)att[is + 1].att[2] * ds);
        p.tone_centerboost = (float)((double)att[is].boost * (1.0 - ds) + (double)att[is + 1].boost * ds);
        p.tone_decay = (float)((double)att[is].decay * (1.0 - ds) + (double)att[is + 1].decay * ds);
        p.max_curve_dB = (float)((double)max[is] * (1.0 - ds) + (double)max[is + 1] * ds);
        int i = 0;
        while (i < 17) {
            p.toneatt[i] = (float)((double)in[is].block[i] * (1.0 - ds) + (double)in[is + 1].block[i] * ds);
            ++i;
        }
    }

    private void setCompandBlock(double s, int block, CompandBlock[] in, double[] x) {
        int is = (int)s;
        double ds = s - (double)is;
        PsyInfo p = this.ci.psyParam[block];
        ds = x[is] * (1.0 - ds) + x[is + 1] * ds;
        if ((ds -= (double)(is = (int)ds)) == 0.0 && is > 0) {
            --is;
            ds = 1.0;
        }
        int i = 0;
        while (i < 40) {
            p.noisecompand[i] = (float)((double)in[is].data[i] * (1.0 - ds) + (double)in[is + 1].data[i] * ds);
            ++i;
        }
    }

    private void setPeak(double s, int block, int[] suppress) {
        int is = (int)s;
        double ds = s - (double)is;
        PsyInfo p = this.ci.psyParam[block];
        p.tone_abs_limit = (float)((double)suppress[is] * (1.0 - ds) + (double)suppress[is + 1] * ds);
    }

    private void setNoisebias(double s, int block, int[] suppress, Noise3[] in, NoiseGuard[] guard, double userbias) {
        int i;
        int is = (int)s;
        double ds = s - (double)is;
        PsyInfo p = this.ci.psyParam[block];
        p.noisemaxsupp = (float)((double)suppress[is] * (1.0 - ds) + (double)suppress[is + 1] * ds);
        p.noisewindowlomin = guard[block].lo;
        p.noisewindowhimin = guard[block].hi;
        p.noisewindowfixed = guard[block].fixed;
        int j = 0;
        while (j < 3) {
            i = 0;
            while (i < 17) {
                p.noiseoff[j][i] = (float)((double)in[is].data[j][i] * (1.0 - ds) + (double)in[is + 1].data[j][i] * ds);
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < 3) {
            float min = p.noiseoff[j][0] + 6.0f;
            i = 0;
            while (i < 17) {
                float[] fArray = p.noiseoff[j];
                int n = i;
                fArray[n] = (float)((double)fArray[n] + userbias);
                if (p.noiseoff[j][i] < min) {
                    p.noiseoff[j][i] = min;
                }
                ++i;
            }
            ++j;
        }
    }

    private void setAth(int block) {
        PsyInfo p = this.ci.psyParam[block];
        p.ath_adjatt = (float)this.ci.hiEncSet.ath_floating_dB;
        p.ath_maxatt = (float)this.ci.hiEncSet.ath_absolute_dB;
    }

    private int bookDupOrNew(StaticCodeBook book) {
        int i = 0;
        while (i < this.ci.books) {
            if (this.ci.bookParam[i] == book) {
                return i;
            }
            ++i;
        }
        return this.ci.books++;
    }

    private void setBlocksize(double s, int[] shortb, int[] longb) {
        int is = (int)s;
        int blockshort = shortb[is];
        int blocklong = longb[is];
        this.ci.blocksizes[0] = blockshort;
        this.ci.blocksizes[1] = blocklong;
    }

    private void setResidue(int number, int block, VorbisResidueTemplate res) {
        int bookid;
        if (this.ci.residueParam[number] == null) {
            this.ci.residueParam[number] = new InfoResidue0();
        }
        InfoResidue0 r = this.ci.residueParam[number];
        r.setValues(res.res);
        if (this.ci.residues <= number) {
            this.ci.residues = number + 1;
        }
        switch (this.ci.blocksizes[block]) {
            case 64: 
            case 128: 
            case 256: {
                r.grouping = 16;
                break;
            }
            default: {
                r.grouping = 32;
            }
        }
        this.ci.residueType[number] = res.res_type;
        int n = r.end = this.ci.blocksizes[block] >> 1;
        if (res.res_type == 2) {
            n = r.end *= this.vi.channels;
        }
        int booklist = 0;
        if (this.ci.hiEncSet.managed != 0) {
            int k;
            int i = 0;
            while (i < r.partitions) {
                k = 0;
                while (k < 3) {
                    if (res.books_base_managed[i][k] != null) {
                        int n2 = i;
                        r.secondstages[n2] = r.secondstages[n2] | 1 << k;
                    }
                    ++k;
                }
                ++i;
            }
            r.groupbook = this.bookDupOrNew(res.book_aux_managed);
            this.ci.bookParam[r.groupbook] = res.book_aux_managed;
            i = 0;
            while (i < r.partitions) {
                k = 0;
                while (k < 3) {
                    if (res.books_base_managed[i][k] != null) {
                        bookid = this.bookDupOrNew(res.books_base_managed[i][k]);
                        r.booklist[booklist++] = bookid;
                        this.ci.bookParam[bookid] = res.books_base_managed[i][k];
                    }
                    ++k;
                }
                ++i;
            }
        } else {
            int k;
            int i = 0;
            while (i < r.partitions) {
                k = 0;
                while (k < 3) {
                    if (res.books_base[i][k] != null) {
                        int n3 = i;
                        r.secondstages[n3] = r.secondstages[n3] | 1 << k;
                    }
                    ++k;
                }
                ++i;
            }
            r.groupbook = this.bookDupOrNew(res.book_aux);
            this.ci.bookParam[r.groupbook] = res.book_aux;
            i = 0;
            while (i < r.partitions) {
                k = 0;
                while (k < 3) {
                    if (res.books_base_managed[i][k] != null) {
                        bookid = this.bookDupOrNew(res.books_base[i][k]);
                        r.booklist[booklist++] = bookid;
                        this.ci.bookParam[bookid] = res.books_base[i][k];
                    }
                    ++k;
                }
                ++i;
            }
        }
        double freq = this.ci.hiEncSet.lowpass_kHz * 1000.0;
        InfoFloor1 f = this.ci.floorParam[block];
        double nyq = (double)this.vi.rate / 2.0;
        int blocksize = this.ci.blocksizes[block] >> 1;
        if (freq > nyq) {
            freq = nyq;
        }
        f.n = (int)(freq / nyq * (double)blocksize);
        if (res.limit_type == 1 && (freq = this.ci.hiEncSet.managed == 1 ? (double)this.ci.psyGlobParam.coupling_pkHz[14] * 1000.0 : (double)this.ci.psyGlobParam.coupling_pkHz[7] * 1000.0) > nyq) {
            freq = nyq;
        }
        r.end = this.ci.residueType[block] == 2 ? (int)(freq / nyq * (double)blocksize * 2.0 / (double)r.grouping + 0.9) * r.grouping : (int)(freq / nyq * (double)blocksize / (double)r.grouping + 0.9) * r.grouping;
    }

    private void setMapRes(double s, VorbisMappingTemplate[] maps) {
        int is = (int)s;
        int modes = 2;
        InfoMapping0[] map = maps[is].map;
        InfoMode[] mode = _mode_template;
        VorbisResidueTemplate[] res = maps[is].res;
        if (this.ci.blocksizes[0] == this.ci.blocksizes[1]) {
            modes = 1;
        }
        int i = 0;
        while (i < modes) {
            if (this.ci.mapParam[i] == null) {
                this.ci.mapParam[i] = new InfoMapping0();
            }
            if (this.ci.modeParam[i] == null) {
                this.ci.modeParam[i] = new InfoMode();
            }
            this.ci.modeParam[i].setValues(mode[i]);
            if (i >= this.ci.modes) {
                this.ci.modes = i + 1;
            }
            this.ci.mapType[i] = 0;
            this.ci.mapParam[i].setValues(map[i]);
            if (i >= this.ci.maps) {
                this.ci.maps = i + 1;
            }
            int j = 0;
            while (j < map[i].submaps) {
                this.setResidue(map[i].residuesubmap[j], i, res[map[i].residuesubmap[j]]);
                ++j;
            }
            ++i;
        }
    }

    private double setApproxBitrate() {
        VeSetupDataTemplate setup = (VeSetupDataTemplate)this.hi.setup;
        int is = (int)this.hi.base_setting;
        double ds = this.hi.base_setting - (double)is;
        int ch = this.vi.channels;
        double[] r = setup.rate_mapping;
        if (r == null) {
            return -1.0;
        }
        return (r[is] * (1.0 - ds) + r[is + 1] * ds) * (double)ch;
    }

    private void getSetupTemplate(int ch, int srate, double req, int q_or_bitrate) {
        int i = 0;
        if (q_or_bitrate == 1) {
            req /= (double)ch;
        }
        while (setupList[i] != null) {
            if ((VorbisEnc.setupList[i].coupling_restriction == -1 || VorbisEnc.setupList[i].coupling_restriction == ch) && srate >= VorbisEnc.setupList[i].samplerate_min_restriction && srate <= VorbisEnc.setupList[i].samplerate_max_restriction) {
                double[] map;
                int mappings = VorbisEnc.setupList[i].mappings;
                double[] dArray = map = q_or_bitrate == 1 ? VorbisEnc.setupList[i].rate_mapping : VorbisEnc.setupList[i].quality_mapping;
                if (req < map[0]) {
                    ++i;
                    continue;
                }
                if (req > map[VorbisEnc.setupList[i].mappings]) {
                    ++i;
                    continue;
                }
                int j = 0;
                while (j < mappings) {
                    if (req >= map[j] && req < map[j + 1]) break;
                    ++j;
                }
                this.hi.setup = setupList[i];
                if (j == mappings) {
                    this.hi.base_setting = (double)j - 0.001;
                } else {
                    float low = (float)map[j];
                    float high = (float)map[j + 1];
                    float del = (float)((req - (double)low) / (double)(high - low));
                    this.hi.base_setting = (float)j + del;
                }
                return;
            }
            ++i;
        }
        this.hi.setup = null;
    }

    private int setSetupInit() {
        int i0 = 0;
        boolean singleblock = false;
        VeSetupDataTemplate setup = null;
        if (this.ci == null) {
            return -131;
        }
        if (this.hi.impulse_block_p != 1) {
            i0 = 1;
        }
        if (this.hi.ath_floating_dB > -80.0) {
            this.hi.ath_floating_dB = -80.0;
        }
        if (this.hi.ath_floating_dB < -200.0) {
            this.hi.ath_floating_dB = -200.0;
        }
        if (this.hi.amplitude_track_dBpersec > 0.0) {
            this.hi.amplitude_track_dBpersec = 0.0;
        }
        if (this.hi.amplitude_track_dBpersec < -99999.0) {
            this.hi.amplitude_track_dBpersec = -99999.0;
        }
        if ((setup = (VeSetupDataTemplate)this.hi.setup) == null) {
            return -131;
        }
        this.hi.set_in_stone = 1;
        this.setBlocksize(this.hi.base_setting, setup.blocksize_short, setup.blocksize_long);
        if (this.ci.blocksizes[0] == this.ci.blocksizes[1]) {
            singleblock = true;
        }
        this.setFloor(this.hi.short_setting, 0, setup.floor_books, setup.floor_params, setup.floor_short_mapping);
        if (!singleblock) {
            this.setFloor(this.hi.long_setting, 1, setup.floor_books, setup.floor_params, setup.floor_long_mapping);
        }
        this.setGlobalPsych(this.hi.trigger_setting, setup.global_params, setup.global_mapping);
        this.initGlobalStereo(setup.stereo_modes);
        this.setPsyset(this.hi.short_setting, setup.psy_noise_normal_start[0], setup.psy_noise_normal_partition[0], setup.psy_noise_normal_thresh, 0);
        this.setPsyset(this.hi.short_setting, setup.psy_noise_normal_start[0], setup.psy_noise_normal_partition[0], setup.psy_noise_normal_thresh, 1);
        if (!singleblock) {
            this.setPsyset(this.hi.long_setting, setup.psy_noise_normal_start[1], setup.psy_noise_normal_partition[1], setup.psy_noise_normal_thresh, 2);
            this.setPsyset(this.hi.long_setting, setup.psy_noise_normal_start[1], setup.psy_noise_normal_partition[1], setup.psy_noise_normal_thresh, 3);
        }
        this.setTonemask(this.hi.block[i0].tone_mask_setting, 0, setup.psy_tone_masteratt, setup.psy_tone_0dB, setup.psy_tone_adj_impulse);
        this.setTonemask(this.hi.block[1].tone_mask_setting, 1, setup.psy_tone_masteratt, setup.psy_tone_0dB, setup.psy_tone_adj_other);
        if (!singleblock) {
            this.setTonemask(this.hi.block[2].tone_mask_setting, 2, setup.psy_tone_masteratt, setup.psy_tone_0dB, setup.psy_tone_adj_other);
            this.setTonemask(this.hi.block[3].tone_mask_setting, 3, setup.psy_tone_masteratt, setup.psy_tone_0dB, setup.psy_tone_adj_long);
        }
        this.setCompandBlock(this.hi.block[i0].noise_compand_setting, 0, setup.psy_noise_compand, setup.psy_noise_compand_short_mapping);
        this.setCompandBlock(this.hi.block[1].noise_compand_setting, 1, setup.psy_noise_compand, setup.psy_noise_compand_short_mapping);
        if (!singleblock) {
            this.setCompandBlock(this.hi.block[2].noise_compand_setting, 2, setup.psy_noise_compand, setup.psy_noise_compand_long_mapping);
            this.setCompandBlock(this.hi.block[3].noise_compand_setting, 3, setup.psy_noise_compand, setup.psy_noise_compand_long_mapping);
        }
        this.setPeak(this.hi.block[i0].tone_peaklimit_setting, 0, setup.psy_tone_dBsuppress);
        this.setPeak(this.hi.block[1].tone_peaklimit_setting, 1, setup.psy_tone_dBsuppress);
        if (!singleblock) {
            this.setPeak(this.hi.block[2].tone_peaklimit_setting, 2, setup.psy_tone_dBsuppress);
            this.setPeak(this.hi.block[3].tone_peaklimit_setting, 3, setup.psy_tone_dBsuppress);
        }
        this.setNoisebias(this.hi.block[i0].noise_bias_setting, 0, setup.psy_noise_dBsuppress, setup.psy_noise_bias_impulse, setup.psy_noiseguards, i0 == 0 ? this.hi.impulse_noisetune : 0.0);
        this.setNoisebias(this.hi.block[1].noise_bias_setting, 1, setup.psy_noise_dBsuppress, setup.psy_noise_bias_padding, setup.psy_noiseguards, 0.0);
        if (!singleblock) {
            this.setNoisebias(this.hi.block[2].noise_bias_setting, 2, setup.psy_noise_dBsuppress, setup.psy_noise_bias_trans, setup.psy_noiseguards, 0.0);
            this.setNoisebias(this.hi.block[3].noise_bias_setting, 3, setup.psy_noise_dBsuppress, setup.psy_noise_bias_long, setup.psy_noiseguards, 0.0);
        }
        this.setAth(0);
        this.setAth(1);
        if (!singleblock) {
            this.setAth(2);
            this.setAth(3);
        }
        this.setMapRes(this.hi.base_setting, setup.maps);
        this.vi.bitrate_nominal = this.hi.bitrate_av > 0 ? this.hi.bitrate_av : (int)this.setApproxBitrate();
        this.vi.bitrate_lower = this.hi.bitrate_min;
        this.vi.bitrate_upper = this.hi.bitrate_max;
        this.vi.bitrate_window = this.hi.bitrate_av != 0 ? (int)((double)this.hi.bitrate_reservoir / (double)this.hi.bitrate_av) : 0;
        if (this.hi.managed != 0) {
            this.ci.biManInfo.avg_rate = this.hi.bitrate_av;
            this.ci.biManInfo.min_rate = this.hi.bitrate_min;
            this.ci.biManInfo.max_rate = this.hi.bitrate_max;
            this.ci.biManInfo.reservoir_bits = this.hi.bitrate_reservoir;
            this.ci.biManInfo.reservoir_bias = this.hi.bitrate_reservoir_bias;
            this.ci.biManInfo.slew_damp = this.hi.bitrate_av_damp;
        }
        return 0;
    }

    private int setupSettingo(int channels, int rate) {
        int ret = 0;
        VeSetupDataTemplate setup = (VeSetupDataTemplate)this.hi.setup;
        ret = this.setTopLevel(channels, rate);
        if (ret == 1) {
            return ret;
        }
        int is = (int)this.hi.base_setting;
        double ds = this.hi.base_setting - (double)is;
        this.hi.short_setting = this.hi.base_setting;
        this.hi.long_setting = this.hi.base_setting;
        this.hi.managed = 0;
        this.hi.impulse_block_p = 1;
        this.hi.noise_normalize_p = 1;
        this.hi.stereo_point_setting = this.hi.base_setting;
        this.hi.lowpass_kHz = setup.psy_lowpass[is] * (1.0 - ds) + setup.psy_lowpass[is + 1] * ds;
        this.hi.ath_floating_dB = (double)setup.psy_ath_float[is] * (1.0 - ds) + (double)setup.psy_ath_float[is + 1] * ds;
        this.hi.ath_absolute_dB = (double)setup.psy_ath_abs[is] * (1.0 - ds) + (double)setup.psy_ath_abs[is + 1] * ds;
        this.hi.amplitude_track_dBpersec = -6.0;
        this.hi.trigger_setting = this.hi.base_setting;
        int i = 0;
        while (i < 4) {
            this.hi.block[i].tone_mask_setting = this.hi.base_setting;
            this.hi.block[i].tone_peaklimit_setting = this.hi.base_setting;
            this.hi.block[i].noise_bias_setting = this.hi.base_setting;
            this.hi.block[i].noise_compand_setting = this.hi.base_setting;
            ++i;
        }
        return ret;
    }

    private int setVBR(int channels, int rate, float quality) {
        if ((double)(quality = (float)((double)quality + 1.0E-7)) >= 1.0) {
            quality = 0.9999f;
        }
        this.getSetupTemplate(channels, rate, quality, 0);
        if (this.hi.setup == null) {
            return -130;
        }
        return this.setupSettingo(channels, rate);
    }

    public int initVBR(Info vi, int channels, int rate, float base_quality) {
        this.vi = vi;
        this.ci = vi.getCodecSetup();
        this.hi = this.ci.hiEncSet;
        int ret = 0;
        ret = this.setVBR(channels, rate, base_quality);
        if (ret != 0) {
            vi.clear();
            return ret;
        }
        ret = this.setSetupInit();
        if (ret != 0) {
            vi.clear();
        }
        return ret;
    }

    private int setManaged(int channels, int rate, int max_bitrate, int nominal_bitrate, int min_bitrate) {
        double tnominal = nominal_bitrate;
        int ret = 0;
        if ((double)nominal_bitrate <= 0.0) {
            if ((double)max_bitrate > 0.0) {
                nominal_bitrate = (double)min_bitrate > 0.0 ? (int)((double)(max_bitrate + min_bitrate) * 0.5) : (int)((double)max_bitrate * 0.875);
            } else if ((double)min_bitrate > 0.0) {
                nominal_bitrate = min_bitrate;
            } else {
                return -131;
            }
        }
        this.getSetupTemplate(channels, rate, nominal_bitrate, 1);
        if (this.hi.setup != null) {
            return -130;
        }
        ret = this.setupSettingo(channels, rate);
        if (ret == 0) {
            this.vi.clear();
            return ret;
        }
        this.hi.managed = 1;
        this.hi.bitrate_min = min_bitrate;
        this.hi.bitrate_max = max_bitrate;
        this.hi.bitrate_av = (int)tnominal;
        this.hi.bitrate_av_damp = 1.5;
        this.hi.bitrate_reservoir = nominal_bitrate * 2;
        this.hi.bitrate_reservoir_bias = 0.1;
        return ret;
    }

    public int init(Info vi, int channels, int rate, int max_bitrate, int nominal_bitrate, int min_bitrate) {
        this.vi = vi;
        this.ci = vi.getCodecSetup();
        this.hi = this.ci.hiEncSet;
        int ret = this.setManaged(channels, rate, max_bitrate, nominal_bitrate, min_bitrate);
        if (ret == 0) {
            vi.clear();
            return ret;
        }
        ret = this.setSetupInit();
        if (ret == 0) {
            vi.clear();
        }
        return ret;
    }

    private int setCtl(int number, Object arg) {
        if (this.vi != null) {
            int setp = number & 0xF;
            if ((setp & this.hi.set_in_stone) == 0) {
                return -131;
            }
            switch (number) {
                case 16: {
                    OvectlRatemanageArg ai = (OvectlRatemanageArg)arg;
                    ai.management_active = this.hi.managed;
                    ai.bitrate_hard_window = ai.bitrate_av_window = (double)(this.hi.bitrate_reservoir / this.vi.rate);
                    ai.bitrate_av_window_center = 1.0;
                    ai.bitrate_hard_min = this.hi.bitrate_min;
                    ai.bitrate_hard_max = this.hi.bitrate_max;
                    ai.bitrate_av_lo = this.hi.bitrate_av;
                    ai.bitrate_av_hi = this.hi.bitrate_av;
                    return 0;
                }
                case 17: {
                    OvectlRatemanageArg ai = (OvectlRatemanageArg)arg;
                    if (ai == null) {
                        this.hi.managed = 0;
                    } else {
                        this.hi.managed = ai.management_active;
                        this.setCtl(18, arg);
                        this.setCtl(19, arg);
                    }
                    return 0;
                }
                case 18: {
                    OvectlRatemanageArg ai = (OvectlRatemanageArg)arg;
                    this.hi.bitrate_av = ai == null ? 0 : (int)((double)(ai.bitrate_av_lo + ai.bitrate_av_hi) * 0.5);
                    return 0;
                }
                case 19: {
                    OvectlRatemanageArg ai = (OvectlRatemanageArg)arg;
                    if (ai == null) {
                        this.hi.bitrate_min = 0;
                        this.hi.bitrate_max = 0;
                    } else {
                        this.hi.bitrate_min = ai.bitrate_hard_min;
                        this.hi.bitrate_max = ai.bitrate_hard_max;
                        this.hi.bitrate_reservoir = (int)(ai.bitrate_hard_window * (double)(this.hi.bitrate_max + this.hi.bitrate_min) * 0.5);
                    }
                    if ((double)this.hi.bitrate_reservoir < 128.0) {
                        this.hi.bitrate_reservoir = 128;
                    }
                    return 0;
                }
                case 20: {
                    OvectlRatemanageArg2 ai = (OvectlRatemanageArg2)arg;
                    if (ai == null) {
                        return -131;
                    }
                    ai.management_active = this.hi.managed;
                    ai.bitrate_limit_min_kbps = this.hi.bitrate_min;
                    ai.bitrate_limit_max_kbps = this.hi.bitrate_max;
                    ai.bitrate_average_kbps = this.hi.bitrate_av;
                    ai.bitrate_average_damping = this.hi.bitrate_av_damp;
                    ai.bitrate_limit_reservoir_bits = this.hi.bitrate_reservoir;
                    ai.bitrate_limit_reservoir_bias = this.hi.bitrate_reservoir_bias;
                    return 0;
                }
                case 21: {
                    OvectlRatemanageArg2 ai = (OvectlRatemanageArg2)arg;
                    if (ai == null) {
                        this.hi.managed = 0;
                    } else {
                        if (ai.bitrate_limit_min_kbps > 0 && ai.bitrate_average_kbps > 0 && ai.bitrate_limit_min_kbps > ai.bitrate_average_kbps) {
                            return -131;
                        }
                        if (ai.bitrate_limit_max_kbps > 0 && ai.bitrate_average_kbps > 0 && ai.bitrate_limit_max_kbps < ai.bitrate_average_kbps) {
                            return -131;
                        }
                        if (ai.bitrate_limit_min_kbps > 0 && ai.bitrate_limit_max_kbps > 0 && ai.bitrate_limit_min_kbps > ai.bitrate_limit_max_kbps) {
                            return -131;
                        }
                        if (ai.bitrate_average_damping <= 0.0) {
                            return -131;
                        }
                        if (ai.bitrate_limit_reservoir_bits < 0) {
                            return -131;
                        }
                        if (ai.bitrate_limit_reservoir_bias < 0.0) {
                            return -131;
                        }
                        if (ai.bitrate_limit_reservoir_bias > 1.0) {
                            return -131;
                        }
                        this.hi.managed = ai.management_active;
                        this.hi.bitrate_min = ai.bitrate_limit_min_kbps;
                        this.hi.bitrate_max = ai.bitrate_limit_max_kbps;
                        this.hi.bitrate_av = ai.bitrate_average_kbps;
                        this.hi.bitrate_av_damp = ai.bitrate_average_damping;
                        this.hi.bitrate_reservoir = ai.bitrate_limit_reservoir_bits;
                        this.hi.bitrate_reservoir_bias = ai.bitrate_limit_reservoir_bias;
                    }
                    return 0;
                }
                case 32: {
                    Double farg = (Double)arg;
                    farg = new Double(this.hi.lowpass_kHz);
                    return 0;
                }
                case 33: {
                    Double farg = (Double)arg;
                    this.hi.lowpass_kHz = farg;
                    if (this.hi.lowpass_kHz < 2.0) {
                        this.hi.lowpass_kHz = 2.0;
                    }
                    if (this.hi.lowpass_kHz > 99.0) {
                        this.hi.lowpass_kHz = 99.0;
                    }
                    return 0;
                }
                case 48: {
                    Double farg = (Double)arg;
                    farg = new Double(this.hi.impulse_noisetune);
                    return 0;
                }
                case 49: {
                    Double farg = (Double)arg;
                    this.hi.impulse_noisetune = farg;
                    if (this.hi.impulse_noisetune > 0.0) {
                        this.hi.impulse_noisetune = 0.0;
                    }
                    if (this.hi.impulse_noisetune < -15.0) {
                        this.hi.impulse_noisetune = -15.0;
                    }
                    return 0;
                }
            }
            return -130;
        }
        return -131;
    }
}

