/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.audio.toot;

import com.frinika.audio.toot.FrinikaAudioSystem;
import com.frinika.audio.toot.LatencyTester;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LatencyTesterPanel
extends JPanel {
    private LatencyTester tester;
    private JTextField latencyLabel;
    private JLabel currentVal;
    private JFrame frame;

    public LatencyTesterPanel(JFrame frame1) {
        this.frame = frame1;
        this.tester = new LatencyTester();
        this.latencyLabel = new JTextField(10);
        this.add(this.latencyLabel);
        int lat = FrinikaAudioSystem.getTotalLatency();
        this.add(new JLabel("samples latency. (current value=" + lat + ")"));
        this.tester.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                int latency = LatencyTesterPanel.this.tester.getLatencyInSamples();
                String str = latency < 0 ? "No signal" : "" + latency;
                LatencyTesterPanel.this.latencyLabel.setText(str);
            }
        });
        JButton set = new JButton("Apply");
        this.add(set);
        set.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int lat = Integer.parseInt(LatencyTesterPanel.this.latencyLabel.getText());
                FrinikaAudioSystem.setTotalLatency(lat);
            }
        });
        JButton reset = new JButton("Reset");
        this.add(reset);
        set.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LatencyTesterPanel.this.tester.reset();
            }
        });
        JButton abort = new JButton("Quit");
        this.add(abort);
        abort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LatencyTesterPanel.this.dispose();
            }
        });
        if (this.frame != null) {
            this.frame.addWindowListener(new WindowListener(){

                public void windowActivated(WindowEvent e) {
                }

                public void windowClosed(WindowEvent e) {
                }

                public void windowClosing(WindowEvent e) {
                    if (LatencyTesterPanel.this.tester != null) {
                        LatencyTesterPanel.this.tester.stop();
                    }
                    LatencyTesterPanel.this.tester = null;
                    if (LatencyTesterPanel.this.frame != null) {
                        LatencyTesterPanel.this.frame.dispose();
                    }
                    LatencyTesterPanel.this.frame = null;
                }

                public void windowDeactivated(WindowEvent e) {
                }

                public void windowDeiconified(WindowEvent e) {
                }

                public void windowIconified(WindowEvent e) {
                }

                public void windowOpened(WindowEvent e) {
                }
            });
            this.tester.start(this.frame);
        }
    }

    void dispose() {
        this.tester.stop();
        this.tester = null;
        this.frame.dispose();
        this.frame = null;
    }
}

