/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.audio.voicetemplate;

import com.frinika.audio.Voice;
import com.frinika.audio.VoiceInterrupt;
import com.frinika.audio.VoiceServer;

public abstract class SynchronizedVoice
extends Voice {
    long framePos = 0L;
    int missedFrames = 0;
    int missedFramesToleranceMillis = 50;
    protected VoiceServer voiceServer;

    public SynchronizedVoice(VoiceServer voiceServer, long initialFramePos) {
        this.voiceServer = voiceServer;
        this.framePos = initialFramePos;
    }

    public int getMissedFramesToleranceMillis() {
        return this.missedFramesToleranceMillis;
    }

    public void setMissedFramesToleranceMillis(int missedFramesToleranceMillis) {
        this.missedFramesToleranceMillis = missedFramesToleranceMillis;
    }

    public void setFramePos(final long framePos) {
        this.voiceServer.interruptTransmitter(this, new VoiceInterrupt(){

            public void doInterrupt() {
                int glitchMS = (int)(framePos - SynchronizedVoice.this.framePos) * 1000 / SynchronizedVoice.this.voiceServer.getSampleRate();
                if (Math.abs(glitchMS) > SynchronizedVoice.this.missedFramesToleranceMillis) {
                    SynchronizedVoice.this.missedFrames = (int)(framePos - SynchronizedVoice.this.framePos);
                    SynchronizedVoice.this.framePos = framePos;
                }
            }
        });
    }

    protected final long getFramePos() {
        return this.framePos;
    }

    protected final int getMissedFrames() {
        return this.missedFrames;
    }

    public final void fillBuffer(int startBufferPos, int endBufferPos, float[] buffer) {
        this.fillBufferSynchronized(startBufferPos, endBufferPos, buffer);
        this.framePos += (long)((endBufferPos - startBufferPos) / 2);
        this.missedFrames = 0;
    }

    public abstract void fillBufferSynchronized(int var1, int var2, float[] var3);
}

