/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.benchmark;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class OutputBufferTest
implements Runnable {
    Mixer.Info currentMixer;
    AudioFormat format = new AudioFormat(44100.0f, 16, 2, true, true);
    DataLine.Info infoOut = new DataLine.Info(SourceDataLine.class, this.format);
    SourceDataLine lineOut;
    boolean isRunning = false;
    boolean hasStopped = false;
    int bufferSize = 2048;
    protected boolean ultraLowLatency = false;
    protected boolean standardLatency = false;
    private boolean useEstimatedFramePos = true;

    public OutputBufferTest(int bufferSize) {
        if (System.getProperty("os.name").equals("Mac OS X")) {
            System.out.println("Detected Mac OS X. Automatically tuning audio device settings. ");
            this.useEstimatedFramePos = false;
            this.ultraLowLatency = true;
        }
        this.currentMixer = AudioSystem.getMixerInfo()[0];
        this.bufferSize = 4 * bufferSize;
        this.startAudioOutput();
    }

    public void startAudioOutput() {
        try {
            this.lineOut = (SourceDataLine)AudioSystem.getMixer(this.currentMixer).getLine(this.infoOut);
            if (this.standardLatency) {
                this.lineOut.open(this.format, this.bufferSize);
            } else {
                this.lineOut.open(this.format);
            }
            this.lineOut.start();
            System.out.println("Buffersize: " + this.bufferSize + " / " + this.lineOut.getBufferSize());
        }
        catch (Exception e) {
            this.lineOut = null;
            System.out.println("No audio output available. Use Audio Devices dialog to reconfigure.");
        }
        Thread thread = new Thread(this);
        thread.setPriority(10);
        thread.start();
    }

    public void stopAudioOutput() throws Exception {
        this.isRunning = false;
        while (!this.hasStopped) {
            Thread.yield();
        }
        this.hasStopped = false;
        if (this.lineOut != null) {
            this.lineOut.drain();
            this.lineOut.stop();
            this.lineOut.close();
        }
    }

    public void run() {
        try {
            this.isRunning = true;
            byte[] outBuffer = new byte[this.bufferSize];
            float[] floatBuffer = new float[this.bufferSize / 2];
            long totalTimeNanos = (long)((float)this.bufferSize / 4.0f / 4.41E13f);
            long expireNanos = 0L;
            long framesWritten = 0L;
            while (this.isRunning) {
                long startTimeNanos = System.nanoTime();
                for (int n = 0; n < floatBuffer.length; ++n) {
                    floatBuffer[n] = 0.0f;
                }
                long endTimeNanos = System.nanoTime();
                if (this.lineOut != null) {
                    System.out.println(this.lineOut.getBufferSize() - this.lineOut.available());
                    this.lineOut.write(outBuffer, 0, outBuffer.length);
                }
                expireNanos = expireNanos < System.nanoTime() ? System.nanoTime() + totalTimeNanos : (expireNanos += totalTimeNanos);
                long sleepNanos = expireNanos - totalTimeNanos - System.nanoTime();
                if (sleepNanos <= 0L) continue;
                Thread.sleep(sleepNanos / 1000000L, (int)(sleepNanos % 1000000L));
            }
            framesWritten += (long)(outBuffer.length / 4);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.hasStopped = true;
    }

    public void setBufferSize(int len) throws Exception {
        this.stopAudioOutput();
        this.bufferSize = len * 4;
        this.startAudioOutput();
    }
}

