/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.benchmark;

import com.frinika.audio.AudioContext;
import com.frinika.audio.JavaSoundVoiceServer;
import com.frinika.audio.Voice;
import com.frinika.audio.VoiceServer;
import com.frinika.synth.SynthRack;
import com.frinika.synth.synths.MySampler;
import java.util.Vector;
import javax.sound.midi.ShortMessage;

public class RecordInputRoundTripLatencyTest {
    public static void main(String[] args) throws Exception {
        VoiceServer voiceServer = new AudioContext().getVoiceServer();
        SynthRack synthRack = new SynthRack(voiceServer);
        MySampler sampler = new MySampler(synthRack);
        synthRack.setSynth(0, sampler);
        sampler.recordMode = 0;
        int[] latencies = new int[]{512, 1024, 2048, 4096, 8192};
        Vector<String> report = new Vector<String>();
        for (int latency : latencies) {
            if (AudioContext.getDefaultAudioContext().getVoiceServer() instanceof JavaSoundVoiceServer) {
                ((JavaSoundVoiceServer)voiceServer).setBufferSize(latency);
                System.out.println("Voiceserver latency: " + voiceServer.getTotalLatencyAsFrames() + " frames " + voiceServer.getTotalLatency() / 1000L + " ms");
            }
            for (int count = 0; count < 3; ++count) {
                if (AudioContext.getDefaultAudioContext().getVoiceServer() instanceof JavaSoundVoiceServer) {
                    boolean audioDeviceIndex = false;
                    throw new Exception("FIXME");
                }
                sampler.samplerOscillator.startMonitor(null, true);
                System.out.println("Your input is being monitored");
                Thread.sleep(2000L);
                long t1 = System.currentTimeMillis();
                ShortMessage shm = new ShortMessage();
                shm.setMessage(144, 0, 36, 100);
                synthRack.getReceiver().send(shm, -1L);
                class PulseVoice
                extends Voice {
                    boolean first = true;

                    PulseVoice() {
                    }

                    public void fillBuffer(int startBufferPos, int endBufferPos, float[] buffer) {
                        if (this.first) {
                            buffer[startBufferPos] = 0.2f;
                        }
                        this.first = false;
                    }
                }
                PulseVoice voice = new PulseVoice();
                voiceServer.addTransmitter(voice);
                System.out.println("record and pulse init time " + (System.currentTimeMillis() - t1));
                System.out.println("Recording");
                Thread.sleep(1000L);
                shm = new ShortMessage();
                shm.setMessage(144, 0, 36, 0);
                synthRack.getReceiver().send(shm, -1L);
                System.out.println("Wait");
                Thread.sleep(2000L);
                System.out.println("Calculate results");
                short[] samples = sampler.sampledSounds[36][0].getLeftSamples();
                int delta = 0;
                delta = samples[0] - delta;
                int pos = -44100;
                for (int n = 0; n < samples.length; ++n) {
                    if ((delta = samples[n] - delta) <= 1000) continue;
                    System.out.println(n + " " + delta);
                    pos = n;
                    break;
                }
                int roundtripLatency = pos * 1000 / voiceServer.getSampleRate();
                report.add("Voiceserver latency\t" + voiceServer.getTotalLatencyAsFrames() + "\tframes\t" + voiceServer.getTotalLatency() / 1000L + "\tms\t" + "roundtrip latency\t" + roundtripLatency + "\tmsecs\trtatency/vslatency\t" + (float)(roundtripLatency * 1000) / (float)voiceServer.getTotalLatency());
            }
        }
        System.out.println("\n\n--------------------------------------------------------\n Test Results:\nNote that you must turn of latency compensation in SamplerOscillator.java to get correct roundtrip latency");
        for (String r : report) {
            System.out.println(r);
        }
        System.exit(0);
    }
}

