/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.codeexamples;

import com.frinika.audio.toot.FrinikaAudioSystem;
import com.frinika.global.FrinikaConfig;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.mixer.SynthWrapper;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.NoteEvent;
import java.io.File;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;

public class CopyOfCreateProjectExample {
    public static void main(String[] args) throws Exception {
        File soundbankfilename = new File(FrinikaConfig.SOUNDFONT_DIRECTORY, "8MBGMFX.SF2");
        FrinikaAudioSystem.getAudioServer().start();
        ProjectContainer proj = new ProjectContainer();
        MidiLane lane = proj.createMidiLane();
        MidiPart part = new MidiPart(lane);
        part.add(new NoteEvent(part, 0L, 60, 100, 0, 128L));
        part.add(new NoteEvent(part, 128L, 61, 100, 0, 128L));
        part.add(new NoteEvent(part, 256L, 62, 100, 0, 128L));
        part.add(new NoteEvent(part, 512L, 63, 100, 0, 128L));
        part.add(new NoteEvent(part, 768L, 64, 100, 0, 128L));
        part.setBoundsFromEvents();
        part = new MidiPart(lane);
        part.add(new NoteEvent(part, 1024L, 60, 100, 0, 128L));
        part.add(new NoteEvent(part, 1152L, 59, 100, 0, 128L));
        part.add(new NoteEvent(part, 1280L, 58, 100, 0, 128L));
        part.add(new NoteEvent(part, 1536L, 57, 100, 0, 128L));
        part.add(new NoteEvent(part, 1792L, 56, 100, 0, 128L));
        part.setBoundsFromEvents();
        for (MidiDevice.Info info : MidiSystem.getMidiDeviceInfo()) {
            try {
                MidiDevice dev = MidiSystem.getMidiDevice(info);
                if (dev.getMaxReceivers() == 0) continue;
                if (info.toString().equals("Gervill")) {
                    SynthWrapper midiDevice = new SynthWrapper(proj, dev);
                    try {
                        proj.addMidiOutDevice(midiDevice);
                        Synthesizer synth = (Synthesizer)dev;
                        Soundbank soundbank = MidiSystem.getSoundbank(soundbankfilename);
                    }
                    catch (MidiUnavailableException e2) {
                        e2.printStackTrace();
                    }
                    break;
                }
                System.out.println(info);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        new ProjectFrame(proj);
    }
}

