/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.codeexamples;

import com.frinika.audio.toot.gui.MidiInDeviceSelectPanel;
import com.frinika.audio.toot.gui.MidiOutDeviceSelectPanel;
import com.frinika.midi.MidiDebugDevice;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MidiMonitor {
    static MidiInDeviceSelectPanel inDeviceSelector;
    static MidiOutDeviceSelectPanel outDeviceSelector;
    static Receiver dbgIn;
    static Receiver recv;
    static Transmitter dbgOut;
    static Transmitter trans;
    static JPanel panel;

    public static void main(String[] args) {
        panel = new JPanel();
        JFrame frame = new JFrame();
        frame.setContentPane(panel);
        frame.pack();
        frame.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MidiMonitor.run();
            }
        });
    }

    static void run() {
        MidiDebugDevice d = new MidiDebugDevice();
        try {
            dbgIn = d.getReceiver();
            dbgOut = d.getTransmitter();
        }
        catch (MidiUnavailableException e1) {
            e1.printStackTrace();
        }
        inDeviceSelector = new MidiInDeviceSelectPanel();
        panel.add(inDeviceSelector);
        outDeviceSelector = new MidiOutDeviceSelectPanel();
        panel.add(outDeviceSelector);
        inDeviceSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MidiDevice dev = inDeviceSelector.getSelected();
                try {
                    dev.open();
                    dev.getTransmitter().setReceiver(dbgIn);
                }
                catch (MidiUnavailableException e) {
                    e.printStackTrace();
                }
            }
        });
        outDeviceSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MidiDevice dev = outDeviceSelector.getSelected();
                try {
                    dev.open();
                    dbgOut.setReceiver(dev.getReceiver());
                }
                catch (MidiUnavailableException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

