/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.codeexamples;

import com.frinika.sequencer.model.audio.AudioWriter;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.swing.JFrame;
import rasmus.editor.ExpressionEditor;
import rasmus.interpreter.Interpreter;
import rasmus.interpreter.Variable;
import rasmus.interpreter.parser.ScriptParserException;
import rasmus.interpreter.sampled.AudioSession;

public class rasmusPostProcessTest {
    public static void main(String[] args) {
        File inputfile = new File("/home/pjl/Sassy9.wav");
        File outputfile = new File("/home/pjl/output_wav_file.wav");
        String reverbfile = "/home/pjl/frinika/impulses/Deep Space.wav";
        assert (inputfile.exists());
        File fil = new File(reverbfile);
        assert (fil.exists());
        AudioFormat format = new AudioFormat(44100.0f, 16, 2, true, false);
        try {
            AudioWriter audioWriter = new AudioWriter(outputfile, format);
            String script = "output <- fftconvolution( File(\"" + reverbfile + "\") ) <- file(input);";
            JFrame frame = new JFrame();
            ExpressionEditor.editScript((Frame)frame, (String)script);
            System.out.println(script);
            Interpreter interpreter = new Interpreter();
            interpreter.add("input", (Object)inputfile.getPath());
            interpreter.eval(script);
            Variable output = interpreter.get("output");
            AudioSession audiosession = new AudioSession((double)format.getSampleRate(), format.getChannels());
            AudioInputStream audiostream = audiosession.asByteStream(output, format);
            long bytes_to_render = inputfile.length();
            byte[] buffer = new byte[512];
            long writeout = 0L;
            while (writeout < bytes_to_render) {
                int ret = -1;
                ret = audiostream.read(buffer);
                if (ret == -1) {
                    System.out.println(" ret == -1 ");
                    break;
                }
                System.out.println(" rendered : " + (writeout += (long)ret));
                audioWriter.write(buffer, 0, ret);
            }
            audioWriter.close();
            audiostream.close();
            audiosession.close();
            interpreter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ScriptParserException e1) {
            e1.printStackTrace();
        }
    }
}

