/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.contrib.boblang;

import com.frinika.contrib.boblang.Convert;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class BezierSetup
extends JDialog
implements ActionListener,
WindowListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    public int dgMidiInputNumber;
    public int dgSampleRate;
    public int dgPolyphony;
    public int dgBufferLength;
    ActionListener actionListener = this;
    WindowListener windowListener = this;
    ItemListener itemListener = this;
    JComboBox midiInput = new JComboBox<String>(midiInputChoices);
    static String[] midiInputChoices = new String[]{"Undefined MIDI Input"};
    JComboBox sampleRate = new JComboBox<String>(sampleRateChoices);
    static String[] sampleRateChoices = new String[]{"48000", "44100", "24000", "22050"};
    JComboBox polyphonyBox = new JComboBox<String>(polyphonyBoxChoices);
    static String[] polyphonyBoxChoices = new String[]{"2", "4", "6", "8", "12", "16", "20", "24"};
    JComboBox bufferSizeBox = new JComboBox<String>(bufferSizeBoxChoices);
    static String[] bufferSizeBoxChoices = new String[]{"1024", "2048", "4096", "6144", "8192", "10240", "16384"};
    JPanel combinedPanel = new JPanel();
    JLabel label1 = new JLabel("Midi Input", 0);
    JLabel label2 = new JLabel("Sample Rate", 0);
    JLabel label3 = new JLabel("Write Buffer Length", 0);
    JLabel label4 = new JLabel("Max Polyphony", 0);
    JPanel controlPanel = new JPanel();
    JButton accept = new JButton("Accept");
    JButton quit = new JButton("Quit");
    JLabel label5 = new JLabel("Bezier Synthesizer Setup Options", 0);

    private void getDataFromGui() {
        this.dgMidiInputNumber = this.midiInput.getSelectedIndex();
        String s = this.sampleRate.getSelectedItem().toString();
        this.dgSampleRate = Convert.stringToInt(s, 48000);
        s = this.polyphonyBox.getSelectedItem().toString();
        this.dgPolyphony = Convert.stringToInt(s, 8);
        s = this.bufferSizeBox.getSelectedItem().toString();
        this.dgBufferLength = Convert.stringToInt(s, 128);
    }

    public BezierSetup(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.bufferSizeBox.setSelectedIndex(3);
        try {
            MidiDevice.Info[] info = MidiSystem.getMidiDeviceInfo();
            String[] deviceList = new String[info.length];
            for (int i = 0; i < info.length; ++i) {
                deviceList[i] = "  " + i + ". " + info[i];
            }
            this.midiInput = new JComboBox<String>(deviceList);
        }
        catch (Exception e) {
            String m = "BezierSetup reports exception\n";
            m = m + e.toString();
            JOptionPane.showMessageDialog(null, m, null, 0);
            System.out.println("BezierSetup reports exception");
            System.out.println("Problem accessing midi input devices");
            System.out.println(e);
            System.exit(0);
        }
        this.addWindowListener(this.windowListener);
        this.midiInput.addItemListener(this.itemListener);
        this.sampleRate.addItemListener(this.itemListener);
        this.polyphonyBox.addItemListener(this.itemListener);
        this.bufferSizeBox.addItemListener(this.itemListener);
        GridBagLayout combinedPanelGridBag = new GridBagLayout();
        GridBagConstraints combinedPanelConstr = new GridBagConstraints();
        this.combinedPanel.setLayout(combinedPanelGridBag);
        combinedPanelConstr.anchor = 10;
        combinedPanelConstr.weightx = 1.0;
        combinedPanelConstr.weighty = 1.0;
        combinedPanelConstr.fill = 1;
        combinedPanelConstr.gridx = 0;
        combinedPanelConstr.gridy = 0;
        combinedPanelConstr.gridwidth = 1;
        combinedPanelConstr.gridheight = 1;
        combinedPanelGridBag.setConstraints(this.label1, combinedPanelConstr);
        this.combinedPanel.add(this.label1);
        combinedPanelConstr.gridx = 1;
        combinedPanelConstr.gridy = 0;
        combinedPanelConstr.gridwidth = 2;
        combinedPanelConstr.gridheight = 1;
        combinedPanelGridBag.setConstraints(this.midiInput, combinedPanelConstr);
        this.combinedPanel.add(this.midiInput);
        combinedPanelConstr.gridx = 0;
        combinedPanelConstr.gridy = 1;
        combinedPanelConstr.gridwidth = 1;
        combinedPanelConstr.gridheight = 1;
        combinedPanelGridBag.setConstraints(this.label2, combinedPanelConstr);
        this.combinedPanel.add(this.label2);
        combinedPanelConstr.gridx = 1;
        combinedPanelConstr.gridy = 1;
        combinedPanelConstr.gridwidth = 1;
        combinedPanelConstr.gridheight = 1;
        combinedPanelGridBag.setConstraints(this.sampleRate, combinedPanelConstr);
        this.combinedPanel.add(this.sampleRate);
        combinedPanelConstr.gridx = 0;
        combinedPanelConstr.gridy = 2;
        combinedPanelConstr.gridwidth = 1;
        combinedPanelConstr.gridheight = 1;
        combinedPanelGridBag.setConstraints(this.label3, combinedPanelConstr);
        this.combinedPanel.add(this.label3);
        combinedPanelConstr.gridx = 1;
        combinedPanelConstr.gridy = 2;
        combinedPanelConstr.gridwidth = 1;
        combinedPanelConstr.gridheight = 1;
        combinedPanelGridBag.setConstraints(this.bufferSizeBox, combinedPanelConstr);
        this.combinedPanel.add(this.bufferSizeBox);
        combinedPanelConstr.gridx = 0;
        combinedPanelConstr.gridy = 3;
        combinedPanelConstr.gridwidth = 1;
        combinedPanelConstr.gridheight = 1;
        combinedPanelGridBag.setConstraints(this.label4, combinedPanelConstr);
        this.combinedPanel.add(this.label4);
        combinedPanelConstr.gridx = 1;
        combinedPanelConstr.gridy = 3;
        combinedPanelConstr.gridwidth = 1;
        combinedPanelConstr.gridheight = 1;
        combinedPanelGridBag.setConstraints(this.polyphonyBox, combinedPanelConstr);
        this.combinedPanel.add(this.polyphonyBox);
        this.controlPanel.setLayout(new FlowLayout(1));
        this.controlPanel.add(this.accept);
        this.accept.addActionListener(this.actionListener);
        this.controlPanel.add(this.quit);
        this.quit.addActionListener(this.actionListener);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("North", this.label5);
        this.getContentPane().add("Center", this.combinedPanel);
        this.getContentPane().add("South", this.controlPanel);
        this.setSize(500, 250);
        this.setVisible(true);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void actionPerformed(ActionEvent event) {
        Object target = event.getSource();
        if (target == this.accept) {
            this.getDataFromGui();
            this.setVisible(false);
        } else if (target == this.quit) {
            System.exit(0);
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object target = event.getSource();
        if (target == this.midiInput ? event.getStateChange() == 1 : (target == this.sampleRate ? event.getStateChange() == 1 : (target == this.polyphonyBox ? event.getStateChange() == 1 : target != this.bufferSizeBox || event.getStateChange() == 1))) {
            // empty if block
        }
    }

    public static void main(String[] args) {
        Frame f = new Frame("DummyParent");
        f.setSize(200, 100);
        f.setVisible(true);
        BezierSetup d = new BezierSetup(f, "BezierSetup", true);
        d.setVisible(true);
        System.exit(0);
    }
}

