/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.contrib.boblang;

import com.frinika.contrib.boblang.BezierParams;
import com.frinika.contrib.boblang.WaveSupport;
import com.frinika.synth.Oscillator;

public class BezierSynth {
    public static final int MAX_AMPLITUDE = 8000;
    public static final int MAX_PITCH = 128;
    public static final int HIGH_PITCH = 96;
    public static final int LOW_PITCH = 33;
    public static final int AMP_STEADY = 0;
    public static final int AMP_RISE_FALL = 1;
    public static final int AMP_RISING = 2;
    public static final int AMP_FALLING = 3;
    private int x2centre;
    private int y2centre;
    private int x3centre;
    private int y3centre;
    private int x2amplitude;
    private int y2amplitude;
    private int x3amplitude;
    private int y3amplitude;
    private int x2envType;
    private int y2envType;
    private int x3envType;
    private int y3envType;
    private int x2envTime;
    private int y2envTime;
    private int x3envTime;
    private int y3envTime;
    private double x2AngVel;
    private double y2AngVel;
    private double x3AngVel;
    private double y3AngVel;
    private double x2Phase;
    private double y2Phase;
    private double x3Phase;
    private double y3Phase;
    private double frequency;
    private int sampleRate;
    private int wavelength;

    public BezierSynth(int inMidiPitch, BezierParams inParams) {
        this.sampleRate = inParams.getSampleRate();
        this.frequency = Oscillator.getFrequency(inMidiPitch);
        this.wavelength = inParams.wavelengthFromFrequency(this.frequency);
        this.frequency = inParams.frequencyFromWavelength(this.wavelength);
        this.x2centre = inParams.getUpperCentreX() * this.wavelength / 100;
        this.y2centre = inParams.getUpperCentreY() * 8000 / 100;
        this.x3centre = inParams.getLowerCentreX() * this.wavelength / 100;
        this.y3centre = inParams.getLowerCentreY() * 8000 / 100;
        this.x2amplitude = inParams.getUpperAmplX() * this.wavelength / 100;
        this.y2amplitude = inParams.getUpperAmplY() * 8000 / 100;
        this.x3amplitude = inParams.getLowerAmplX() * this.wavelength / 100;
        this.y3amplitude = inParams.getLowerAmplY() * 8000 / 100;
        this.x2envType = inParams.getUpperEnvX();
        this.y2envType = inParams.getUpperEnvY();
        this.x3envType = inParams.getLowerEnvX();
        this.y3envType = inParams.getLowerEnvY();
        this.x2envTime = inParams.getUpperXEnvTime();
        this.y2envTime = inParams.getUpperYEnvTime();
        this.x3envTime = inParams.getLowerXEnvTime();
        this.y3envTime = inParams.getLowerYEnvTime();
        double f = this.frequency * inParams.getUpperRelFreqX() + inParams.getUpperAbsFreqX();
        this.x2AngVel = 360.0 * f;
        f = this.frequency * inParams.getUpperRelFreqY() + inParams.getUpperAbsFreqY();
        this.y2AngVel = 360.0 * f;
        f = this.frequency * inParams.getLowerRelFreqX() + inParams.getLowerAbsFreqX();
        this.x3AngVel = 360.0 * f;
        f = this.frequency * inParams.getLowerRelFreqY() + inParams.getLowerAbsFreqY();
        this.y3AngVel = 360.0 * f;
        this.x2Phase = inParams.getUpperPhaseX();
        this.y2Phase = inParams.getUpperPhaseY();
        this.x3Phase = inParams.getLowerPhaseX();
        this.y3Phase = inParams.getLowerPhaseY();
    }

    public void printParams() {
        System.out.println("Freq= " + this.frequency + " wavelength=" + this.wavelength);
        System.out.println("upper centre = " + this.x2centre + "," + this.y2centre);
        System.out.println("lower centre = " + this.x3centre + "," + this.y3centre);
        System.out.println("upper ampl: x= " + this.x2amplitude + " y= " + this.y2amplitude);
        System.out.println("lower ampl: x= " + this.x3amplitude + " y= " + this.y3amplitude);
        System.out.println("upper avel: x= " + this.x2AngVel + " y=" + this.y2AngVel);
        System.out.println("lower avel: x= " + this.x3AngVel + " y=" + this.y3AngVel);
    }

    public final int getSample(int sampleNumber) {
        double time = (double)sampleNumber / (double)this.sampleRate;
        double x2amp = this.getAmplitude(this.x2amplitude, this.x2envType, this.x2envTime, time);
        double y2amp = this.getAmplitude(this.y2amplitude, this.y2envType, this.y2envTime, time);
        double x3amp = this.getAmplitude(this.x3amplitude, this.x3envType, this.x3envTime, time);
        double y3amp = this.getAmplitude(this.y3amplitude, this.y3envType, this.y3envTime, time);
        double x1 = 0.0;
        double y1 = 0.0;
        double x4 = this.wavelength;
        double y4 = 0.0;
        double x2 = (double)this.x2centre + x2amp * WaveSupport.localCosine(this.x2AngVel * time + this.x2Phase);
        double y2 = (double)this.y2centre + y2amp * WaveSupport.localSine(this.y2AngVel * time + this.y2Phase);
        double x3 = (double)this.x3centre + x3amp * WaveSupport.localCosine(this.x3AngVel * time + this.x3Phase);
        double y3 = (double)this.y3centre + y3amp * WaveSupport.localSine(this.y3AngVel * time + this.y3Phase);
        double cx = 3.0 * (x2 - x1);
        double cy = 3.0 * (y2 - y1);
        double bx = 3.0 * (x3 - x2 - x2 + x1);
        double by = 3.0 * (y3 - y2 - y2 + y1);
        double ax = x4 - 3.0 * (x3 - x2) - x1;
        double ay = y4 - 3.0 * (y3 - y2) - y1;
        double t = this.findT(ax, bx, cx, x1, sampleNumber);
        double sample = ay * t * t * t + by * t * t + cy * t + y1;
        return (int)sample;
    }

    private double findT(double a, double b, double c, double x1, int sampleNumber) {
        double x;
        int maxLoops = 10;
        int loopCount = 0;
        int index = sampleNumber % this.wavelength;
        double t = (double)index / (double)this.wavelength;
        do {
            x = a * t * t * t + b * t * t + c * t + x1 - (double)index;
            double d = 3.0 * a * t * t + 2.0 * b * t + c;
            t -= x / d;
        } while (Math.abs(x) > 1.0E-4 && ++loopCount < maxLoops);
        if (loopCount >= maxLoops || t < 0.0 || t > 1.0) {
            t = 0.0;
        }
        return t;
    }

    private double getAmplitude(double inAmplitude, int inEnvType, int inEnvTimeMillis, double time) {
        double factor = 1.0;
        double timeValue = (double)inEnvTimeMillis / 1000.0;
        switch (inEnvType) {
            case 0: {
                factor = 1.0;
                break;
            }
            case 1: {
                if (time < timeValue) {
                    factor = time / timeValue;
                    break;
                }
                if (time < 2.0 * timeValue) {
                    factor = 1.0 - (time - timeValue) / timeValue;
                    break;
                }
                factor = 0.0;
                break;
            }
            case 2: {
                if (time < timeValue) {
                    factor = time / timeValue;
                    break;
                }
                factor = 1.0;
                break;
            }
            case 3: {
                factor = time < timeValue ? 1.0 - time / timeValue : 0.0;
            }
        }
        return inAmplitude * factor;
    }
}

