/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.contrib.boblang;

public class Convert {
    private static final String VERSION_STRING = "uwejava.Convert version dated Thu Nov 15 2001";
    private static final char[] DIGIT_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ' ', '-'};
    private static final int MARK_LEAD_SPACE = 10;
    private static final int MARK_MINUS = 11;
    private static final int MAX_WIDTH = 24;
    private static final int MIN_EXP_WIDTH = 10;
    private static final int MIN_DECIMAL_WIDTH = 4;
    private static final int DOUBLE_EXP_WIDTH = 3;
    private static final int FLOAT_EXP_WIDTH = 2;
    private static final double MAX_DECIMAL_VALUE = 9.0E18;
    private static final int MAX_DECIMAL_DIGITS = 18;
    private static double[] powerTable = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22, 1.0E23, 1.0E24, 1.0E25, 1.0E26, 1.0E27, 1.0E28, 1.0E29};

    private static String convDoubleExp(double d, int width, int decimal, int exp) {
        int pre;
        int extraChars = 4;
        int powerOfTen = 0;
        boolean negative = d < 0.0;
        d = Math.abs(d);
        if (exp < 2) {
            exp = 2;
        }
        if (exp > 3) {
            exp = 3;
        }
        if (width < 10) {
            decimal = decimal + 10 - width;
            width = 10;
        }
        if (width > 24) {
            decimal = decimal - 24 + width;
            width = 24;
        }
        if (decimal > width - exp - extraChars - 1) {
            decimal = width - exp - extraChars - 1;
        }
        if (decimal <= 0) {
            decimal = 0;
            extraChars = 3;
        }
        if ((double)(pre = width - decimal - exp - extraChars) >= 9.0E18) {
            pre = 18;
        }
        double maxNorm = powerTable[pre];
        double minNorm = maxNorm / 10.0;
        while (d > maxNorm) {
            d /= 10.0;
            ++powerOfTen;
        }
        while (d < minNorm) {
            d *= 10.0;
            --powerOfTen;
        }
        double round = 0.5 / powerTable[decimal];
        d += round;
        while (d > maxNorm) {
            d /= 10.0;
            ++powerOfTen;
        }
        long preDigits = (long)d;
        long postDigits = (long)((d - (double)preDigits) * powerTable[decimal]);
        String buffer = negative ? "-" : " ";
        buffer = buffer + Convert.convLongLS(preDigits, pre);
        if (decimal != 0) {
            buffer = buffer + '.';
            buffer = buffer + Convert.convLongLZ(postDigits, decimal);
        }
        if (powerOfTen < 0) {
            buffer = buffer + "e-";
            powerOfTen = -powerOfTen;
        } else {
            buffer = buffer + "e+";
        }
        buffer = buffer + Convert.convLongLZ(powerOfTen, exp);
        return buffer;
    }

    private static String convDouble(double d, int width, int decimal) {
        boolean negative = d < 0.0;
        d = Math.abs(d);
        if (decimal > width - 1) {
            decimal = width - 1;
        }
        if (decimal <= 0) {
            decimal = 0;
        }
        if (width < 4) {
            width = 4;
        }
        if (width > 24) {
            decimal = decimal - 24 + width;
            width = 24;
        }
        int pre = width - decimal - 1;
        if (decimal == 0) {
            ++pre;
        }
        double round = 0.5 / powerTable[decimal];
        long preDigits = (long)(d += round);
        long postDigits = (long)((d - (double)preDigits) * powerTable[decimal]);
        if (negative) {
            preDigits = -preDigits;
        }
        String buffer = Convert.convLongLS(preDigits, pre);
        if (decimal != 0) {
            buffer = buffer + '.';
            buffer = buffer + Convert.convLongLZ(postDigits, decimal);
        }
        return buffer;
    }

    private static String convLongLS(long l, int width) {
        int i;
        boolean negative;
        long[] digits = new long[24];
        boolean bl = negative = l < 0L;
        if (negative) {
            l = -l;
        }
        if (width > 24) {
            width = 24;
        }
        for (i = 0; i < 24; ++i) {
            digits[i] = 10L;
        }
        i = 0;
        digits[i] = l % 10L;
        while (l > 0L) {
            digits[i] = l % 10L;
            l /= 10L;
            ++i;
        }
        if (negative) {
            digits[i] = 11L;
            ++i;
        }
        if (width > i) {
            i = width;
        }
        String buffer = "";
        --i;
        while (i >= 0) {
            int digitValue = (int)digits[i];
            buffer = buffer + DIGIT_CHAR[digitValue];
            --i;
        }
        return buffer;
    }

    private static String convLongLZ(long l, int width) {
        int i;
        boolean negative;
        long[] digits = new long[24];
        String buffer = "";
        boolean bl = negative = l < 0L;
        if (negative) {
            l = Math.abs(l);
            buffer = "-";
            --width;
        }
        if (width > 24) {
            width = 24;
        }
        for (i = 0; i < 24; ++i) {
            digits[i] = 0L;
        }
        i = 0;
        digits[i] = l % 10L;
        while (l > 0L) {
            digits[i] = l % 10L;
            l /= 10L;
            ++i;
        }
        if (width > i) {
            i = width;
        }
        --i;
        while (i >= 0) {
            int digitValue = (int)digits[i];
            buffer = buffer + DIGIT_CHAR[digitValue];
            --i;
        }
        return buffer;
    }

    public static String version() {
        return VERSION_STRING;
    }

    public static String doubleToString(double d, int width, int decimal) {
        if (decimal < 0 || Math.abs(d) > 9.0E18) {
            return Convert.convDoubleExp(d, width, Math.abs(decimal), 3);
        }
        return Convert.convDouble(d, width, decimal);
    }

    public static String floatToString(float f, int width, int decimal) {
        if (decimal < 0 || (double)Math.abs(f) > 9.0E18) {
            return Convert.convDoubleExp(f, width, Math.abs(decimal), 2);
        }
        return Convert.convDouble(f, width, decimal);
    }

    public static String longToString(long l, int width) {
        if (width < 0) {
            return Convert.convLongLZ(l, Math.abs(width));
        }
        return Convert.convLongLS(l, width);
    }

    public static String intToString(int i, int width) {
        if (width < 0) {
            return Convert.convLongLZ(i, Math.abs(width));
        }
        return Convert.convLongLS(i, width);
    }

    public static String shortToString(short s, int width) {
        if (width < 0) {
            return Convert.convLongLZ(s, Math.abs(width));
        }
        return Convert.convLongLS(s, width);
    }

    public static boolean isValidDouble(String s) {
        boolean valid = false;
        try {
            s = s.trim();
            Double d = new Double(s);
            valid = true;
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        return valid;
    }

    public static double stringToDouble(String s, double defaultValue) {
        double result = defaultValue;
        try {
            s = s.trim();
            Double d = new Double(s);
            result = d;
        }
        catch (NumberFormatException e) {
            result = defaultValue;
        }
        return result;
    }

    public static boolean isValidFloat(String s) {
        boolean valid = false;
        try {
            s = s.trim();
            Float d = new Float(s);
            valid = true;
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        return valid;
    }

    public static float stringToFloat(String s, float defaultValue) {
        float result = defaultValue;
        try {
            s = s.trim();
            Float d = new Float(s);
            result = d.floatValue();
        }
        catch (NumberFormatException e) {
            result = defaultValue;
        }
        return result;
    }

    public static boolean isValidLong(String s) {
        boolean valid = false;
        try {
            s = s.trim();
            Long d = new Long(s);
            valid = true;
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        return valid;
    }

    public static long stringToLong(String s, long defaultValue) {
        long result = defaultValue;
        try {
            s = s.trim();
            Long d = new Long(s);
            result = d;
        }
        catch (NumberFormatException e) {
            result = defaultValue;
        }
        return result;
    }

    public static boolean isValidInt(String s) {
        boolean valid = false;
        try {
            s = s.trim();
            Integer d = new Integer(s);
            valid = true;
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        return valid;
    }

    public static int stringToInt(String s, int defaultValue) {
        int result = defaultValue;
        try {
            s = s.trim();
            Integer d = new Integer(s);
            result = d;
        }
        catch (NumberFormatException e) {
            result = defaultValue;
        }
        return result;
    }

    public static boolean isValidShort(String s) {
        boolean valid = false;
        try {
            s = s.trim();
            Short d = new Short(s);
            valid = true;
        }
        catch (NumberFormatException e) {
            valid = false;
        }
        return valid;
    }

    public static short stringToShort(String s, short defaultValue) {
        short result = defaultValue;
        try {
            s = s.trim();
            Short d = new Short(s);
            result = d;
        }
        catch (NumberFormatException e) {
            result = defaultValue;
        }
        return result;
    }
}

