/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.contrib.boblang;

import com.frinika.contrib.boblang.Convert;
import com.frinika.contrib.boblang.GraphPoint;
import com.frinika.contrib.boblang.GraphPointVector;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;

public class Graph
extends Frame {
    private static final long serialVersionUID = 1L;
    public static final Color WHITE = Color.white;
    public static final Color LIGHT_GRAY = Color.lightGray;
    public static final Color GRAY = Color.gray;
    public static final Color DARK_GRAY = Color.darkGray;
    public static final Color BLACK = Color.black;
    public static final Color RED = Color.red;
    public static final Color PINK = Color.pink;
    public static final Color ORANGE = Color.orange;
    public static final Color YELLOW = Color.yellow;
    public static final Color GREEN = Color.green;
    public static final Color MAGENTA = Color.magenta;
    public static final Color CYAN = Color.cyan;
    public static final Color BLUE = Color.blue;
    private static final boolean VISIBLE = true;
    private static final boolean INVISIBLE = false;
    public static final int MAX_TRACE_TITLE = 4;
    private String xAxisTitle;
    private String yAxisTitle;
    private String graphTitle;
    private String subTitle;
    private String[] traceTitles = new String[4];
    private Color[] traceTitleColours = new Color[4];
    private Color colour;
    private boolean newGraph;
    private boolean exitWhenClosed;
    private GraphPointVector points;
    private double xMax;
    private double yMax;
    private double xMin;
    private double yMin;
    private int xOffset;
    private int yOffset;
    private double xSpread;
    private double ySpread;
    private int xAxisLength;
    private int yAxisLength;
    private int xOrigin;
    private int yOrigin;
    private int xBorder;
    private int yBorder;
    private int frameWidth;
    private int frameHeight;
    private boolean printGraph;

    public Graph(String inGraphTitle, String inXTitle, String inYTitle) {
        this.clearGraph(inGraphTitle, inXTitle, inYTitle);
        this.setupWindowListener();
        this.setSize(640, 480);
    }

    public Graph() {
        this("", "", "");
    }

    public void clearGraph(String inGraphTitle, String inXTitle, String inYTitle) {
        this.setGraphTitle(inGraphTitle);
        this.graphTitle = inGraphTitle;
        this.xAxisTitle = inXTitle;
        this.yAxisTitle = inYTitle;
        this.subTitle = "";
        for (int i = 0; i < 4; ++i) {
            this.traceTitles[i] = "";
        }
        this.points = new GraphPointVector();
        this.colour = BLACK;
        this.newGraph = true;
        this.xMax = 0.0;
        this.yMax = 0.0;
        this.xMin = 0.0;
        this.yMin = 0.0;
    }

    public void nextGraph() {
        this.colour = BLACK;
        this.newGraph = true;
    }

    public void setSubTitle(String inSubTitle) {
        this.subTitle = inSubTitle;
        for (int i = 0; i < 4; ++i) {
            this.traceTitles[i] = "";
        }
    }

    public void setTraceTitle(int traceNumber, Color inColour, String inTitle) {
        this.subTitle = "";
        if (traceNumber < 4) {
            this.traceTitleColours[traceNumber] = inColour;
            this.traceTitles[traceNumber] = inTitle;
        }
    }

    public void setColor(Color c) {
        this.colour = c;
    }

    public void setColour(Color c) {
        this.setColor(c);
    }

    public void add(double x, double y) {
        boolean visible = !this.newGraph;
        this.newGraph = false;
        this.points.addPoint(new GraphPoint(this.colour, visible, x, y));
        if (x > this.xMax) {
            this.xMax = x;
        }
        if (x < this.xMin) {
            this.xMin = x;
        }
        if (y > this.yMax) {
            this.yMax = y;
        }
        if (y < this.yMin) {
            this.yMin = y;
        }
    }

    public void add(int x, int y) {
        double dx = x;
        double dy = y;
        this.add(dx, dy);
    }

    public void skipTo(double x, double y) {
        this.points.addPoint(new GraphPoint(this.colour, false, x, y));
        this.newGraph = false;
    }

    public void skipTo(int x, int y) {
        double dx = x;
        double dy = y;
        this.skipTo(dx, dy);
    }

    public void showGraph() {
        this.exitWhenClosed = true;
        this.repaint();
        this.show();
    }

    public void showGraph(boolean inExitWhenClosed) {
        this.exitWhenClosed = inExitWhenClosed;
        this.repaint();
        this.show();
    }

    public synchronized void paint(Graphics g) {
        this.printGraph = false;
        this.xOffset = 0;
        this.yOffset = 0;
        this.xBorder = 80;
        this.yBorder = 80;
        Dimension d = this.getSize();
        this.frameWidth = d.width;
        this.frameHeight = d.height;
        this.setUpAxes();
        this.drawAxes(g);
        this.plotGraphs(g);
    }

    public synchronized void print(int inXOffset, int inYOffset, int printWidth, int printHeight, Graphics g) {
        this.printGraph = true;
        this.xOffset = inXOffset;
        this.yOffset = inYOffset;
        this.xBorder = 50;
        this.yBorder = 60;
        this.frameWidth = printWidth;
        this.frameHeight = printHeight;
        g.setColor(BLUE);
        g.drawRect(this.xOffset, this.yOffset, this.frameWidth, this.frameHeight);
        this.setUpAxes();
        this.drawAxes(g);
        this.plotGraphs(g);
    }

    private void setGraphTitle(String inGraphTitle) {
        this.graphTitle = "Graph";
        if (inGraphTitle != null && inGraphTitle.length() > 1) {
            this.graphTitle = inGraphTitle;
        }
        this.setTitle(this.graphTitle);
    }

    private void setupWindowListener() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Graph.this.dispose();
                if (Graph.this.exitWhenClosed) {
                    System.exit(0);
                }
            }
        });
    }

    private int scaleX(double x) {
        return (int)((x - this.xMin) / this.xSpread * (double)this.xAxisLength) + this.xBorder;
    }

    private int scaleY(double y) {
        return (int)((double)this.yAxisLength - (y - this.yMin) / this.ySpread * (double)this.yAxisLength) + this.yBorder;
    }

    private void setUpAxes() {
        this.xAxisLength = this.frameWidth - 2 * this.xBorder;
        this.yAxisLength = this.frameHeight - 2 * this.yBorder;
        if (this.xMin > this.xMax) {
            this.xMin = -1.0;
            this.xMax = 1.0;
        } else if (this.xMin == this.xMax) {
            this.xMin -= 1.0;
            this.xMax += 1.0;
        }
        if (this.yMin > this.yMax) {
            this.yMin = -1.0;
            this.yMax = 1.0;
        } else if (this.yMin == this.yMax) {
            this.yMin -= 1.0;
            this.yMax += 1.0;
        }
        this.xSpread = this.xMax - this.xMin;
        this.ySpread = this.yMax - this.yMin;
        this.xOrigin = this.xMin > 0.0 ? this.scaleX(this.xMin) : this.scaleX(0.0);
        this.yOrigin = this.yMin > 0.0 ? this.scaleY(this.yMin) : this.scaleY(0.0);
    }

    private void drawAxes(Graphics g) {
        g.setColor(BLACK);
        Font plain = g.getFont();
        Font small = new Font(plain.getFamily(), 0, 10);
        Font bold = new Font(plain.getFamily(), 1, 14);
        g.drawLine(this.xBorder - 5 + this.xOffset, this.yOrigin + this.yOffset, this.xAxisLength + this.xBorder + 5 + this.xOffset, this.yOrigin + this.yOffset);
        g.drawLine(this.xOrigin + this.xOffset, this.yBorder - 5 + this.yOffset, this.xOrigin + this.xOffset, this.yAxisLength + this.yBorder + 5 + this.yOffset);
        int xPos = this.frameWidth - g.getFontMetrics().stringWidth(this.xAxisTitle) - this.xBorder / 2;
        g.drawString(this.xAxisTitle, xPos + this.xOffset, this.yOrigin - 5 + this.yOffset);
        xPos = this.xOrigin - g.getFontMetrics().stringWidth(this.yAxisTitle) / 2;
        g.drawString(this.yAxisTitle, xPos + this.xOffset, this.yBorder - 8 + this.yOffset);
        g.setFont(small);
        this.drawHorizontalTicks(g);
        this.drawVerticalTicks(g);
        g.setFont(bold);
        xPos = (this.frameWidth - g.getFontMetrics().stringWidth(this.graphTitle)) / 2;
        g.drawString(this.graphTitle, xPos + this.xOffset, this.yBorder / 2 + this.yOffset);
        if (this.subTitle.length() > 0) {
            g.setFont(plain);
            xPos = (this.frameWidth - g.getFontMetrics().stringWidth(this.subTitle)) / 2;
            int yPos = this.frameHeight - this.yBorder / 2;
            g.drawString(this.subTitle, xPos + this.xOffset, yPos + this.yOffset);
        } else {
            g.setFont(small);
            for (int t = 0; t < 4; ++t) {
                if (this.traceTitles[t].length() <= 0) continue;
                xPos = t * (this.frameWidth - 2 * this.xBorder) / 4 + this.xBorder;
                int yPos = this.frameHeight - this.yBorder / 2;
                g.setColor(this.traceTitleColours[t]);
                g.drawString(this.traceTitles[t], xPos + this.xOffset, yPos + this.yOffset);
            }
        }
        g.setFont(plain);
    }

    private void drawHorizontalTicks(Graphics g) {
        boolean byTwo = false;
        int tickInterval = 1;
        int pixTick = this.scaleX(tickInterval) - this.scaleX(0.0);
        while (pixTick < 20) {
            tickInterval = byTwo ? (tickInterval *= 2) : (tickInterval *= 5);
            byTwo = !byTwo;
            pixTick = this.scaleX(tickInterval) - this.scaleX(0.0);
        }
        int firstTick = (int)this.xMin / tickInterval;
        int lastTick = (int)this.xMax / tickInterval + 1;
        for (int tick = firstTick; tick < lastTick; ++tick) {
            double tickPoint = tick * tickInterval;
            int xTick = this.scaleX(tickPoint);
            g.drawLine(xTick + this.xOffset, this.yOrigin + this.yOffset, xTick + this.xOffset, this.yOrigin + 5 + this.yOffset);
            if ((int)tickPoint % (tickInterval * 2) != 0 || tickPoint == 0.0) continue;
            g.drawString(Convert.doubleToString(tickPoint, 1, 0), xTick - 10 + this.xOffset, this.yOrigin + 15 + this.yOffset);
        }
    }

    private void drawVerticalTicks(Graphics g) {
        int tickPixels = 20;
        if (this.printGraph) {
            tickPixels = 10;
        }
        FontMetrics fm = g.getFontMetrics();
        boolean byTwo = false;
        int tickInterval = 1;
        int pixTick = this.scaleY(0.0) - this.scaleY(tickInterval);
        while (pixTick < tickPixels) {
            tickInterval = byTwo ? (tickInterval *= 2) : (tickInterval *= 5);
            byTwo = !byTwo;
            pixTick = this.scaleY(0.0) - this.scaleY(tickInterval);
        }
        int firstTick = (int)this.yMin / tickInterval;
        int lastTick = (int)this.yMax / tickInterval + 1;
        for (int tick = firstTick; tick < lastTick; ++tick) {
            String tickString;
            double tickPoint = tick * tickInterval;
            int yTick = this.scaleY(tickPoint);
            g.drawLine(this.xOrigin + this.xOffset, yTick + this.yOffset, this.xOrigin - 5 + this.xOffset, yTick + this.yOffset);
            if (tickPoint == 0.0) continue;
            if (this.ySpread >= 100000.0) {
                DecimalFormat df = new DecimalFormat("0.0E0");
                tickString = df.format(tickPoint);
            } else {
                tickString = Convert.doubleToString(tickPoint, 1, 0);
            }
            g.drawString(tickString, this.xOrigin - fm.stringWidth(tickString) - 5 + this.xOffset, yTick + 5 + this.yOffset);
        }
    }

    private void plotGraphs(Graphics g) {
        Color plotColour = null;
        int x1 = 0;
        int y1 = 0;
        GraphPoint point = this.points.getFirstPoint();
        while (point != null) {
            int x2 = this.scaleX(point.x);
            int y2 = this.scaleY(point.y);
            if (point.colour != plotColour) {
                g.setColor(point.colour);
                plotColour = point.colour;
            }
            if (point.visible) {
                g.drawLine(x1 + this.xOffset, y1 + this.yOffset, x2 + this.xOffset, y2 + this.yOffset);
            }
            x1 = x2;
            y1 = y2;
            point = this.points.getNextPoint();
        }
    }
}

