/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.gui;

import com.frinika.project.gui.ProjectFrame;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class AbstractDialog
extends JDialog {
    protected ProjectFrame frame;
    protected boolean canceled;

    public AbstractDialog() throws HeadlessException {
        this.init(null);
    }

    public AbstractDialog(ProjectFrame owner) throws HeadlessException {
        super(owner);
        this.init(owner);
    }

    public AbstractDialog(AbstractDialog owner) throws HeadlessException {
        super(owner);
        this.init(owner.getProjectFrame());
    }

    public AbstractDialog(ProjectFrame owner, boolean modal) throws HeadlessException {
        super((Frame)owner, modal);
        this.init(owner);
    }

    public AbstractDialog(ProjectFrame owner, String title) throws HeadlessException {
        super((Frame)owner, title);
        this.init(owner);
    }

    public AbstractDialog(AbstractDialog owner, boolean modal) throws HeadlessException {
        super((Dialog)owner, modal);
        this.init(owner.getProjectFrame());
    }

    public AbstractDialog(AbstractDialog owner, String title) throws HeadlessException {
        super((Dialog)owner, title);
        this.init(owner.getProjectFrame());
    }

    public AbstractDialog(ProjectFrame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.init(owner);
    }

    public AbstractDialog(AbstractDialog owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.init(owner.getProjectFrame());
    }

    public AbstractDialog(ProjectFrame owner, String title, boolean modal, GraphicsConfiguration gc) {
        super(owner, title, modal, gc);
        this.init(owner);
    }

    public AbstractDialog(AbstractDialog owner, String title, boolean modal, GraphicsConfiguration gc) throws HeadlessException {
        super(owner, title, modal, gc);
        this.init(owner.getProjectFrame());
    }

    private void init(ProjectFrame frame) {
        this.frame = frame;
        String ESC_CANCEL = "esc-cancel";
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "esc-cancel");
        this.getRootPane().getActionMap().put("esc-cancel", new AbstractAction(){

            public void actionPerformed(ActionEvent event) {
                AbstractDialog.this.cancel();
            }
        });
    }

    public MoreLessButtonListener registerMoreLessButtonPanel(JButton button, JPanel panel) {
        return new MoreLessButtonListener(button, panel);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void ok() {
        this.hide();
    }

    public void cancel() {
        this.canceled = true;
        this.hide();
    }

    public ProjectFrame getProjectFrame() {
        return this.frame;
    }

    public static void centerOnScreen(JDialog d) {
        Dimension screenSize = d.getToolkit().getScreenSize();
        Dimension size = d.getSize();
        int x = (screenSize.width - size.width) / 2;
        int y = (screenSize.height - size.height) / 2;
        d.setLocation(x, y);
    }

    public class MoreLessButtonListener
    implements ActionListener {
        protected JButton button;
        protected JComponent panel;
        protected int panelHeight;

        public MoreLessButtonListener(JButton button, JComponent panel, boolean initiallyShowMore) {
            this.button = button;
            this.panel = panel;
            this.panelHeight = panel.getPreferredSize().height + panel.getInsets().top + panel.getInsets().bottom;
            button.addActionListener(this);
            this.setOpen(initiallyShowMore);
        }

        public MoreLessButtonListener(JButton button, JComponent panel) {
            this(button, panel, false);
        }

        public void actionPerformed(ActionEvent e) {
            this.setOpen(!this.isOpen());
        }

        protected boolean isOpen() {
            return this.panel.isVisible();
        }

        protected void setOpen(boolean open) {
            int newH;
            this.panel.setVisible(open);
            Dimension size = AbstractDialog.this.getSize();
            if (open) {
                newH = size.height + this.panelHeight;
                this.button.setText("<< Less");
            } else {
                newH = size.height - this.panelHeight;
                this.button.setText("More >>");
            }
            AbstractDialog.this.setSize(size.width, newH);
        }
    }
}

