/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.gui.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PresentationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final Dimension LABEL_SIZE = new Dimension(100, 50);
    protected static final Color LABEL_COLOR_SELECTED = new Color(220, 220, 235);
    protected static final Color LABEL_BORDER_COLOR_SELECTED = Color.DARK_GRAY;
    protected ArrayList<String> titles = new ArrayList();
    protected ArrayList<Icon> icons = new ArrayList();
    protected ArrayList<Component> components = new ArrayList();
    private JPanel contentPanel;
    private JPanel fillerPanel;
    private JLabel initializingLabel;
    private JList naviList;
    private JPanel naviPanel;
    private JScrollPane naviScrollPane;
    private JSplitPane splitPane;

    public PresentationPanel() {
        this.initComponents();
        this.naviList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (index >= 0 && index < PresentationPanel.this.titles.size()) {
                    String title = PresentationPanel.this.titles.get(index);
                    Icon icon = PresentationPanel.this.icons.get(index);
                    JLabel label = new JLabel(title, icon, 0);
                    label.setMinimumSize(LABEL_SIZE);
                    label.setPreferredSize(LABEL_SIZE);
                    if (isSelected || cellHasFocus) {
                        label.setOpaque(true);
                        label.setBackground(LABEL_COLOR_SELECTED);
                        label.setBorder(new LineBorder(LABEL_BORDER_COLOR_SELECTED, 2));
                    }
                    return label;
                }
                return null;
            }
        });
        this.naviList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int index = PresentationPanel.this.naviList.getSelectedIndex();
                PresentationPanel.this.setSelected(index);
            }
        });
    }

    public PresentationPanel(JTabbedPane tabbedPane) {
        this();
        this.initFromTabbedPane(tabbedPane);
        this.setSelected(0);
    }

    public void initFromTabbedPane(JTabbedPane tabbedPane) {
        for (int index = 0; index < tabbedPane.getComponentCount(); ++index) {
            String title = tabbedPane.getTitleAt(index);
            Icon icon = tabbedPane.getIconAt(index);
            Component component = tabbedPane.getComponent(index);
            this.titles.add(title);
            this.icons.add(icon);
            this.components.add(component);
        }
        this.naviList.setListData(new Object[this.titles.size()]);
    }

    public void setSelected(int index) {
        if (this.titles.isEmpty()) {
            return;
        }
        if (index < 0 || index >= this.titles.size()) {
            return;
        }
        Component component = this.components.get(index);
        this.contentPanel.removeAll();
        String title = this.titles.get(index);
        this.contentPanel.setBorder(new TitledBorder(title));
        this.contentPanel.add(component, "Center");
        this.contentPanel.validate();
        this.contentPanel.repaint();
        this.naviList.setSelectedIndex(index);
    }

    private void initComponents() {
        this.splitPane = new JSplitPane();
        this.naviPanel = new JPanel();
        this.naviScrollPane = new JScrollPane();
        this.naviList = new JList();
        this.fillerPanel = new JPanel();
        this.contentPanel = new JPanel();
        this.initializingLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.splitPane.setDividerLocation(150);
        this.splitPane.setDividerSize(4);
        this.naviPanel.setLayout(new GridBagLayout());
        this.naviScrollPane.setViewportView(this.naviList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.naviPanel.add((Component)this.naviScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.naviPanel.add((Component)this.fillerPanel, gridBagConstraints);
        this.splitPane.setLeftComponent(this.naviPanel);
        this.contentPanel.setLayout(new BorderLayout());
        this.initializingLabel.setHorizontalAlignment(0);
        this.initializingLabel.setText("initializing...");
        this.contentPanel.add((Component)this.initializingLabel, "Center");
        this.splitPane.setRightComponent(this.contentPanel);
        this.add((Component)this.splitPane, "Center");
    }
}

