/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.midi;

import java.util.List;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Transmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiDebugDevice
implements MidiDevice {
    List<Transmitter> trans = new Vector<Transmitter>();
    List<Receiver> recvs = new Vector<Receiver>();
    static DeviceInfo info = new DeviceInfo();
    boolean isOpen;

    @Override
    public long getMicrosecondPosition() {
        return -1L;
    }

    @Override
    public List<Transmitter> getTransmitters() {
        return this.trans;
    }

    @Override
    public List<Receiver> getReceivers() {
        return this.recvs;
    }

    @Override
    public void close() {
    }

    @Override
    public Transmitter getTransmitter() {
        Trans t = new Trans();
        this.trans.add(t);
        return t;
    }

    @Override
    public Receiver getReceiver() {
        Rec r = new Rec();
        this.recvs.add(r);
        return r;
    }

    @Override
    public int getMaxTransmitters() {
        return -1;
    }

    @Override
    public int getMaxReceivers() {
        return -1;
    }

    @Override
    public MidiDevice.Info getDeviceInfo() {
        return info;
    }

    @Override
    public void open() {
        this.isOpen = true;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    class Trans
    implements Transmitter {
        Receiver recv;

        Trans() {
        }

        public void close() {
            MidiDebugDevice.this.trans.remove(this);
            if (this.recv != null) {
                this.recv.close();
            }
            this.recv = null;
        }

        public Receiver getReceiver() {
            return this.recv;
        }

        public void setReceiver(Receiver recv) {
            this.recv = recv;
        }
    }

    class Rec
    implements Receiver {
        Rec() {
        }

        public void close() {
            MidiDebugDevice.this.recvs.remove(this);
        }

        public void send(MidiMessage mess, long timeStamp) {
            byte[] msgBytes = mess.getMessage();
            if (msgBytes[0] == -1 && msgBytes[1] == 81 && msgBytes[2] == 3) {
                int mpq = (msgBytes[3] & 0xFF) << 16 | (msgBytes[4] & 0xFF) << 8 | msgBytes[5] & 0xFF;
                System.out.println("DEBUG RECVIEVED TMEPO " + 6.0E7f / (float)mpq);
            }
            if (mess instanceof ShortMessage) {
                ShortMessage shm = (ShortMessage)mess;
                switch (shm.getCommand()) {
                    case 176: {
                        System.out.println("ControlChange :" + shm.getData1() + " " + shm.getData2());
                        break;
                    }
                    case 224: {
                        short low = (byte)shm.getData1();
                        short high = (byte)shm.getData2();
                        short val = (short)(high << 7 | low);
                        System.out.println(" Pitch Change = " + high + ":" + low + "  " + val);
                        break;
                    }
                    default: {
                        int cmd = shm.getCommand();
                        if (cmd == 240) break;
                        int chn = shm.getChannel();
                        int dat1 = shm.getData1();
                        int dat2 = shm.getData2();
                        System.out.println(" cmd:" + cmd + " chn:" + chn + " data:" + dat1 + " " + dat2);
                    }
                }
                for (Transmitter t : MidiDebugDevice.this.trans) {
                    if (((Trans)t).recv == null) continue;
                    ((Trans)t).recv.send(mess, -1L);
                }
            }
        }
    }

    static class DeviceInfo
    extends MidiDevice.Info {
        DeviceInfo() {
            super("DebugDevice", "DrPJ", "debug device", "0.1a");
        }
    }
}

