/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.project.gui;

import com.frinika.About;
import com.frinika.FrinikaMain;
import com.frinika.audio.toot.FrinikaAudioSystem;
import com.frinika.audio.toot.gui.FrinikaMixerPanel;
import com.frinika.global.ConfigError;
import com.frinika.global.ConfigListener;
import com.frinika.global.FrinikaConfig;
import com.frinika.localization.CurrentLocale;
import com.frinika.midi.MidiInDeviceManager;
import com.frinika.mod.MODImporter;
import com.frinika.notation.NotationPanel;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFocusListener;
import com.frinika.project.gui.ProjectNewFileFilter;
import com.frinika.project.gui.SelectAllAction;
import com.frinika.project.mididevices.gui.MidiDevicesPanel;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.gui.GlobalToolBar;
import com.frinika.sequencer.gui.menu.CreateAudioLaneAction;
import com.frinika.sequencer.gui.menu.CreateMidiDrumLaneAction;
import com.frinika.sequencer.gui.menu.CreateMidiLaneAction;
import com.frinika.sequencer.gui.menu.CreateProjectAction;
import com.frinika.sequencer.gui.menu.CreateTextLaneAction;
import com.frinika.sequencer.gui.menu.CutPasteMenu;
import com.frinika.sequencer.gui.menu.DisplayStructureAction;
import com.frinika.sequencer.gui.menu.GuiCursorUpdateMenu;
import com.frinika.sequencer.gui.menu.ImportAudioAction;
import com.frinika.sequencer.gui.menu.ImportMidiToLaneAction;
import com.frinika.sequencer.gui.menu.MidiIMonitorAction;
import com.frinika.sequencer.gui.menu.MidiInSetupAction;
import com.frinika.sequencer.gui.menu.RepeatAction;
import com.frinika.sequencer.gui.menu.ScriptingAction;
import com.frinika.sequencer.gui.menu.SetAudioOutputAction;
import com.frinika.sequencer.gui.menu.SplitSelectedPartsAction;
import com.frinika.sequencer.gui.menu.TempoListEditAction;
import com.frinika.sequencer.gui.menu.TimeSignatureEditAction;
import com.frinika.sequencer.gui.menu.ToggleShowVoiceViewAction;
import com.frinika.sequencer.gui.menu.WarpToLeftAction;
import com.frinika.sequencer.gui.menu.WarpToRightAction;
import com.frinika.sequencer.gui.menu.midi.GroovePatternCreateFromMidiPartAction;
import com.frinika.sequencer.gui.menu.midi.GroovePatternManagerAction;
import com.frinika.sequencer.gui.menu.midi.MidiDurationAction;
import com.frinika.sequencer.gui.menu.midi.MidiInsertControllersAction;
import com.frinika.sequencer.gui.menu.midi.MidiQuantizeAction;
import com.frinika.sequencer.gui.menu.midi.MidiReverseAction;
import com.frinika.sequencer.gui.menu.midi.MidiShiftAction;
import com.frinika.sequencer.gui.menu.midi.MidiStepRecordAction;
import com.frinika.sequencer.gui.menu.midi.MidiTimeStretchAction;
import com.frinika.sequencer.gui.menu.midi.MidiTransposeAction;
import com.frinika.sequencer.gui.menu.midi.MidiVelocityAction;
import com.frinika.sequencer.gui.mixer.SynthWrapper;
import com.frinika.sequencer.gui.partview.VoicePartViewSplitPane;
import com.frinika.sequencer.gui.pianoroll.PianoControllerSplitPane;
import com.frinika.sequencer.gui.tracker.TrackerPanel;
import com.frinika.sequencer.gui.transport.RecordAction;
import com.frinika.sequencer.gui.transport.RewindAction;
import com.frinika.sequencer.gui.transport.StartStopAction;
import com.frinika.sequencer.model.AudioLane;
import com.frinika.sequencer.model.EditHistoryAction;
import com.frinika.sequencer.model.EditHistoryListener;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.Part;
import com.frinika.tools.BufferedPlayback;
import com.frinika.tracker.MidiFileFilter;
import com.frinika.tracker.ProjectFileFilter;
import com.frinika.tracker.filedialogs.BounceToLane;
import com.frinika.tracker.filedialogs.ExportWavDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.view.View;
import org.flexdock.view.Viewport;
import uk.org.toot.swingui.audioui.mixerui.CompactMixerPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static final String[][] FILE_FILTER_MIDIFILES = new String[][]{{"mid", "Midi standard files"}};
    private static Vector<ProjectFrame> openProjectFrames = new Vector();
    private static ProjectFrame focusFrame = null;
    private static Vector<ProjectFocusListener> projectFocusListeners = new Vector();
    TrackerPanel trackerPanel;
    PianoControllerSplitPane pianoControllerPane;
    NotationPanel notationPanel;
    VoicePartViewSplitPane partViewEditor;
    GlobalToolBar globalToolBar;
    ProjectContainer project;
    private File midiFile;
    private StartStopAction startStop;
    private RewindAction rewind;
    private WarpToLeftAction warpToLeft;
    private WarpToRightAction warpToRight;
    private Viewport viewport;
    private RecordAction record;
    private Rectangle position;
    public JPopupMenu newLaneMenu = new JPopupMenu();
    private static Icon maximize_icon = new ImageIcon(ProjectFrame.class.getResource("/icons/maximize.gif"));
    private static Icon minimize_icon = new ImageIcon(ProjectFrame.class.getResource("/icons/minimize.gif"));
    JMenu perspectivemenu;
    JMenu perspective_showmenu;
    private static Icon dockicon_tracks = ProjectFrame.getIconResource("track.gif");
    private static Icon dockicon_tracker = ProjectFrame.getIconResource("tracker.gif");
    private static Icon dockicon_midiout = ProjectFrame.getIconResource("midi_mixer.gif");
    private static Icon dockicon_voice = ProjectFrame.getIconResource("properties.gif");
    private static Icon dockicon_pianoroll = ProjectFrame.getIconResource("piano.png");
    private static Icon dockicon_mixer = ProjectFrame.getIconResource("mixer.gif");
    private static Icon dockicon_notation = ProjectFrame.getIconResource("midilane.png");
    private static Icon default_midi_icon = ProjectFrame.getIconResource("midi.png");
    private Map views = new HashMap();
    private ActionListener addMidiDevices_listener = null;
    private MidiDevice addMidiDevices_selected = null;
    private Icon addMidiDevices_selected_icon = null;
    MidiDevicesPanel midiDevicesPanel;

    public static ProjectFrame findFrame(ProjectContainer project) {
        for (ProjectFrame pr : openProjectFrames) {
            if (pr.project != project) continue;
            return pr;
        }
        return null;
    }

    public ProjectFrame(ProjectContainer project) throws Exception {
        this(project, null);
    }

    public ProjectFrame(final ProjectContainer project, Rectangle position) throws Exception {
        Dimension frameSize;
        int x;
        int y;
        this.position = position;
        project.resetEndTick();
        Receiver receiver = project.getSequencer().getReceiver();
        MidiInDeviceManager.setReceiver(receiver);
        this.addWindowListener(new WindowListener(){

            public void windowOpened(WindowEvent arg0) {
            }

            public void windowClosing(WindowEvent evt) {
                if (openProjectFrames.size() == 1) {
                    ProjectFrame.this.tryQuit();
                } else if (ProjectFrame.this.canClose()) {
                    evt.getWindow().dispose();
                }
            }

            public void windowClosed(WindowEvent arg0) {
            }

            public void windowIconified(WindowEvent arg0) {
            }

            public void windowDeiconified(WindowEvent arg0) {
            }

            public void windowActivated(WindowEvent arg0) {
                ProjectFrame.setFocusFrame(ProjectFrame.this);
                ProjectFrame.notifyProjectFocusListeners();
                try {
                    MidiInDeviceManager.setReceiver(project.getSequencer().getReceiver());
                }
                catch (MidiUnavailableException e) {
                    e.printStackTrace();
                }
            }

            public void windowDeactivated(WindowEvent arg0) {
            }
        });
        this.project = project;
        if (position == null) {
            Insets windowInsets;
            Rectangle windowSize;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsConfiguration gc = ge.getDefaultScreenDevice().getDefaultConfiguration();
            if (gc == null) {
                gc = this.getGraphicsConfiguration();
            }
            if (gc != null) {
                windowSize = gc.getBounds();
                windowInsets = toolkit.getScreenInsets(gc);
            } else {
                windowSize = new Rectangle(toolkit.getScreenSize());
                windowInsets = new Insets(0, 0, 0, 0);
            }
            windowSize.x = 0;
            int w = windowSize.width - windowSize.x - (windowInsets.left + windowInsets.right + 10);
            int h = windowSize.height - windowSize.y - (windowInsets.top + windowInsets.bottom + 10);
            y = windowInsets.top + (windowSize.height - windowSize.y - (windowInsets.top + windowInsets.bottom) - h) / 2;
            x = windowInsets.left + (windowSize.width - windowSize.x - (windowInsets.left + windowInsets.right) - w) / 2;
            frameSize = new Dimension(w, h);
            this.setSize(new Dimension(w - 1, h - 1));
        } else {
            frameSize = position.getSize();
            y = position.y;
            x = position.x;
        }
        this.setDefaultCloseOperation(0);
        this.setIconImage(new ImageIcon(ProjectFrame.class.getResource("/icons/frinika.png")).getImage());
        String name = "Frinika - Copyright (c) Frinika developers - Licensed under GNU General Public License";
        File file = project.getProjectFile();
        if (file != null) {
            name = file.getName();
        }
        this.setTitle(name);
        project.getEditHistoryContainer().addEditHistoryListener(new EditHistoryListener(){
            boolean showAsterix = false;

            public void fireSequenceDataChanged(EditHistoryAction[] edithistoryEntries) {
                if (project.getEditHistoryContainer().hasChanges() != this.showAsterix) {
                    this.showAsterix = project.getEditHistoryContainer().hasChanges();
                    if (this.showAsterix) {
                        ProjectFrame.this.setTitle(ProjectFrame.this.getTitle() + "*");
                    } else {
                        ProjectFrame.this.setTitle(ProjectFrame.this.getTitle().substring(0, ProjectFrame.this.getTitle().length() - 1));
                    }
                }
            }
        });
        if (System.getProperty("frinika.window.flexdock") == null) {
            DockingManager.setFloatingEnabled((boolean)true);
            this.viewport = new Viewport();
        }
        this.createMenu();
        this.globalToolBar = new GlobalToolBar(this);
        JPanel content = new JPanel(new BorderLayout());
        this.setContentPane(content);
        content.add((Component)this.globalToolBar, "North");
        if (this.viewport == null) {
            JTabbedPane midPanels = new JTabbedPane();
            content.add((Component)midPanels, "Center");
            midPanels.addTab(CurrentLocale.getMessage("project.maintabs.tracks"), this.createSplit(frameSize));
            this.midiDevicesPanel = new MidiDevicesPanel(this);
            midPanels.addTab(CurrentLocale.getMessage("project.maintabs.midiout_devices"), new JScrollPane(this.midiDevicesPanel));
            midPanels.addTab(CurrentLocale.getMessage("project.maintabs.audiomixer"), (Component)((Object)new FrinikaMixerPanel(project.getMixerControls())));
        } else {
            content.add((Component)this.viewport);
            this.initViews();
            this.perspectivePreset1();
        }
        this.validate();
        this.setVisible(true);
        this.setSize(frameSize);
        this.setLocation(x, y);
        openProjectFrames.add(this);
        this.overRideKeys();
        if (FrinikaConfig.MAXIMIZE_WINDOW) {
            this.setExtendedState(6);
        }
    }

    public void resetViews() {
        for (View view : this.views.values()) {
            if (view.isMinimized()) {
                DockingManager.setMinimized((Dockable)view, (boolean)false);
            }
            DockingManager.undock((Dockable)view);
        }
        this.viewport.grabFocus();
    }

    public void repaintViews() {
        this.partViewEditor.repaint();
        this.repaintPartView();
    }

    public void repaintPartView() {
        this.partViewEditor.getPartview().repaint();
        this.partViewEditor.getPartview().repaintItems();
    }

    JMenu perspectiveMenu() {
        JMenu menu = this.perspectivemenu = new JMenu(CurrentLocale.getMessage("project.menu.perspectives"));
        menu.setMnemonic(80);
        JMenuItem item = new JMenuItem(CurrentLocale.getMessage("project.menu.perspectives.Default_Perspective"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectFrame.this.perspectivePreset1();
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(112, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(item);
        item = new JMenuItem(CurrentLocale.getMessage("project.menu.perspectives.Mastering_Perspective"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectFrame.this.perspectivePreset2();
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(113, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(item);
        item = new JMenuItem(CurrentLocale.getMessage("project.menu.perspectives.Minimal_Perspective"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectFrame.this.perspectivePreset3();
            }
        });
        item.setAccelerator(KeyStroke.getKeyStroke(114, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(item);
        menu.addSeparator();
        this.perspective_showmenu = new JMenu("Show View");
        menu.add(this.perspective_showmenu);
        return menu;
    }

    public void runReallyLater(Runnable runnable) {
        new Thread(new LateRunnable(runnable)).start();
    }

    public void perspectivePreset1() {
        this.resetViews();
        this.viewport.dock((Dockable)this.getView("tracks"));
        this.getView("tracks").dock((Dockable)this.getView("pianoroll"), "SOUTH");
        this.getView("tracks").dock((Dockable)this.getView("voice"), "WEST");
        this.getView("pianoroll").dock((Dockable)this.getView("tracker"));
        this.getView("pianoroll").dock((Dockable)this.getView("notation"));
        this.getView("tracks").dock((Dockable)this.getView("midiout"));
        this.getView("tracks").dock((Dockable)this.getView("mixer"));
        ((JSplitPane)this.getView("voice").getParent().getParent()).setDividerLocation(300);
        ((JTabbedPane)this.getView("tracks").getParent()).setSelectedIndex(0);
        ((JTabbedPane)this.getView("pianoroll").getParent()).setSelectedIndex(0);
        this.viewport.grabFocus();
        this.validate();
        this.repaint();
        Runnable runnable = new Runnable(){

            public void run() {
                ((JTabbedPane)ProjectFrame.this.getView("tracks").getParent()).setSelectedIndex(0);
                ((JTabbedPane)ProjectFrame.this.getView("pianoroll").getParent()).setSelectedIndex(0);
                ProjectFrame.this.viewport.grabFocus();
            }
        };
        this.runReallyLater(runnable);
    }

    public void perspectivePreset2() {
        this.resetViews();
        this.viewport.dock((Dockable)this.getView("tracks"));
        this.getView("tracks").dock((Dockable)this.getView("mixer"), "EAST", 0.25f);
        this.getView("tracks").dock((Dockable)this.getView("pianoroll"), "SOUTH");
        this.getView("tracks").dock((Dockable)this.getView("voice"), "WEST", 0.3f);
        this.getView("pianoroll").dock((Dockable)this.getView("tracker"));
        this.getView("pianoroll").dock((Dockable)this.getView("notation"));
        this.getView("tracks").dock((Dockable)this.getView("midiout"));
        ((JSplitPane)this.getView("voice").getParent().getParent()).setDividerLocation(300);
        ((JTabbedPane)this.getView("tracks").getParent()).setSelectedIndex(0);
        ((JTabbedPane)this.getView("pianoroll").getParent()).setSelectedIndex(0);
        this.viewport.grabFocus();
        this.validate();
        this.repaint();
        Runnable runnable = new Runnable(){

            public void run() {
                ((JTabbedPane)ProjectFrame.this.getView("tracks").getParent()).setSelectedIndex(0);
                ((JTabbedPane)ProjectFrame.this.getView("pianoroll").getParent()).setSelectedIndex(0);
                ProjectFrame.this.viewport.grabFocus();
            }
        };
        this.runReallyLater(runnable);
    }

    public void perspectivePreset3() {
        this.resetViews();
        this.viewport.dock((Dockable)this.getView("tracks"));
        this.getView("tracks").dock((Dockable)this.getView("voice"), "WEST");
        this.getView("tracks").dock((Dockable)this.getView("pianoroll"));
        this.getView("tracks").dock((Dockable)this.getView("tracker"));
        this.getView("tracks").dock((Dockable)this.getView("notation"));
        this.getView("tracks").dock((Dockable)this.getView("midiout"));
        this.getView("tracks").dock((Dockable)this.getView("mixer"));
        ((JSplitPane)this.getView("voice").getParent().getParent()).setDividerLocation(300);
        ((JTabbedPane)this.getView("tracks").getParent()).setSelectedIndex(0);
        DockingManager.setMinimized((Dockable)this.getView("voice"), (boolean)true, (int)2);
        this.viewport.grabFocus();
        this.validate();
        this.repaint();
        Runnable runnable = new Runnable(){

            public void run() {
                ((JTabbedPane)ProjectFrame.this.getView("tracks").getParent()).setSelectedIndex(0);
                ProjectFrame.this.viewport.grabFocus();
            }
        };
        this.runReallyLater(runnable);
    }

    public void initViews() {
        this.partViewEditor = new VoicePartViewSplitPane(this, true);
        JComponent partViewEditor = this.partViewEditor.getPartViewEditor();
        JComponent laneView = this.partViewEditor.getLaneView();
        this.notationPanel = new NotationPanel(this);
        this.pianoControllerPane = new PianoControllerSplitPane(this);
        this.trackerPanel = new TrackerPanel(this.project.getSequence(), this);
        this.trackerPanel.setOpaque(false);
        JPanel mixer = new JPanel();
        mixer.setLayout(new BorderLayout());
        try {
            mixer.add((Component)((Object)new FrinikaMixerPanel(this.project.getMixerControls())));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.project.getPartSelection().addSelectionListener(this.trackerPanel);
        laneView.setPreferredSize(new Dimension(0, 0));
        partViewEditor.setPreferredSize(new Dimension(0, 0));
        this.pianoControllerPane.setPreferredSize(new Dimension(0, 0));
        this.pianoControllerPane.setOpaque(false);
        this.trackerPanel.setPreferredSize(new Dimension(0, 0));
        mixer.setPreferredSize(new Dimension(0, 0));
        laneView.setMinimumSize(new Dimension(0, 0));
        partViewEditor.setMinimumSize(new Dimension(0, 0));
        this.pianoControllerPane.setMinimumSize(new Dimension(0, 0));
        this.trackerPanel.setMinimumSize(new Dimension(0, 0));
        mixer.setMinimumSize(new Dimension(0, 0));
        this.createView("tracks", CurrentLocale.getMessage("project.maintabs.tracks"), partViewEditor, dockicon_tracks);
        this.createView("voice", CurrentLocale.getMessage("project.maintabs.lane_properties"), laneView, dockicon_voice);
        this.createView("pianoroll", CurrentLocale.getMessage("project.maintabs.piano_roll"), this.pianoControllerPane, dockicon_pianoroll);
        this.createView("tracker", CurrentLocale.getMessage("project.maintabs.tracker"), this.trackerPanel, dockicon_tracker);
        this.createView("notation", CurrentLocale.getMessage("project.maintabs.notation"), this.notationPanel, dockicon_notation);
        this.midiDevicesPanel = new MidiDevicesPanel(this);
        this.createView("midiout", CurrentLocale.getMessage("project.maintabs.midimixer"), new JScrollPane(this.midiDevicesPanel), dockicon_midiout);
        this.createView("mixer", CurrentLocale.getMessage("project.maintabs.audiomixer"), mixer, dockicon_mixer);
    }

    public static Icon getIconResource(String name) {
        try {
            ImageIcon icon = new ImageIcon(ProjectFrame.class.getResource("/icons/" + name));
            return icon;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Icon getMidiDeviceIcon(MidiDevice dev) {
        Icon icon = ProjectFrame.getMidiDeviceLargeIcon(dev);
        if (icon.getIconHeight() > 16 || icon.getIconWidth() > 16) {
            BufferedImage img = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 6);
            Graphics2D g = img.createGraphics();
            icon.paintIcon(null, g, 0, 0);
            g.dispose();
            Image im = img.getScaledInstance(16, 16, 4);
            icon = new ImageIcon(im);
        }
        return icon;
    }

    public static Icon getMidiDeviceLargeIcon(MidiDevice dev) {
        if (dev instanceof SynthWrapper) {
            dev = ((SynthWrapper)dev).getRealDevice();
        }
        Icon icon = default_midi_icon;
        try {
            Method icon_method = dev.getClass().getMethod("getIcon", new Class[0]);
            icon = (Icon)icon_method.invoke((Object)dev, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return icon;
    }

    private View getView(String id) {
        return (View)this.views.get(id);
    }

    private View createView(String id, String text, JComponent content, Icon icon) {
        final View view = new View(id, text);
        if (icon != null) {
            view.setIcon(icon);
        }
        if (icon != null) {
            view.setTabIcon(icon);
        }
        this.views.put(id, view);
        JMenuItem menuitem = new JMenuItem(text);
        menuitem.setIcon(icon);
        menuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DockingManager.undock((Dockable)view);
                Set dockables = ProjectFrame.this.viewport.getDockables();
                if (dockables.size() == 0) {
                    ProjectFrame.this.viewport.dock((Dockable)view);
                } else {
                    ((View)dockables.iterator().next()).dock((Dockable)view);
                }
                ProjectFrame.this.validate();
                ProjectFrame.this.repaint();
            }
        });
        this.perspective_showmenu.add(menuitem);
        AbstractAction max_action = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public Object getValue(String key) {
                if (key.equals("Name")) {
                    return "maximize";
                }
                if (key.equals("ShortDescription")) {
                    return "Maximize";
                }
                if (key.equals("SmallIcon")) {
                    return maximize_icon;
                }
                return super.getValue(key);
            }

            public void actionPerformed(ActionEvent e) {
                DockingManager.toggleMaximized((Dockable)view);
                focusFrame.repaint();
                DockingManager.display((Dockable)view);
            }
        };
        view.addAction("close");
        view.getTitlebar().addAction((Action)max_action);
        view.addAction("pin");
        view.getTitlebar().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DockingManager.toggleMaximized((Dockable)view);
                    ProjectFrame.this.repaint();
                    DockingManager.display((Dockable)view);
                    return;
                }
                super.mouseClicked(e);
            }
        });
        view.setContentPane((Container)content);
        return view;
    }

    protected static void setFocusFrame(ProjectFrame frame) {
        if (frame != focusFrame) {
            focusFrame = frame;
            System.out.println(" Setting focus project " + frame.getProjectContainer().getFile());
        }
    }

    public static ProjectFrame getFocusFrame() {
        return focusFrame;
    }

    void overRideKeys() {
        this.startStop = new StartStopAction(this);
        this.rewind = new RewindAction(this);
        this.record = new RecordAction(this);
        this.warpToLeft = new WarpToLeftAction(this);
        this.warpToRight = new WarpToRightAction(this);
        final SelectAllAction selectAllAction = new SelectAllAction(this);
        KeyboardFocusManager kbm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kbm.addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent e) {
                if (!ProjectFrame.this.isActive()) {
                    return false;
                }
                if (e.getSource() instanceof JTextComponent) {
                    return false;
                }
                switch (e.getKeyCode()) {
                    case 32: {
                        if (e.getID() == 401) {
                            ProjectFrame.this.startStop.actionPerformed(null);
                        }
                        return true;
                    }
                    case 36: {
                        if (e.getID() == 401) {
                            ProjectFrame.this.rewind.actionPerformed(null);
                        }
                        return true;
                    }
                    case 106: {
                        if (e.getID() == 401) {
                            ProjectFrame.this.record.actionPerformed(null);
                        }
                        return true;
                    }
                    case 97: {
                        if (e.getID() == 401) {
                            ProjectFrame.this.warpToLeft.actionPerformed(null);
                        }
                        return true;
                    }
                    case 98: {
                        if (e.getID() == 401) {
                            ProjectFrame.this.warpToRight.actionPerformed(null);
                        }
                        return true;
                    }
                    case 65: {
                        if (e.getID() != 401 || !e.isControlDown()) break;
                        return selectAllAction.selectAll(e);
                    }
                }
                return false;
            }
        });
    }

    JMenu fileMenu() {
        JMenu fileMenu = new JMenu(CurrentLocale.getMessage("project.menu.file"));
        JMenuItem newProjectMenuItem = new JMenuItem(CurrentLocale.getMessage("project.menu.file.new_project"));
        newProjectMenuItem.setIcon(ProjectFrame.getIconResource("new.gif"));
        newProjectMenuItem.addActionListener(new CreateProjectAction());
        fileMenu.add(newProjectMenuItem);
        JMenuItem openProjectMenuItem = new JMenuItem(CurrentLocale.getMessage("project.menu.file.open_project"));
        openProjectMenuItem.setIcon(ProjectFrame.getIconResource("open.gif"));
        openProjectMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setDialogTitle(CurrentLocale.getMessage("project.menu.file.open_project.dialogtitle"));
                    chooser.setFileFilter(new ProjectNewFileFilter());
                    if (ProjectFrame.this.project.getProjectFile() != null) {
                        chooser.setSelectedFile(ProjectFrame.this.project.getProjectFile());
                    }
                    if (chooser.showOpenDialog(ProjectFrame.this) == 0) {
                        File newProject = chooser.getSelectedFile();
                        new ProjectFrame(ProjectContainer.loadProject(newProject), ProjectFrame.this.position);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        fileMenu.add(openProjectMenuItem);
        JMenuItem closeMenuItem = new JMenuItem(CurrentLocale.getMessage("close"));
        closeMenuItem.setMnemonic(67);
        closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        closeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (openProjectFrames.size() == 1) {
                    ProjectFrame.this.tryQuit();
                } else if (ProjectFrame.this.canClose()) {
                    ProjectFrame.this.dispose();
                }
            }
        });
        fileMenu.add(closeMenuItem);
        fileMenu.add(new JSeparator());
        JMenuItem saveProjectMenuItem = new JMenuItem(CurrentLocale.getMessage("project.menu.file.save_project"));
        saveProjectMenuItem.setIcon(ProjectFrame.getIconResource("save.gif"));
        saveProjectMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        saveProjectMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (ProjectFrame.this.project.getProjectFile() != null) {
                        ProjectFrame.this.project.saveProject(ProjectFrame.this.project.getProjectFile());
                        FrinikaConfig.setLastProjectFilename(ProjectFrame.this.project.getProjectFile().getAbsolutePath());
                    } else {
                        ProjectFrame.this.openSaveProjectDialog();
                    }
                }
                catch (Exception ex) {
                    ProjectFrame.this.error("Error while saving", ex);
                    ex.printStackTrace();
                }
            }
        });
        fileMenu.add(saveProjectMenuItem);
        JMenuItem saveProjectAsMenuItem = new JMenuItem(CurrentLocale.getMessage("project.menu.file.save_project_as"));
        saveProjectAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectFrame.this.openSaveProjectDialog();
            }
        });
        fileMenu.add(saveProjectAsMenuItem);
        fileMenu.addSeparator();
        JMenuItem importMidiMenuItem = new JMenuItem(CurrentLocale.getMessage("project.menu.file.import_midi"));
        importMidiMenuItem.setIcon(ProjectFrame.getIconResource("import.gif"));
        importMidiMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setDialogTitle(CurrentLocale.getMessage("project.menu.file.import_midi"));
                    chooser.setFileFilter(new MidiFileFilter());
                    if (ProjectFrame.this.midiFile != null) {
                        chooser.setSelectedFile(ProjectFrame.this.midiFile);
                    }
                    if (chooser.showOpenDialog(ProjectFrame.this) == 0) {
                        File newMidiFile = chooser.getSelectedFile();
                        MidiDevice mididdevice = ProjectFrame.this.selectMidiDevice();
                        ProjectFrame frame = new ProjectFrame(new ProjectContainer(MidiSystem.getSequence(newMidiFile), mididdevice));
                        ProjectFrame.this.midiFile = newMidiFile;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        fileMenu.add(importMidiMenuItem);
        JMenuItem item = new JMenuItem("Import Module...");
        item.setIcon(ProjectFrame.getIconResource("import.gif"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MODImporter.load(ProjectFrame.this);
            }
        });
        fileMenu.add(item);
        JMenuItem exportMidiMenuItem = new JMenuItem(CurrentLocale.getMessage("project.menu.file.export_midi"));
        exportMidiMenuItem.setIcon(ProjectFrame.getIconResource("export.gif"));
        exportMidiMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setDialogTitle(CurrentLocale.getMessage("project.menu.file.export_midi"));
                    chooser.setFileFilter(new MidiFileFilter());
                    chooser.setSelectedFile(ProjectFrame.this.midiFile);
                    if (chooser.showSaveDialog(ProjectFrame.this) == 0) {
                        if (chooser.getFileFilter() instanceof MidiFileFilter && !chooser.getFileFilter().accept(chooser.getSelectedFile())) {
                            chooser.setSelectedFile(new File(chooser.getSelectedFile().getPath() + ".mid"));
                        }
                        File newMidiFile = chooser.getSelectedFile();
                        MidiSystem.write(ProjectFrame.this.project.getSequence().export(), 1, newMidiFile);
                        ProjectFrame.this.midiFile = newMidiFile;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        fileMenu.addSeparator();
        fileMenu.add(exportMidiMenuItem);
        JMenuItem exportWavMenuItem = new JMenuItem(CurrentLocale.getMessage("project.menu.file.export_wav"));
        exportWavMenuItem.setIcon(ProjectFrame.getIconResource("export.gif"));
        exportWavMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    int i;
                    JFileChooser chooser = new JFileChooser();
                    chooser.setDialogTitle("Export Audio");
                    byte[] data = new byte[16];
                    AudioFormat format = new AudioFormat(FrinikaConfig.sampleRate, 16, 2, true, true);
                    AudioInputStream ais = new AudioInputStream(new ByteArrayInputStream(data), format, 4L);
                    AudioFileFormat.Type[] types = AudioSystem.getAudioFileTypes(ais);
                    AudioFileFilter[] filters = new AudioFileFilter[types.length];
                    for (i = 0; i < types.length; ++i) {
                        filters[i] = new AudioFileFilter(types[i]);
                    }
                    for (i = 0; i < filters.length; ++i) {
                        chooser.setFileFilter(filters[i]);
                    }
                    for (i = 0; i < filters.length; ++i) {
                        if (!filters[i].getType().getExtension().toUpperCase().equals("WAV")) continue;
                        chooser.setFileFilter(filters[i]);
                    }
                    if (chooser.showSaveDialog(ProjectFrame.this) == 0) {
                        if (chooser.getFileFilter() instanceof AudioFileFilter && !chooser.getFileFilter().accept(chooser.getSelectedFile())) {
                            chooser.setSelectedFile(new File(chooser.getSelectedFile().getPath() + "." + ((AudioFileFilter)chooser.getFileFilter()).getType().getExtension().toLowerCase()));
                        }
                        FrinikaSequencer sequencer = ProjectFrame.this.project.getSequencer();
                        long startTick = sequencer.getLoopStartPoint();
                        long endTick = sequencer.getLoopEndPoint();
                        AudioFileFormat.Type type = ((AudioFileFilter)chooser.getFileFilter()).getType();
                        new ExportWavDialog(ProjectFrame.this, ProjectFrame.this.project, type, chooser.getSelectedFile(), startTick, endTick);
                        ProjectFrame.this.project.getSequencer().stop();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            class AudioFileFilter
            extends FileFilter {
                AudioFileFormat.Type type;

                AudioFileFilter(AudioFileFormat.Type type) {
                    this.type = type;
                }

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return f.getName().toLowerCase().endsWith("." + this.type.getExtension().toLowerCase());
                }

                public String getDescription() {
                    return this.type.toString() + " (*." + this.type.getExtension() + ")";
                }

                public AudioFileFormat.Type getType() {
                    return this.type;
                }
            }
        });
        fileMenu.add(exportWavMenuItem);
        if (!FrinikaMain.isMac()) {
            fileMenu.addSeparator();
            JMenuItem quitMenuItem = new JMenuItem(CurrentLocale.getMessage("quit"));
            quitMenuItem.setMnemonic(81);
            quitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            quitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ProjectFrame.this.tryQuit();
                }
            });
            fileMenu.add(quitMenuItem);
        }
        return fileMenu;
    }

    JMenu debugMenu() {
        JMenu debugMenu = new JMenu("debug");
        JMenuItem item = new JMenuItem(new DisplayStructureAction(this));
        debugMenu.add(item);
        item = new JMenuItem("Buffered Playback");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BufferedPlayback bp = new BufferedPlayback(ProjectFrame.this, ProjectFrame.this.getProjectContainer());
                bp.start();
            }
        });
        debugMenu.add(item);
        item = new JMenuItem(new MidiIMonitorAction());
        debugMenu.add(item);
        item = new JMenuItem("ConfigListener");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigListener l = new ConfigListener(){

                    public void configurationChanged(ChangeEvent event) {
                        FrinikaConfig.Meta meta = (FrinikaConfig.Meta)event.getSource();
                        try {
                            System.out.println("configuration changed: " + meta.getField().getName() + "=" + meta.getField().get(null));
                        }
                        catch (IllegalAccessException iae) {
                            iae.printStackTrace();
                        }
                    }
                };
                FrinikaConfig.addConfigListener(l);
            }
        });
        debugMenu.add(item);
        return debugMenu;
    }

    JMenu renderMenu() {
        JMenu menu = new JMenu(CurrentLocale.getMessage("project.menu.render"));
        menu.setMnemonic(82);
        JMenuItem item = new JMenuItem("Render Selected Timeline");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ProjectFrame.this.project.getSequencer().isRunning()) {
                    ProjectFrame.this.project.getSequencer().stop();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                if (ProjectFrame.this.project.getSequencer().getLoopStartPoint() == ProjectFrame.this.project.getSequencer().getLoopEndPoint()) {
                    JOptionPane.showMessageDialog(ProjectFrame.this, "Please select timeline using loop markers!", "Render Selected Timeline", 2);
                    return;
                }
                ProjectFrame.this.project.getRenderer().render(ProjectFrame.this, ProjectFrame.this.project.getSequencer().getLoopStartPoint(), ProjectFrame.this.project.getSequencer().getLoopEndPoint());
            }
        });
        menu.add(item);
        item = new JMenuItem("Rerender Selected Timeline");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ProjectFrame.this.project.getSequencer().isRunning()) {
                    ProjectFrame.this.project.getSequencer().stop();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                if (ProjectFrame.this.project.getSequencer().getLoopStartPoint() == ProjectFrame.this.project.getSequencer().getLoopEndPoint()) {
                    JOptionPane.showMessageDialog(ProjectFrame.this, "Please select timeline using loop markers!", "Rerender Selected Timeline", 2);
                    return;
                }
                ProjectFrame.this.project.getRenderer().rerender(ProjectFrame.this, ProjectFrame.this.project.getSequencer().getLoopStartPoint(), ProjectFrame.this.project.getSequencer().getLoopEndPoint());
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Clear Render Cache");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ProjectFrame.this.project.getSequencer().isRunning()) {
                    ProjectFrame.this.project.getSequencer().stop();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                ProjectFrame.this.project.getRenderer().purgeRenderCache();
            }
        });
        menu.add(item);
        menu.addSeparator();
        final JCheckBoxMenuItem item_supress_realtime = new JCheckBoxMenuItem("Suppress RealTime Devices while playing");
        item_supress_realtime.setSelected(true);
        item_supress_realtime.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProjectFrame.this.project.getRenderer().setSupressRealTime(item_supress_realtime.isSelected());
            }
        });
        menu.add(item_supress_realtime);
        return menu;
    }

    public void addMidiDevices(JComponent menu, List<MidiDevice.Info> infos, List<Icon> icons) {
        Iterator<Icon> icon_iterator = icons.iterator();
        for (MidiDevice.Info info : infos) {
            JMenuItem item = new JMenuItem(info.toString());
            item.setIcon(icon_iterator.next());
            final Icon icon = item.getIcon();
            final MidiDevice.Info f_info = info;
            item.addActionListener(new ActionListener(){
                MidiDevice.Info m_info;
                {
                    this.m_info = f_info;
                }

                public void actionPerformed(ActionEvent e) {
                    MidiDevice midiDevice = null;
                    try {
                        midiDevice = MidiSystem.getMidiDevice(this.m_info);
                        if (ProjectFrame.this.addMidiDevices_listener != null) {
                            ProjectFrame.this.addMidiDevices_selected = midiDevice;
                            ProjectFrame.this.addMidiDevices_selected_icon = icon;
                            ProjectFrame.this.addMidiDevices_listener.actionPerformed(null);
                            return;
                        }
                        midiDevice = new SynthWrapper(ProjectFrame.this.project, midiDevice);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    try {
                        ProjectFrame.this.project.getEditHistoryContainer().mark("X");
                        ProjectFrame.this.project.addMidiOutDevice(midiDevice);
                        ProjectFrame.this.project.getEditHistoryContainer().notifyEditHistoryListeners();
                    }
                    catch (MidiUnavailableException e2) {
                        e2.printStackTrace();
                    }
                    ProjectFrame.this.midiDevicesPanel.updateDeviceTabs();
                }
            });
            menu.add(item);
        }
    }

    public void addMidiDevices(JComponent menu) {
        ArrayList<MidiDevice.Info> infos = new ArrayList<MidiDevice.Info>();
        ArrayList<Icon> icons = new ArrayList<Icon>();
        ArrayList<MidiDevice.Info> infos1 = new ArrayList<MidiDevice.Info>();
        ArrayList<Icon> icons1 = new ArrayList<Icon>();
        ArrayList<MidiDevice.Info> infos2 = new ArrayList<MidiDevice.Info>();
        ArrayList<Icon> icons2 = new ArrayList<Icon>();
        for (MidiDevice.Info info : MidiSystem.getMidiDeviceInfo()) {
            try {
                MidiDevice dev = MidiSystem.getMidiDevice(info);
                if (dev.getMaxReceivers() == 0) continue;
                Icon icon = ProjectFrame.getMidiDeviceIcon(dev);
                if (dev instanceof Synthesizer) {
                    infos1.add(info);
                    icons1.add(icon);
                    continue;
                }
                if (icon == default_midi_icon) {
                    infos2.add(info);
                    icons2.add(icon);
                    continue;
                }
                infos.add(info);
                icons.add(icon);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.addMidiDevices(menu, infos1, icons1);
        menu.add(new JSeparator());
        this.addMidiDevices(menu, infos, icons);
        menu.add(new JSeparator());
        this.addMidiDevices(menu, infos2, icons2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiDevice selectMidiDevice() {
        try {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(new JLabel("MIDI Out Device:"));
            final JButton but = new JButton("No Device Selected");
            but.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JPopupMenu popup = new JPopupMenu();
                    ProjectFrame.this.addMidiDevices(popup);
                    popup.show(but, 0, 0);
                }
            });
            this.addMidiDevices_selected = null;
            this.addMidiDevices_listener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    but.setText(ProjectFrame.this.addMidiDevices_selected.getDeviceInfo().getName());
                    but.setIcon(ProjectFrame.this.addMidiDevices_selected_icon);
                }
            };
            panel.add(but);
            int opt = JOptionPane.showConfirmDialog(this, panel, "Select MIDI Output", 2, 3);
            this.addMidiDevices_listener = null;
            if (opt == 0) {
                MidiDevice midiDevice = this.addMidiDevices_selected;
                return midiDevice;
            }
        }
        finally {
            this.addMidiDevices_listener = null;
        }
        return null;
    }

    JMenu newDeviceMenu() {
        final JMenu newDeviceMenu = new JMenu(CurrentLocale.getMessage("newdevice.menu"));
        newDeviceMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                newDeviceMenu.removeAll();
                ProjectFrame.this.addMidiDevices(newDeviceMenu);
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
        return newDeviceMenu;
    }

    JMenu editMenu() {
        CutPasteMenu editMenu = new CutPasteMenu(this.project);
        editMenu.add(new JSeparator());
        JMenuItem item = new JMenuItem(new CreateMidiLaneAction(this));
        item.setIcon(ProjectFrame.getIconResource("new_track_midi.gif"));
        item.setAccelerator(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        editMenu.add(item);
        item = new JMenuItem(new CreateMidiDrumLaneAction(this));
        item.setIcon(ProjectFrame.getIconResource("new_track_midi_drum.gif"));
        item.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        editMenu.add(item);
        item = new JMenuItem(new CreateAudioLaneAction(this));
        item.setIcon(ProjectFrame.getIconResource("new_track_audio.gif"));
        item.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        editMenu.add(item);
        item = new JMenuItem(new CreateTextLaneAction(this));
        item.setIcon(ProjectFrame.getIconResource("new_track_text.gif"));
        item.setAccelerator(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        editMenu.add(item);
        editMenu.addSeparator();
        editMenu.add(this.newDeviceMenu());
        item = new JMenuItem(new CreateMidiLaneAction(this));
        item.setIcon(ProjectFrame.getIconResource("new_track_midi.gif"));
        item.setAccelerator(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        this.newLaneMenu.add(item);
        item = new JMenuItem(new CreateMidiDrumLaneAction(this));
        item.setIcon(ProjectFrame.getIconResource("new_track_midi_drum.gif"));
        item.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        this.newLaneMenu.add(item);
        item = new JMenuItem(new CreateAudioLaneAction(this));
        item.setIcon(ProjectFrame.getIconResource("new_track_audio.gif"));
        item.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        this.newLaneMenu.add(item);
        item = new JMenuItem(new CreateTextLaneAction(this));
        item.setIcon(ProjectFrame.getIconResource("new_track_text.gif"));
        item.setAccelerator(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        this.newLaneMenu.add(item);
        this.newLaneMenu.addSeparator();
        this.newLaneMenu.add(this.newDeviceMenu());
        editMenu.addSeparator();
        JMenuItem bounceToLane = new JMenuItem(CurrentLocale.getMessage("project.menu.file.bounce_to_lane"));
        bounceToLane.setIcon(ProjectFrame.getIconResource("new_track_audio.gif"));
        bounceToLane.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Lane lane = (Lane)ProjectFrame.this.project.getLaneSelection().getFocus();
                ProjectFrame.this.project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.audiolane.record"));
                if (lane == null || !(lane instanceof AudioLane)) {
                    lane = ProjectFrame.this.project.createAudioLane();
                }
                File file = ((AudioLane)lane).newFilename();
                FrinikaSequencer sequencer = ProjectFrame.this.project.getSequencer();
                long startTick = sequencer.getLoopStartPoint();
                long endTick = sequencer.getLoopEndPoint();
                new BounceToLane(ProjectFrame.this, ProjectFrame.this.project, file, startTick, endTick, (AudioLane)lane);
                ProjectFrame.this.project.getSequencer().stop();
            }
        });
        editMenu.add(bounceToLane);
        item = new JMenuItem(new ImportAudioAction(this));
        item.setIcon(ProjectFrame.getIconResource("import.gif"));
        editMenu.add(item);
        item = new JMenuItem(new ImportMidiToLaneAction(this));
        item.setIcon(ProjectFrame.getIconResource("import.gif"));
        editMenu.add(item);
        editMenu.add(new JSeparator());
        item = new JMenuItem(new RepeatAction(this));
        item.setMnemonic(82);
        item.setAccelerator(KeyStroke.getKeyStroke(82, 0));
        editMenu.add(item);
        editMenu.add(new JMenuItem(new SplitSelectedPartsAction(this)));
        editMenu.add(new JSeparator());
        editMenu.add(new TimeSignatureEditAction(this));
        editMenu.add(new TempoListEditAction(this));
        return editMenu;
    }

    JMenu settingsMenu() {
        JMenu settingsMenu = new JMenu(CurrentLocale.getMessage("project.menu.settings"));
        settingsMenu.setMnemonic(83);
        JMenuItem item = new JMenuItem(new MidiInSetupAction());
        item.setIcon(ProjectFrame.getIconResource("midi.png"));
        settingsMenu.add(item);
        settingsMenu.addSeparator();
        item = new JMenuItem(new SetAudioOutputAction(this));
        settingsMenu.add(item);
        item.setIcon(ProjectFrame.getIconResource("output.gif"));
        item = new CheckBoxMenuItemConfig(CurrentLocale.getMessage("project.menu.settings.direct_monitoring"), FrinikaConfig._DIRECT_MONITORING);
        settingsMenu.add(item);
        item = new CheckBoxMenuItemConfig(CurrentLocale.getMessage("project.menu.settings.multiplexed_audio"), FrinikaConfig._MULTIPLEXED_AUDIO);
        settingsMenu.add(item);
        item = new JMenuItem(CurrentLocale.getMessage("project.menu.settings.audio_latency"));
        item.setIcon(ProjectFrame.getIconResource("output.gif"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FrinikaAudioSystem.latencyMeasureSet();
            }
        });
        settingsMenu.add(item);
        settingsMenu.add(item);
        item = new JMenuItem(CurrentLocale.getMessage("project.menu.settings.configure_audio_server"));
        item.setIcon(ProjectFrame.getIconResource("output.gif"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FrinikaAudioSystem.configure();
            }
        });
        settingsMenu.add(item);
        settingsMenu.addSeparator();
        item = new CheckBoxMenuItemConfig(CurrentLocale.getMessage("project.menu.settings.jack_autoconnect"), FrinikaConfig._JACK_AUTO_CONNECT);
        settingsMenu.add(item);
        settingsMenu.addSeparator();
        settingsMenu.add(new GuiCursorUpdateMenu(this.project));
        settingsMenu.addSeparator();
        item = new JMenuItem(CurrentLocale.getMessage("project.menu.settings.show"));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FrinikaConfig.showDialog(ProjectFrame.this);
            }
        });
        settingsMenu.add(item);
        return settingsMenu;
    }

    JMenu toolsMenu() {
        JMenu toolsMenu = new JMenu(CurrentLocale.getMessage("project.menu.tools"));
        toolsMenu.setMnemonic(84);
        JMenuItem item = new JMenuItem(new MidiQuantizeAction(this));
        item.setMnemonic(81);
        item.setAccelerator(KeyStroke.getKeyStroke(81, 0));
        toolsMenu.add(item);
        this.project.getMidiSelection().addMenuItem(item);
        item = new JMenuItem(new MidiTransposeAction(this));
        item.setMnemonic(84);
        item.setAccelerator(KeyStroke.getKeyStroke(84, 0));
        toolsMenu.add(item);
        this.project.getMidiSelection().addMenuItem(item);
        item = new JMenuItem(new MidiVelocityAction(this));
        item.setMnemonic(86);
        item.setAccelerator(KeyStroke.getKeyStroke(86, 0));
        toolsMenu.add(item);
        this.project.getMidiSelection().addMenuItem(item);
        item = new JMenuItem(new MidiShiftAction(this));
        item.setMnemonic(83);
        item.setAccelerator(KeyStroke.getKeyStroke(83, 0));
        toolsMenu.add(item);
        this.project.getMidiSelection().addMenuItem(item);
        item = new JMenuItem(new MidiDurationAction(this));
        item.setMnemonic(68);
        item.setAccelerator(KeyStroke.getKeyStroke(68, 0));
        toolsMenu.add(item);
        this.project.getMidiSelection().addMenuItem(item);
        item = new JMenuItem(new MidiTimeStretchAction(this));
        item.setMnemonic(77);
        item.setAccelerator(KeyStroke.getKeyStroke(77, 0));
        toolsMenu.add(item);
        this.project.getMidiSelection().addMenuItem(item);
        item = new JMenuItem(new MidiReverseAction(this));
        item.setMnemonic(69);
        item.setAccelerator(KeyStroke.getKeyStroke(69, 0));
        toolsMenu.add(item);
        this.project.getMidiSelection().addMenuItem(item);
        item = new JMenuItem(new MidiInsertControllersAction(this));
        item.setMnemonic(73);
        item.setAccelerator(KeyStroke.getKeyStroke(73, 0));
        toolsMenu.add(item);
        this.project.getMidiSelection().addMenuItem(item);
        toolsMenu.addSeparator();
        item = new JMenuItem(new MidiStepRecordAction(this));
        item.setText(item.getText() + "...");
        item.setMnemonic(155);
        item.setAccelerator(KeyStroke.getKeyStroke(155, 0));
        toolsMenu.add(item);
        toolsMenu.addSeparator();
        JMenu submenu = new JMenu(CurrentLocale.getMessage("sequencer.midi.groovepattern"));
        item = new JMenuItem(new GroovePatternManagerAction(this));
        item.setText(item.getText() + "...");
        item.setMnemonic(77);
        item.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        submenu.add(item);
        item = new JMenuItem(new GroovePatternCreateFromMidiPartAction(this));
        item.setMnemonic(67);
        item.setAccelerator(KeyStroke.getKeyStroke(122, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1));
        submenu.add(item);
        toolsMenu.add(submenu);
        toolsMenu.addSeparator();
        submenu = new JMenu(CurrentLocale.getMessage("sequencer.project.scripting"));
        ScriptingAction sa = new ScriptingAction(this);
        item = new JMenuItem(sa);
        item.setText(item.getText() + "...");
        item.setMnemonic(71);
        item.setAccelerator(KeyStroke.getKeyStroke(123, 0));
        submenu.add(item);
        sa.initDialog(submenu);
        toolsMenu.add(submenu);
        return toolsMenu;
    }

    JMenu helpMenu() {
        JMenu helpMenu = new JMenu(CurrentLocale.getMessage("project.menu.help"));
        helpMenu.setMnemonic(72);
        JMenuItem aboutMenuItem = new JMenuItem(CurrentLocale.getMessage("project.menu.help.about"));
        aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                About.about(ProjectFrame.this);
            }
        });
        aboutMenuItem.setMnemonic(65);
        helpMenu.add(aboutMenuItem);
        return helpMenu;
    }

    JMenu viewMenu() {
        JMenu menu = new JMenu("View");
        menu.setMnemonic(86);
        JMenuItem item = new JMenuItem(new ToggleShowVoiceViewAction(this));
        item.setAccelerator(KeyStroke.getKeyStroke(120, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(item);
        return menu;
    }

    JMenuBar createMenu() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        menuBar.add(this.fileMenu());
        menuBar.add(this.editMenu());
        if (this.viewport == null) {
            menuBar.add(this.viewMenu());
        } else {
            menuBar.add(this.perspectiveMenu());
        }
        menuBar.add(this.settingsMenu());
        menuBar.add(this.toolsMenu());
        menuBar.add(this.renderMenu());
        if (!FrinikaMain.isMac()) {
            menuBar.add(this.helpMenu());
        }
        return menuBar;
    }

    JSplitPane createSplit(Dimension frameSize) {
        JSplitPane split = new JSplitPane(0);
        split.setOneTouchExpandable(true);
        this.pianoControllerPane = new PianoControllerSplitPane(this);
        TrackerPanel trackerPanel = new TrackerPanel(this.project.getSequence(), this);
        frameSize.height /= 3;
        this.partViewEditor = new VoicePartViewSplitPane(this, false);
        this.partViewEditor.setPreferredSize(frameSize);
        this.project.getPartSelection().addSelectionListener(trackerPanel);
        JTabbedPane editorTabs = new JTabbedPane();
        editorTabs.setPreferredSize(frameSize);
        editorTabs.addTab("Piano roll", this.pianoControllerPane);
        editorTabs.addTab("Tracker", trackerPanel);
        CompactMixerPanel mixer = new CompactMixerPanel(this.project.getMixerControls());
        mixer.setMinimumSize(new Dimension(0, 0));
        editorTabs.addTab(CurrentLocale.getMessage("project.maintabs.audiomixer"), (Component)mixer);
        split.setTopComponent(this.partViewEditor);
        split.setBottomComponent(editorTabs);
        return split;
    }

    public void tryQuit() {
        while (openProjectFrames.size() > 1) {
            System.out.println("Open project count:" + openProjectFrames.size());
            ProjectFrame frame = openProjectFrames.firstElement();
            if (frame == this) {
                frame = openProjectFrames.lastElement();
            }
            if (!frame.canClose()) continue;
            frame.dispose();
        }
        String quitMessage = this.project.getEditHistoryContainer().hasChanges() ? CurrentLocale.getMessage("quit.doYouReallyWantTo.unsaved") : CurrentLocale.getMessage("quit.doYouReallyWantTo");
        if (JOptionPane.showOptionDialog(this, quitMessage, CurrentLocale.getMessage("quit.really"), 0, 3, null, null, null) == 0) {
            MidiInDeviceManager.close();
            FrinikaConfig.storeAndQuit();
        }
    }

    private boolean canClose() {
        if (this.project.getEditHistoryContainer().hasChanges()) {
            return JOptionPane.showOptionDialog(this, CurrentLocale.getMessage("close.unsavedChanges"), CurrentLocale.getMessage("close.unsavedChanges.dialogTitle"), 0, 3, null, null, null) == 0;
        }
        return true;
    }

    @Override
    public void dispose() {
        this.project.close();
        openProjectFrames.remove(this);
        super.dispose();
    }

    public ProjectContainer getProjectContainer() {
        return this.project;
    }

    public void infoMessage(String string) {
        this.message(string);
    }

    public MidiDevicesPanel getMidiDevicesPanel() {
        return this.midiDevicesPanel;
    }

    public VoicePartViewSplitPane getVoicePartViewSplitPane() {
        return this.partViewEditor;
    }

    public static void midiInDeviceChange() {
        System.out.println("MIDIIN CHANGER");
        MidiInDeviceManager.reset();
    }

    public void message(String msg, int type) {
        JOptionPane.showMessageDialog(this, msg, "Frinika Message", type);
    }

    public void message(String msg) {
        this.message(msg, 1);
    }

    public void error(String msg) {
        this.message(msg, 0);
    }

    public void error(String msg, Throwable t) {
        t.printStackTrace();
        this.error(msg + " - " + t.getMessage());
    }

    public void error(Throwable t) {
        this.error(t.getClass().getName(), t);
    }

    public boolean confirm(String msg) {
        int result = JOptionPane.showConfirmDialog(this, msg, "Frinika Question", 2, 3);
        return result == 0;
    }

    public String prompt(String msg, String initialValue) {
        if (initialValue == null) {
            initialValue = "";
        }
        String result = JOptionPane.showInputDialog(this, msg, initialValue);
        return result;
    }

    public String prompt(String msg) {
        return this.prompt(msg, null);
    }

    public String promptFile(String defaultFilename, String[][] suffices, boolean saveMode, boolean directoryMode) {
        int r;
        JFileChooser fc = new JFileChooser();
        if (!directoryMode) {
            final boolean save = saveMode;
            if (suffices != null) {
                for (int i = 0; i < suffices.length; ++i) {
                    final String suffix = suffices[i][0];
                    final String description = suffices[i][1];
                    FileFilter ff = new FileFilter(){

                        public boolean accept(File file) {
                            if (file.isDirectory()) {
                                return true;
                            }
                            String name = file.getName();
                            return suffix.equals("*") || name.endsWith("." + suffix) || save && ProjectFrame.fileDoesntExistAndDoesntEndWithAnySuffix(file);
                        }

                        public String getDescription() {
                            return "." + suffix + " - " + description;
                        }
                    };
                    fc.addChoosableFileFilter(ff);
                }
            }
        } else {
            fc.setFileSelectionMode(1);
        }
        if (defaultFilename != null) {
            File file = new File(defaultFilename);
            fc.setSelectedFile(file);
        }
        if ((r = saveMode ? fc.showSaveDialog(this) : fc.showOpenDialog(this)) == 0) {
            File fl;
            File file = fc.getSelectedFile();
            String name = file.getName();
            String extraSuffix = "";
            if (name.indexOf(46) == -1 && suffices != null && suffices.length > 0) {
                extraSuffix = "." + suffices[0][0];
            }
            String filename = file.getAbsolutePath() + extraSuffix;
            if (saveMode && (fl = new File(filename)).exists() && !this.confirm("File " + filename + " already exists. Overwrite?")) {
                return null;
            }
            return filename;
        }
        return null;
    }

    public String promptFile(String defaultFilename, String[][] suffices, boolean saveMode) {
        return this.promptFile(defaultFilename, suffices, saveMode, false);
    }

    public String promptFile(String defaultFilename, String[][] suffices) {
        return this.promptFile(defaultFilename, suffices, false);
    }

    private static boolean fileDoesntExistAndDoesntEndWithAnySuffix(File file) {
        if (file.exists()) {
            return false;
        }
        String name = file.getName();
        return name.indexOf(46) == -1;
    }

    void openSaveProjectDialog() {
        try {
            ProjectFileFilter no_compression = new ProjectFileFilter();
            ProjectFileFilter zip_compressed = new ProjectFileFilter(){

                public String getDescription() {
                    return "Frinika project (ZIP Compressed)";
                }
            };
            ProjectFileFilter lzma_compressed = new ProjectFileFilter(){

                public String getDescription() {
                    return "Frinika project (LZMA Compressed)";
                }
            };
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Save Frinika project");
            chooser.setFileFilter(no_compression);
            chooser.setFileFilter(zip_compressed);
            chooser.setFileFilter(lzma_compressed);
            chooser.setFileFilter(no_compression);
            chooser.setSelectedFile(this.project.getProjectFile());
            if (chooser.showSaveDialog(this) == 0) {
                int saveOption;
                File newProject = chooser.getSelectedFile();
                if (chooser.getFileFilter() instanceof ProjectFileFilter && !chooser.getFileFilter().accept(newProject)) {
                    newProject = new File(newProject.getPath() + ".frinika");
                }
                if ((saveOption = JOptionPane.showOptionDialog(this, CurrentLocale.getMessage("project.save.include_referenced_data"), CurrentLocale.getMessage("project.save.include_referenced_data.title"), 0, 3, null, null, null)) == 1) {
                    this.project.setSaveReferencedData(false);
                } else if (saveOption == 0) {
                    this.project.setSaveReferencedData(true);
                }
                this.project.compression_level = chooser.getFileFilter() == lzma_compressed ? 2 : (chooser.getFileFilter() == zip_compressed ? 1 : 0);
                this.project.saveProject(newProject);
                FrinikaConfig.setLastProjectFilename(newProject.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            this.error("Error while saving", ex);
            ex.printStackTrace();
        }
    }

    public void showRightButtonPartPopup(Component invoker, int x, int y) {
        Part part = (Part)this.project.getPartSelection().getFocus();
        if (part == null) {
            return;
        }
        if (part.showRightButtonMenu(invoker, x, y)) {
            return;
        }
        part.showContextMenu(this, invoker, x, y);
    }

    public static void addProjectFocusListener(ProjectFocusListener l) {
        projectFocusListeners.add(l);
    }

    public static void removeProjectFocusListener(ProjectFocusListener l) {
        projectFocusListeners.remove(l);
    }

    public static void notifyProjectFocusListeners() {
        for (ProjectFocusListener l : projectFocusListeners) {
            l.projectFocusNotify(focusFrame.getProjectContainer());
        }
    }

    public static void staticMessage(ProjectContainer container, String string) {
        for (ProjectFrame f : openProjectFrames) {
            if (f.project != container) continue;
            f.message(string);
            return;
        }
    }

    public static List<ProjectFrame> getOpenProjectFrames() {
        return Collections.unmodifiableList(openProjectFrames);
    }

    static class CheckBoxMenuItemConfig
    extends JCheckBoxMenuItem
    implements ActionListener,
    ConfigListener {
        private FrinikaConfig.Meta configOption;

        public CheckBoxMenuItemConfig(String text, FrinikaConfig.Meta configOption) {
            super(text);
            this.configOption = configOption;
            if (configOption.getType() != Boolean.TYPE && configOption.getType() != Boolean.class) {
                throw new ConfigError("cannot bind checkbox-menu-item to option '" + configOption.getName() + "' which is of type " + configOption.getType().getName());
            }
            this.refresh();
            this.addActionListener(this);
            FrinikaConfig.addConfigListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            this.update();
        }

        public void configurationChanged(ChangeEvent e) {
            if (e.getSource() == this.configOption) {
                this.refresh();
            }
        }

        private void refresh() {
            boolean b = Boolean.valueOf(this.configOption.get().toString());
            this.setSelected(b);
        }

        private void update() {
            boolean b = this.isSelected();
            this.configOption.set(b);
        }
    }

    private class LateRunnable
    implements Runnable {
        Runnable runnable;

        public LateRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        public void run() {
            try {
                SwingUtilities.invokeAndWait(this.runnable);
                Thread.sleep(200L);
                SwingUtilities.invokeAndWait(this.runnable);
                Thread.sleep(200L);
                SwingUtilities.invokeAndWait(this.runnable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

