/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.project.scripting;

import com.frinika.global.FrinikaConfig;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.project.scripting.DefaultFrinikaScript;
import com.frinika.project.scripting.FrinikaScript;
import com.frinika.project.scripting.ScriptContainer;
import com.frinika.project.scripting.ScriptListener;
import com.frinika.project.scripting.ScriptThread;
import com.frinika.project.scripting.gui.ScriptingDialog;
import com.frinika.project.scripting.javascript.JavascriptScope;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.MultiEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import org.mozilla.javascript.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrinikaScriptingEngine
implements ScriptContainer,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final File GLOBAL_PROPERTIES_FILE = new File(FrinikaConfig.SCRIPTS_DIRECTORY, "scripting.properties");
    static transient Map<FrinikaScript, ScriptThread> runningScripts = new HashMap<FrinikaScript, ScriptThread>();
    static transient Properties global = null;
    private static transient Collection<ScriptListener> scriptListeners = new HashSet<ScriptListener>();
    protected Collection<FrinikaScript> scripts;
    protected ProjectContainer project;
    protected Properties persistent = null;

    public static void executeScript(FrinikaScript script, ProjectFrame frame, ScriptingDialog dialog) {
        ScriptThread thread = new ScriptThread(script, frame, dialog);
        thread.start();
    }

    static Object runScript(FrinikaScript script, ProjectFrame frame, ScriptingDialog dialog) {
        int language = script.getLanguage();
        String name = script.getName();
        if (language != 1) {
            System.out.println("cannot execute script " + name + ": unsupported language " + language);
            return null;
        }
        System.out.println("Executing script '" + name + "'...");
        String source = script.getSource();
        frame.getProjectContainer().getEditHistoryContainer().mark("Script " + name);
        Collection events = frame.getProjectContainer().getMidiSelection().getSelected();
        TreeSet<MultiEvent> clones = new TreeSet<MultiEvent>();
        if (events != null) {
            for (MultiEvent ev : events) {
                try {
                    MultiEvent clone = (MultiEvent)ev.clone();
                    clones.add(clone);
                }
                catch (CloneNotSupportedException cnse) {
                    cnse.printStackTrace();
                }
            }
        }
        Object result = FrinikaScriptingEngine.executeJavascript(source, name, frame, clones, dialog);
        if (events != null) {
            Iterator clonesIterator = clones.iterator();
            for (MultiEvent ev : events) {
                ev.getPart().remove(ev);
                ev.restoreFromClone((EditHistoryRecordable)clonesIterator.next());
                ev.getPart().add(ev);
            }
        }
        if (result != null) {
            System.out.println(result.toString());
        }
        frame.getProjectContainer().getEditHistoryContainer().notifyEditHistoryListeners();
        return result;
    }

    public static void stopScript(FrinikaScript script) {
        ScriptThread thread = runningScripts.get(script);
        if (thread != null) {
            thread.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object executeJavascript(String source, String name, ProjectFrame frame, SortedSet<MultiEvent> events, ScriptingDialog dialog) {
        Context cx = Context.enter();
        try {
            Object result;
            JavascriptScope scope = new JavascriptScope(cx, frame, events, dialog);
            try {
                result = cx.evaluateString(scope, source, name, 1, null);
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    frame.message("Script execution has been aborted.");
                    result = "";
                }
                frame.error(t);
                result = null;
            }
            if (result != null) {
                String string = Context.toString(result);
                return string;
            }
            Object var8_10 = null;
            return var8_10;
        }
        finally {
            Context.exit();
        }
    }

    public static void addScriptListener(ScriptListener l) {
        scriptListeners.add(l);
    }

    public static void removeScriptListener(ScriptListener l) {
        scriptListeners.remove(l);
    }

    protected static void notifyScriptListeners(FrinikaScript script, Object returnValue) {
        for (ScriptListener l : scriptListeners) {
            if (returnValue == script) {
                l.scriptStarted(script);
                continue;
            }
            l.scriptExited(script, returnValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void globalPut(String variable, String value) {
        if (global == null) {
            FrinikaScriptingEngine.loadGlobalProperties();
        }
        if (global == null) {
            global = new Properties();
        }
        Properties properties = global;
        synchronized (properties) {
            global.put(variable, value);
            try {
                FileOutputStream out = new FileOutputStream(GLOBAL_PROPERTIES_FILE);
                global.store(out, "Frinika Scripting - Global Properties");
                ((OutputStream)out).close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static String globalGet(String variable) {
        if (global == null) {
            FrinikaScriptingEngine.loadGlobalProperties();
        }
        if (global != null) {
            return global.getProperty(variable);
        }
        return null;
    }

    private static void loadGlobalProperties() {
        try {
            Properties p = new Properties();
            FileInputStream in = new FileInputStream(GLOBAL_PROPERTIES_FILE);
            p.load(in);
            ((InputStream)in).close();
            global = p;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public FrinikaScriptingEngine(ProjectContainer project) {
        this.project = project;
        this.scripts = new ArrayList<FrinikaScript>();
    }

    @Override
    public Collection<FrinikaScript> getScripts() {
        return this.scripts;
    }

    @Override
    public void addScript(FrinikaScript script) {
        if (!this.scripts.contains(script)) {
            this.scripts.add(script);
        }
    }

    @Override
    public void removeScript(FrinikaScript script) {
        this.scripts.remove(script);
    }

    public Properties getPersistentProperties() {
        if (this.persistent == null) {
            this.persistent = new Properties();
        }
        return this.persistent;
    }

    public FrinikaScript loadScript(File file) throws IOException {
        String source = FrinikaScriptingEngine.loadString(file);
        DefaultFrinikaScript script = new DefaultFrinikaScript();
        script.setLanguage(1);
        script.setSource(source);
        String name = file.getAbsolutePath();
        script.setFilename(name);
        this.addScript(script);
        return script;
    }

    public void saveScript(FrinikaScript script, File file) throws IOException {
        FrinikaScriptingEngine.saveString(script.getSource(), file);
        if (script instanceof DefaultFrinikaScript) {
            ((DefaultFrinikaScript)script).setFilename(file.getAbsolutePath());
        }
    }

    public static String loadString(File file) throws IOException {
        long len = file.length();
        char[] c = new char[(int)len];
        FileReader f = new FileReader(file);
        f.read(c);
        f.close();
        return new String(c);
    }

    public static void saveString(String s, File file) throws IOException {
        FileWriter f = new FileWriter(file);
        f.write(s);
        f.close();
    }

    private void writeObject(ObjectOutputStream out) throws ClassNotFoundException, IOException {
        ArrayList<FrinikaScript> c = new ArrayList<FrinikaScript>(this.scripts);
        for (FrinikaScript script : this.scripts) {
            if (script instanceof Serializable) continue;
            c.remove(script);
        }
        Collection<FrinikaScript> backup = this.scripts;
        this.scripts = c;
        out.defaultWriteObject();
        this.scripts = backup;
    }
}

