/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer;

import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.SongPositionListener;
import com.frinika.synth.envelope.MidiVolume;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;

public class Metronome
implements AudioProcess,
SongPositionListener {
    float[] sampleData;
    float level = 0.0f;
    boolean active = false;
    ProjectContainer project;
    int metSamplePos = 0;

    public Metronome(ProjectContainer project) throws Exception {
        this.project = project;
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(ClassLoader.getSystemResource("sounds/metronome1.wav"));
            this.sampleData = new float[(int)stream.getFrameLength()];
            int index = 0;
            byte[] frame = new byte[2];
            int b = stream.read(frame);
            while (b != -1) {
                this.sampleData[index++] = (float)(frame[1] * 256 + (frame[0] & 0xFF)) / 32768.0f;
                b = stream.read(frame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setVelocity(int velocity) {
        if (velocity > 0) {
            if (!this.active) {
                this.project.getSequencer().addSongPositionListener(this);
                this.active = true;
            }
            this.level = MidiVolume.midiVolumeToAmplitudeRatio(velocity);
        } else {
            this.project.getSequencer().removeSongPositionListener(this);
            this.active = false;
        }
    }

    public void notifyTickPosition(long tick) {
        if (tick % (long)this.project.getSequence().getResolution() == 0L) {
            this.metSamplePos = 0;
        }
    }

    public boolean requiresNotificationOnEachTick() {
        return true;
    }

    public int processAudio(AudioBuffer buffer) {
        float[] left = buffer.getChannel(0);
        float[] right = buffer.getChannel(1);
        int n = 0;
        while (n < buffer.getSampleCount() && this.metSamplePos < this.sampleData.length) {
            int n2 = n;
            left[n2] = left[n2] + this.sampleData[this.metSamplePos] * this.level;
            int n3 = n++;
            right[n3] = right[n3] + this.sampleData[this.metSamplePos++] * this.level;
        }
        return 0;
    }

    public void open() {
    }

    public void close() {
    }
}

