/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import com.frinika.gui.ToolbarSeperator;
import com.frinika.gui.util.ButtonFactory;
import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.gui.ItemPanel;
import com.frinika.sequencer.gui.NoteLengthPopup;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.sound.midi.Sequence;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemRollToolBar
extends JToolBar
implements ActionListener {
    private static final long serialVersionUID = 1L;
    Insets insets = new Insets(0, 0, 0, 0);
    Cursor writeCursor;
    JToggleButton zoomBut = null;
    JToggleButton follow;
    JToggleButton quantize;
    JPanel zoom;
    Vector<ItemPanel> clients;
    ProjectContainer project;
    private JButton quantizeSet;
    JPanel tools;
    ButtonGroup toolGroup;

    public ItemRollToolBar(Vector<ItemPanel> cli, ProjectContainer project) {
        this.setMargin(new Insets(0, 0, 0, 0));
        this.project = project;
        FlowLayout layout = new FlowLayout(1, 0, 0);
        this.clients = cli;
        for (ItemPanel client : this.clients) {
            client.setToolBar(this);
        }
        this.tools = new JPanel(layout);
        this.tools.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.tools.setOpaque(false);
        this.toolGroup = new ButtonGroup();
        JToggleButton but = ButtonFactory.makeToggleButton("select", "select", CurrentLocale.getMessage("seqeuncer.toolbar.select_tip"), this, this.toolGroup, this.tools);
        but.setMargin(this.insets);
        ButtonFactory.makeToggleButton("pencil", "write", CurrentLocale.getMessage("seqeuncer.toolbar.write_tip"), this, this.toolGroup, this.tools).setMargin(this.insets);
        ButtonFactory.makeToggleButton("eraser", "erase", CurrentLocale.getMessage("seqeuncer.toolbar.erase_tip"), this, this.toolGroup, this.tools).setMargin(this.insets);
        ButtonFactory.makeToggleButton("hand", "dragview", CurrentLocale.getMessage("seqeuncer.toolbar.dragclick_tip"), this, this.toolGroup, this.tools).setMargin(this.insets);
        this.add(this.tools);
        this.add(new ToolbarSeperator());
        JPanel settings = new JPanel(layout);
        settings.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        settings.setOpaque(false);
        this.follow = ItemRollToolBar.makeFollowSongButton(this, settings);
        this.follow.setSelected(this.clients.firstElement().isFollowSong());
        this.follow.setMargin(this.insets);
        this.quantize = ButtonFactory.makeToggleButton("quantize", "snaptoON", CurrentLocale.getMessage("sequencer.toolbar.snapto_toggle_tip"), this, null, settings);
        this.quantize.setMargin(this.insets);
        this.quantize.setSelected(this.clients.firstElement().isSnapQuantized());
        this.quantizeSet = ItemRollToolBar.makeSnapToButton(this.clients, settings, project.getSequence());
        this.quantizeSet.setMargin(this.insets);
        this.add(settings);
        this.add(new ToolbarSeperator());
        this.zoom = new JPanel(layout);
        this.zoom.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.zoom.setOpaque(false);
        this.zoomBut = ButtonFactory.makeToggleButton("viewmagfit", "magrect", CurrentLocale.getMessage("sequencer.toolbar.zoomtorect_tip"), this, null, this.zoom);
        this.zoomBut.setMargin(this.insets);
        ButtonFactory.makePressButton("viewmag+", "zoomin", CurrentLocale.getMessage("sequencer.toolbar.zoomin_tip"), this, this.zoom).setMargin(this.insets);
        ButtonFactory.makePressButton("viewmag-", "zoomout", CurrentLocale.getMessage("sequencer.toolbar.zoomout_tip"), this, this.zoom).setMargin(this.insets);
        this.add(this.zoom);
        this.add(new ToolbarSeperator());
        but.setSelected(true);
        for (ItemPanel client : this.clients) {
            client.setTool("select");
        }
    }

    public void addButtonToTools(String icon, String cmd, String popup) {
        ButtonFactory.makeToggleButton(icon, cmd, popup, this, this.toolGroup, this.tools).setMargin(this.insets);
    }

    public static JToggleButton makeFollowSongButton(ActionListener actionListener, JPanel panel) {
        return ButtonFactory.makeToggleButton(CurrentLocale.getMessage("sequencer.play.follow"), CurrentLocale.getMessage("sequencer.play.follow"), CurrentLocale.getMessage("sequencer.play.follow_song"), actionListener, null, panel);
    }

    public static JButton makeSnapToButton(final Vector clients, JPanel panel, final Sequence sequence) {
        final JButton snapToButton = ButtonFactory.makePressButton("music_quarternote", "snaptoSET", CurrentLocale.getMessage("sequencer.toolbar.snaptolength_tip"), null, panel);
        snapToButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new NoteLengthPopup(snapToButton, clients, sequence).show(snapToButton, 0, 0);
            }
        });
        NoteLengthPopup.updateButton(snapToButton, clients, sequence);
        return snapToButton;
    }

    public void rectZoomFinished() {
        for (ItemPanel client : this.clients) {
            client.setTool("origtool");
        }
        this.zoomBut.setSelected(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("zoomin")) {
            for (ItemPanel client : this.clients) {
                client.zoomIn();
            }
            return;
        }
        if (cmd.equals("zoomout")) {
            for (ItemPanel client : this.clients) {
                client.zoomOut();
            }
            return;
        }
        if (cmd.equals("follow")) {
            for (ItemPanel client : this.clients) {
                client.followSong(this.follow.isSelected());
            }
            return;
        }
        if (cmd.equals("extend")) {
            this.project.setEndTick(this.project.getEndTick() + (long)(this.project.getSequence().getResolution() * 8));
            return;
        }
        if (cmd.equals("snaptoON")) {
            for (ItemPanel client : this.clients) {
                client.setSnapQuantized(this.quantize.isSelected());
            }
            return;
        }
        for (ItemPanel client : this.clients) {
            client.setTool(cmd);
        }
    }

    public JPanel getZoomPanel() {
        return this.zoom;
    }

    public JPanel getToolsPanel() {
        return this.tools;
    }
}

