/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.SongPositionListener;
import com.frinika.sequencer.SwingSongPositionListenerWrapper;
import com.frinika.sequencer.gui.TimeFormat;
import com.frinika.sequencer.gui.TimeSelector;
import com.frinika.sequencer.model.util.TimeUtils;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LoopPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    ProjectContainer project;
    FrinikaSequencer sequencer;
    TimeSelector sectionStartTimeSelector;
    TimeSelector sectionEndTimeSelector;
    TimeUtils timeUtil;

    public LoopPanel(ProjectContainer project) {
        this.project = project;
        this.sequencer = project.getSequencer();
        this.timeUtil = new TimeUtils(project);
        this.initComponents();
        this.setText();
        this.sequencer.addSongPositionListener(new SwingSongPositionListenerWrapper(new SongPositionListener(){

            public void notifyTickPosition(long tick) {
                LoopPanel.this.setText();
            }

            public boolean requiresNotificationOnEachTick() {
                return false;
            }
        }));
    }

    void setText() {
        this.sectionStartTimeSelector.setTicks(this.sequencer.getLoopStartPoint());
        this.sectionEndTimeSelector.setTicks(this.sequencer.getLoopEndPoint());
    }

    void initComponents() {
        this.sectionStartTimeSelector = new TimeSelector(CurrentLocale.getMessage("globaltoolbar.loop.start"), 0L, this.project, TimeFormat.BAR_BEAT_TICK);
        this.sectionStartTimeSelector.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                LoopPanel.this.sequencer.setLoopStartPoint(LoopPanel.this.sectionStartTimeSelector.getTicks());
            }
        });
        this.add(this.sectionStartTimeSelector);
        this.sectionEndTimeSelector = new TimeSelector(CurrentLocale.getMessage("globaltoolbar.loop.end"), 0L, this.project, TimeFormat.BAR_BEAT_TICK);
        this.sectionEndTimeSelector.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                LoopPanel.this.sequencer.setLoopEndPoint(LoopPanel.this.sectionEndTimeSelector.getTicks());
            }
        });
        this.add(this.sectionEndTimeSelector);
        JToggleButton loopButton = new JToggleButton(new ImageIcon(ClassLoader.getSystemResource("icons/loop.png")));
        loopButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    LoopPanel.this.sequencer.setLoopCount(-1);
                } else {
                    LoopPanel.this.sequencer.setLoopCount(0);
                }
            }
        });
        this.add(loopButton);
    }
}

