/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import com.frinika.global.FrinikaConfig;
import com.frinika.project.gui.ProjectFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class MidiInDevicePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    Vector<JCheckBox> boxes = new Vector();

    public MidiInDevicePanel() {
        this.setLayout(new BoxLayout(this, 1));
        MidiDevice.Info[] infos = MidiSystem.getMidiDeviceInfo();
        Vector<String> names = new Vector<String>();
        for (String name : FrinikaConfig.getMidiInDeviceList()) {
            names.add(name);
        }
        ActionListener act = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Vector<String> list = new Vector<String>();
                for (JCheckBox box : MidiInDevicePanel.this.boxes) {
                    if (!box.isSelected()) continue;
                    list.add(box.getText());
                }
                FrinikaConfig.setMidiInDeviceList(list);
                FrinikaConfig.store();
                ProjectFrame.midiInDeviceChange();
            }
        };
        for (MidiDevice.Info info : infos) {
            try {
                MidiDevice dev = MidiSystem.getMidiDevice(info);
                if (dev.getMaxTransmitters() == 0) continue;
                String str = dev.getDeviceInfo().toString();
                JCheckBox box = new JCheckBox(str, names.contains(str));
                this.boxes.add(box);
                box.addActionListener(act);
                this.add(box);
            }
            catch (MidiUnavailableException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setContentPane(new MidiInDevicePanel());
        f.pack();
        f.setVisible(true);
    }
}

