/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.ImageIcon;

public class MyCursors {
    static Cursor pencil;
    static Cursor eraser;
    static Cursor move;
    static Cursor glue;
    static boolean inited;

    static Cursor cursorFromName(String name) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension dim = tk.getBestCursorSize(16, 16);
        ImageIcon icon = null;
        try {
            if (dim.getWidth() == 16.0) {
                icon = new ImageIcon(ClassLoader.getSystemResource("icons/" + name + ".png"));
            } else if (dim.getWidth() == 32.0) {
                icon = new ImageIcon(ClassLoader.getSystemResource("icons/" + name + "32.png"));
            } else {
                try {
                    throw new Exception(" System does not support 16x16 or 32x32 custom cursors (SOB) ");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (name.equals("move")) {
                return tk.createCustomCursor(icon.getImage(), new Point(8, 8), name);
            }
            return tk.createCustomCursor(icon.getImage(), new Point(0, icon.getIconHeight() - 1), name);
        }
        catch (Exception e) {
            System.out.println("name was " + name);
            e.printStackTrace();
            return null;
        }
    }

    static void init() {
        pencil = MyCursors.cursorFromName("pencil");
        eraser = MyCursors.cursorFromName("eraser");
        move = MyCursors.cursorFromName("hand");
        glue = MyCursors.cursorFromName("glue");
        inited = true;
    }

    public static Cursor getCursor(String name) {
        if (!inited) {
            MyCursors.init();
        }
        if (name.equals("pencil")) {
            return pencil;
        }
        if (name.equals("eraser")) {
            return eraser;
        }
        if (name.equals("move")) {
            return move;
        }
        if (name.equals("glue")) {
            return glue;
        }
        try {
            throw new Exception(" unknown name ");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        inited = false;
    }
}

