/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import com.frinika.sequencer.gui.EditTool;
import com.frinika.sequencer.gui.Item;
import com.frinika.sequencer.gui.ItemPanel;
import com.frinika.sequencer.gui.ToolAdapter;
import com.frinika.sequencer.gui.partview.PartView;
import com.frinika.sequencer.model.TextPart;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class SelectTool
extends ToolAdapter
implements EditTool {
    boolean dragging = false;
    private Point deltaDrag;
    static int dragMode = -1;

    public SelectTool(Cursor c) {
        super(c);
    }

    public void mousePressed(MouseEvent e) {
        this.client = (ItemPanel)e.getSource();
        if (this.client.isTimeLineEvent(e)) {
            return;
        }
        boolean shift = e.isShiftDown();
        this.client.setControlState(e.isControlDown());
        this.client.setAltState(e.isAltDown());
        Point p = new Point(e.getX(), e.getY());
        this.client.map(p);
        Item item = this.client.itemAt(p);
        this.client.ignorePartWarp(true);
        if (item != null) {
            this.client.feedBack(item);
            if (!item.isSelected()) {
                if (!shift) {
                    this.client.clientClearSelection();
                }
                this.client.clientAddToSelection(item);
            } else if (shift) {
                this.client.clientRemoveFromSelection(item);
            } else {
                this.client.setFocus(item);
            }
            if (e.getButton() == 3) {
                this.client.rightButtonPressedOnItem(e.getX(), e.getY());
                return;
            }
        }
        if (item == null) {
            if (!shift) {
                this.client.clientClearSelection();
            }
            this.client.selectRect.mousePressed(e);
        } else {
            this.client.armDrag(p, item);
            this.dragging = true;
        }
        this.client.clientNotifySelectionChange();
        this.client.ignorePartWarp(false);
    }

    public void mouseDragged(MouseEvent e) {
        Point p = new Point(e.getX(), e.getY());
        this.client.map(p);
        Point d = this.client.scrollToContian(p);
        this.client.selectRect.translate(-d.x, -d.y);
        if (this.client.selectRect.isActive()) {
            this.client.selectRect.mouseDragged(e);
        } else if (this.dragging) {
            this.client.dragTo(p);
        }
        this.client.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        if (this.client.selectRect.isActive()) {
            if (!e.isShiftDown()) {
                this.client.clientClearSelection();
            }
            this.client.selectRect.mouseRelease(e);
            this.client.selectInRect(this.client.mapRect(this.client.selectRect), e.isShiftDown());
        } else if (this.dragging) {
            this.client.endDrag();
            this.dragging = false;
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.client = (ItemPanel)e.getSource();
        Point p = new Point(e.getX(), e.getY());
        this.client.map(p);
        int dragNew = this.client.getHoverStateAt(p);
        if (dragNew == dragMode) {
            return;
        }
        dragMode = dragNew;
        this.client.setDragMode(dragNew);
    }

    public void mouseClicked(MouseEvent e) {
        SelectTool.handleMouseClicked(e, this);
    }

    static void handleMouseClicked(MouseEvent e, ToolAdapter a) {
        if (e.getClickCount() == 2) {
            a.client = (ItemPanel)e.getSource();
            Point p = new Point(e.getX(), e.getY());
            a.client.map(p);
            Item item = a.client.itemAt(p);
            a.client.ignorePartWarp(true);
            if (item != null && item instanceof TextPart) {
                ((TextPart)item).startInplaceEdit((PartView)a.client);
            }
        }
    }
}

