/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui;

import com.frinika.sequencer.gui.ListenerSupport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SliderNumberEditable
extends JPanel {
    protected String prefix;
    protected String suffix;
    protected float value;
    protected float minimum = -100.0f;
    protected float maximum = 100.0f;
    protected float stepSize = 0.0f;
    protected int orientation = 0;
    protected ListenerSupport<ChangeListener, ChangeEvent> changeListeners = new ListenerSupport<ChangeListener, ChangeEvent>(){

        @Override
        public void notify(ChangeListener l, ChangeEvent e) {
            l.stateChanged(e);
        }
    };
    private JLabel prefixLabel;
    private JSlider slider;
    private JSpinner spinner;
    private JLabel suffixLabel;

    public SliderNumberEditable() {
        this.initComponents();
        this.layoutComponents();
    }

    public SliderNumberEditable(float value, float minimum, float maximum, float stepSize, String prefix, String suffix, int orientation) {
        this.initComponents();
        this.setValue(value);
        this.setMinimum(minimum);
        this.setMaximum(maximum);
        this.setStepSize(stepSize);
        this.setPrefix(prefix);
        this.setSuffix(suffix);
        this.setOrientation(orientation);
        this.layoutComponents();
        this.validate();
    }

    @Override
    public void validate() {
        SpinnerNumberModel model = new SpinnerNumberModel(Float.valueOf(this.value), Float.valueOf(this.minimum), Float.valueOf(this.maximum), Float.valueOf(this.stepSize));
        this.setModel(model);
        super.validate();
    }

    public void setModel(SpinnerNumberModel model) {
        this.slider.setModel(SliderNumberEditable.toBoundedRangeModel(model));
        this.spinner.setModel(model);
        if (((Float)model.getMaximum()).floatValue() == 100.0f) {
            JFormattedTextField tf = ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
            tf.setColumns(3);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.slider.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.slider.setEnabled(enabled);
        this.spinner.setEnabled(enabled);
    }

    public boolean getInverted() {
        return this.slider.getInverted();
    }

    public int getMajorTickSpacing() {
        return this.slider.getMajorTickSpacing();
    }

    public int getMinorTickSpacing() {
        return this.slider.getMinorTickSpacing();
    }

    public int getOrientation() {
        return this.slider.getOrientation();
    }

    public boolean getPaintLabels() {
        return this.slider.getPaintLabels();
    }

    public boolean getPaintTicks() {
        return this.slider.getPaintTicks();
    }

    public boolean getPaintTrack() {
        return this.slider.getPaintTrack();
    }

    public boolean getSnapToTicks() {
        return this.slider.getSnapToTicks();
    }

    public void setInverted(boolean b) {
        this.slider.setInverted(b);
    }

    public void setMajorTickSpacing(int n) {
        this.slider.setMajorTickSpacing(n);
    }

    public void setMinorTickSpacing(int n) {
        this.slider.setMinorTickSpacing(n);
    }

    public void setOrientation(int orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.slider.setOrientation(orientation);
            this.layoutComponents();
            super.validate();
        }
    }

    public void setPaintLabels(boolean b) {
        this.slider.setPaintLabels(b);
    }

    public void setPaintTicks(boolean b) {
        this.slider.setPaintTicks(b);
    }

    public void setPaintTrack(boolean b) {
        this.slider.setPaintTrack(b);
    }

    public void setSnapToTicks(boolean b) {
        this.slider.setSnapToTicks(b);
    }

    public static BoundedRangeModel toBoundedRangeModel(SpinnerNumberModel m) {
        return new DefaultBoundedRangeModel((int)((Float)m.getValue()).floatValue(), 0, (int)((Float)m.getMinimum()).floatValue(), (int)((Float)m.getMaximum()).floatValue());
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.addListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.removeListener(l);
    }

    public Collection<ChangeListener> getChangeListeners() {
        return this.changeListeners.getListeners();
    }

    private void spinnerStateChanged(ChangeEvent evt) {
        this.setValue(((Float)this.spinner.getModel().getValue()).floatValue());
    }

    private void sliderStateChanged(ChangeEvent evt) {
        this.setValue(this.slider.getModel().getValue());
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        if (prefix != null) {
            this.prefixLabel.setText(prefix);
        } else {
            this.remove(this.prefixLabel);
        }
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
        if (suffix != null) {
            this.suffixLabel.setText(suffix);
        } else {
            this.remove(this.suffixLabel);
        }
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        if (value < this.minimum) {
            value = this.minimum;
        } else if (value > this.maximum) {
            value = this.maximum;
        }
        if (value != this.value) {
            this.value = value;
            this.slider.setValue(Math.round(value));
            this.spinner.setValue(Float.valueOf(value));
            this.changeListeners.notifyListeners(new ChangeEvent(this));
        }
    }

    public float getMinimum() {
        return this.minimum;
    }

    public void setMinimum(float minimum) {
        this.minimum = minimum;
    }

    public float getMaximum() {
        return this.maximum;
    }

    public void setMaximum(float maximum) {
        this.maximum = maximum;
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(float stepSize) {
        this.stepSize = stepSize;
    }

    private void initComponents() {
        this.slider = new JSlider();
        this.prefixLabel = new JLabel();
        this.spinner = new JSpinner();
        this.suffixLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SliderNumberEditable.this.sliderStateChanged(evt);
            }
        });
        this.spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                SliderNumberEditable.this.spinnerStateChanged(evt);
            }
        });
    }

    private void layoutComponents() {
        this.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (this.orientation == 0) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
        } else {
            gridBagConstraints.fill = 3;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
        }
        this.add((Component)this.slider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        if (this.orientation == 0) {
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        }
        this.add((Component)this.prefixLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        if (this.orientation == 0) {
            gridBagConstraints.anchor = 11;
        }
        this.add((Component)this.spinner, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        if (this.orientation == 0) {
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        }
        this.add((Component)this.suffixLabel, gridBagConstraints);
    }
}

