/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.clipboard;

import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.Selectable;
import java.util.Collection;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyClipboard {
    CType cType;
    private static final Class EVENT = null;
    Vector<Selectable> copy;
    ProjectContainer srcProject;
    long leftTickOfCopy;
    long rightTickOfCopy;
    private int leftColumnOfCopy;
    static MyClipboard instance;

    private MyClipboard() {
    }

    public static MyClipboard the() {
        if (instance == null) {
            instance = new MyClipboard();
        }
        return instance;
    }

    public void copy(Collection<Selectable> list, long selectionStartTick, int selectionLeftColumn, ProjectContainer srcProject) {
        this.copy(list, srcProject);
        this.leftTickOfCopy = selectionStartTick;
        this.leftColumnOfCopy = selectionLeftColumn;
        System.out.println("Left tracker column of copy: " + this.leftColumnOfCopy);
    }

    public void copy(Collection<? extends Selectable> collection, ProjectContainer srcProject) {
        this.srcProject = srcProject;
        this.copy = this.deepCopy(collection, null);
        this.leftTickOfCopy = Long.MAX_VALUE;
        this.rightTickOfCopy = Long.MIN_VALUE;
        this.leftColumnOfCopy = 0;
        if (this.copy.elementAt(0) instanceof Part) {
            this.cType = CType.PART;
        }
        if (this.copy.elementAt(0) instanceof MultiEvent) {
            this.cType = CType.EVENT;
        }
        for (Selectable it : this.copy) {
            if (it == null) continue;
            this.leftTickOfCopy = Math.min(this.leftTickOfCopy, it.leftTickForMove());
            this.rightTickOfCopy = Math.max(this.rightTickOfCopy, it.rightTickForMove());
        }
        System.out.println("Left tick of copy: " + this.leftTickOfCopy);
    }

    public void paste(ProjectContainer dstProject) {
        this.paste(dstProject.getSequencer().getTickPosition(), 0, false, dstProject);
    }

    public void paste(long tickDest, int selectionLeftColumn, boolean trackerOverrideSnap, ProjectContainer dstProject) {
        if (this.copy == null || this.copy.size() == 0) {
            System.out.println(" Nothing in the paste buffer to paste!");
            return;
        }
        long dTick = tickDest - this.leftTickOfCopy;
        long tNew = -1L;
        MidiPart srcPart = null;
        Part dstPart = null;
        if (this.cType == CType.EVENT) {
            if (!trackerOverrideSnap) {
                dTick = dstProject.eventQuantize(dTick);
            }
            srcPart = ((MultiEvent)this.copy.elementAt(0)).getPart();
            dstPart = (Part)dstProject.getPartSelection().getFocus();
            if (dstPart == null) {
                System.out.println(" Please set part focus before paste operation");
                return;
            }
        } else if (this.cType == CType.PART) {
            dTick = dstProject.partQuantize(dTick);
        }
        Vector<Selectable> paste = null;
        if (dstProject != this.srcProject && this.cType == CType.PART) {
            Lane lane = (Lane)dstProject.getLaneSelection().getFocus();
            if (lane == null) {
                System.out.println(" Please select a lane in the destination project ");
                return;
            }
            paste = this.deepCopy(this.copy, lane);
        } else {
            paste = this.deepCopy(this.copy, dstPart);
        }
        int deltaTrackerColumn = selectionLeftColumn - this.leftColumnOfCopy;
        System.out.println("Paste selectionLeftColumn: " + selectionLeftColumn + " leftColumnOfCopy:" + this.leftColumnOfCopy + " deltaTrackerColumn: " + deltaTrackerColumn);
        for (Selectable it : paste) {
            if (it instanceof MultiEvent) {
                MultiEvent evt = (MultiEvent)it;
                if (evt.getTrackerColumn() != null) {
                    evt.setTrackerColumn(evt.getTrackerColumn() + deltaTrackerColumn);
                } else {
                    evt.setTrackerColumn(selectionLeftColumn);
                }
            }
            it.deepMove(dTick);
            it.addToModel();
        }
        if (this.cType == CType.EVENT) {
            dstProject.getMultiEventSelection().setSelectedX(paste);
        } else if (this.cType == CType.PART) {
            dstProject.getPartSelection().setSelectedX(paste);
        }
    }

    private Vector<Selectable> deepCopy(Collection<? extends Selectable> collection, Selectable newParent) {
        Vector<Selectable> ret = new Vector<Selectable>();
        for (Selectable selectable : collection) {
            Selectable itClone = selectable.deepCopy(newParent);
            ret.add(itClone);
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CType {
        PART,
        EVENT;

    }
}

