/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.menu.CopyAction;
import com.frinika.sequencer.gui.menu.CutAction;
import com.frinika.sequencer.gui.menu.DeleteAction;
import com.frinika.sequencer.gui.menu.PasteAction;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class CutPasteMenu
extends JMenu {
    private static final long serialVersionUID = 1L;
    JMenuItem undoMenuItem = new JMenuItem();
    JMenuItem redoMenuItem = new JMenuItem();
    JMenuItem cutMenuItem;
    JMenuItem copyMenuItem;
    JMenuItem pasteMenuItem;
    JMenuItem deleteMenuItem;

    public static Icon getIconResource(String name) {
        return new ImageIcon(ProjectFrame.class.getResource("/icons/" + name));
    }

    public CutPasteMenu(ProjectContainer project) {
        this.setText(CurrentLocale.getMessage("project.menu.edit"));
        this.setMnemonic(69);
        JMenuItem item = project.getEditHistoryContainer().getUndoMenuItem();
        this.add(item);
        item.setIcon(CutPasteMenu.getIconResource("undo.gif"));
        item = project.getEditHistoryContainer().getRedoMenuItem();
        this.add(item);
        item.setIcon(CutPasteMenu.getIconResource("redo.gif"));
        this.addSeparator();
        this.cutMenuItem = new JMenuItem(new CutAction(project));
        this.cutMenuItem.setIcon(CutPasteMenu.getIconResource("cut.gif"));
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.add(this.cutMenuItem);
        this.copyMenuItem = new JMenuItem(new CopyAction(project));
        this.copyMenuItem.setIcon(CutPasteMenu.getIconResource("copy.gif"));
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.add(this.copyMenuItem);
        this.pasteMenuItem = new JMenuItem(new PasteAction(project));
        this.pasteMenuItem.setIcon(CutPasteMenu.getIconResource("paste.gif"));
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.add(this.pasteMenuItem);
        this.addSeparator();
        this.deleteMenuItem = new JMenuItem(new DeleteAction(project));
        this.deleteMenuItem.setIcon(CutPasteMenu.getIconResource("delete.gif"));
        this.deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.add(this.deleteMenuItem);
    }

    public JMenuItem getDeleteMenuItem() {
        return this.deleteMenuItem;
    }

    public JMenuItem getCopyMenuItem() {
        return this.copyMenuItem;
    }

    public JMenuItem getCutMenuItem() {
        return this.cutMenuItem;
    }

    public JMenuItem getPasteMenuItem() {
        return this.pasteMenuItem;
    }

    public static boolean isAccelerator(KeyStroke ks) {
        return ks.equals(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) || ks.equals(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) || ks.equals(KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) || ks.equals(KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) || ks.equals(KeyStroke.getKeyStroke(38, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) || ks.equals(KeyStroke.getKeyStroke(40, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) || ks.equals(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) || ks.equals(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) || ks.equals(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask())) || ks.equals(KeyStroke.getKeyStroke(112, 0)) || ks.equals(KeyStroke.getKeyStroke(113, 0)) || ks.equals(KeyStroke.getKeyStroke(114, 0)) || ks.equals(KeyStroke.getKeyStroke(115, 0)) || ks.equals(KeyStroke.getKeyStroke(116, 0)) || ks.equals(KeyStroke.getKeyStroke(117, 0)) || ks.equals(KeyStroke.getKeyStroke(118, 0)) || ks.equals(KeyStroke.getKeyStroke(119, 0)) || ks.equals(KeyStroke.getKeyStroke(120, 0));
    }
}

