/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.gui.selection.SelectionContainer;
import com.frinika.sequencer.gui.selection.SelectionFocusable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class PasteAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private ProjectContainer project;

    public PasteAction(ProjectContainer project) {
        super(CurrentLocale.getMessage("sequencer.project.paste"));
        this.project = project;
    }

    public void actionPerformed(ActionEvent e) {
        this.project.getEditHistoryContainer().mark(CurrentLocale.getMessage("sequencer.project.paste"));
        SelectionFocusable focus = this.project.getSelectionFocus();
        if (focus instanceof SelectionContainer && ((SelectionContainer)focus).getSelectionStartTick() > -1L) {
            SelectionContainer selectionContainer = (SelectionContainer)focus;
            this.project.clipBoard().paste(selectionContainer.getSelectionStartTick(), selectionContainer.getSelectionLeftColumn(), true, this.project);
        } else {
            this.project.clipBoard().paste(this.project);
        }
        this.project.getEditHistoryContainer().notifyEditHistoryListeners();
    }
}

