/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu;

import com.frinika.gui.AbstractDialogAction;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.menu.RepeatActionEditor;
import com.frinika.sequencer.gui.partview.PartView;
import com.frinika.sequencer.gui.selection.SelectionFocusable;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MidiPartGhost;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.Part;
import com.frinika.sequencer.model.Selectable;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public class RepeatAction
extends AbstractDialogAction {
    int repeat = 1;
    long repeatTicks;
    boolean ghost = false;
    long selectionLength;
    boolean selectionSupportsGhosts;
    protected Collection<Selectable> list;

    public RepeatAction(ProjectFrame frame) {
        super(frame, "sequencer.project.repeat");
        this.repeatTicks = frame.getProjectContainer().getSequence().getResolution() * 4 * 4;
    }

    public void actionPerformed(ActionEvent e) {
        if (!(EventQueue.getCurrentEvent().getSource() instanceof JMenuItem) && !(KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() instanceof PartView)) {
            return;
        }
        super.actionPerformed(e);
    }

    protected JComponent createGUI() {
        return new RepeatActionEditor(this, this.frame.getProjectContainer());
    }

    protected void performPrepare() {
        ProjectContainer project = this.frame.getProjectContainer();
        SelectionFocusable focus = project.getSelectionFocus();
        if (focus != null) {
            this.list = focus.getObjects();
            if (!this.list.isEmpty()) {
                this.selectionSupportsGhosts = false;
                long first = Long.MAX_VALUE;
                long last = 0L;
                for (Selectable sel : this.list) {
                    long start = Long.MAX_VALUE;
                    long end = 0L;
                    if (sel instanceof Part) {
                        start = ((Part)sel).getStartTick();
                        end = ((Part)sel).getEndTick();
                        if (sel instanceof MidiPart) {
                            this.selectionSupportsGhosts = true;
                        }
                    } else if (sel instanceof MultiEvent) {
                        start = ((MultiEvent)sel).getStartTick();
                        end = ((MultiEvent)sel).getEndTick();
                    }
                    if (start < first) {
                        first = start;
                    }
                    if (end <= last) continue;
                    last = end;
                }
                if (first == Long.MAX_VALUE) {
                    first = 0L;
                }
                this.selectionLength = last - first;
            } else {
                this.cancel();
            }
        } else {
            this.cancel();
        }
    }

    protected void performAction() {
        for (Selectable elem : this.list) {
            if (elem instanceof Part) {
                this.repeat((Part)elem);
                continue;
            }
            if (!(elem instanceof MultiEvent)) continue;
            this.repeat((MultiEvent)elem);
        }
    }

    private void repeat(Part part) {
        long tick = this.repeatTicks;
        Lane lane = part.getLane();
        for (int i = 0; i < this.repeat; ++i) {
            if (!this.ghost || !(part instanceof MidiPart) || part instanceof MidiPartGhost) {
                part.copyBy(tick, lane);
            } else {
                assert (part instanceof MidiPart);
                this.createGhost((MidiPart)part, tick);
            }
            tick += this.repeatTicks;
        }
    }

    private void createGhost(MidiPart part, long deltaTicks) {
        MidiPartGhost ghost = new MidiPartGhost(part, deltaTicks);
        ghost.getLane().add(ghost);
    }

    private void repeat(MultiEvent event) {
        long tick = this.repeatTicks;
        MidiPart part = event.getPart();
        Lane lane = part.getLane();
        for (int i = 0; i < this.repeat; ++i) {
            RepeatAction.copyBy(event, tick);
            tick += this.repeatTicks;
        }
    }

    private static void copyBy(MultiEvent event, long deltaTicks) {
        try {
            MultiEvent newEvent = (MultiEvent)event.clone();
            long t = newEvent.getStartTick() + deltaTicks;
            newEvent.setStartTick(t);
            newEvent.getPart().add(newEvent);
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
        }
    }
}

