/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.model.timesignature.TimeSignatureList;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class TimeSignatureEditAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private ProjectFrame project;
    private TimeSignatureList list;

    public TimeSignatureEditAction(ProjectFrame project) {
        super(CurrentLocale.getMessage("sequencer.project.edit_timesignature"), ProjectFrame.getIconResource("timesig.png"));
        this.project = project;
        this.list = project.getProjectContainer().getTimeSignatureList();
    }

    public void actionPerformed(ActionEvent arg0) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame();
                AbstractTableModel dataModel = new AbstractTableModel(){
                    int bar;
                    int nBeat;

                    public int getColumnCount() {
                        return 2;
                    }

                    public int getRowCount() {
                        TimeSignatureEditAction.this.list.reco();
                        return TimeSignatureEditAction.this.list.getList().size() + 1;
                    }

                    public Object getValueAt(int row, int col) {
                        if (row >= TimeSignatureEditAction.this.list.getList().size()) {
                            return "";
                        }
                        TimeSignatureList.TimeSignatureEvent ev = TimeSignatureEditAction.this.list.getList().elementAt(row);
                        if (col == 0) {
                            return ev.bar;
                        }
                        return ev.beatsPerBar;
                    }

                    public boolean isCellEditable(int row, int col) {
                        return true;
                    }

                    public void setValueAt(Object value, int row, int col) {
                        boolean newE = row >= TimeSignatureEditAction.this.list.getList().size();
                        TimeSignatureList.TimeSignatureEvent ev = null;
                        ev = !newE ? TimeSignatureEditAction.this.list.getList().elementAt(row) : TimeSignatureEditAction.this.list.getList().elementAt(TimeSignatureEditAction.this.list.getList().size() - 1);
                        this.bar = ev.bar;
                        this.nBeat = ev.beatsPerBar;
                        try {
                            if (col == 0) {
                                this.bar = Integer.parseInt((String)value);
                            } else {
                                this.nBeat = Integer.parseInt((String)value);
                            }
                            if (!newE) {
                                TimeSignatureEditAction.this.list.remove(ev.bar);
                            }
                            TimeSignatureEditAction.this.list.add(this.bar, this.nBeat);
                            TimeSignatureEditAction.this.list.reco();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.fireTableDataChanged();
                    }
                };
                JTable table = new JTable(dataModel);
                table.getColumnModel().getColumn(0).setWidth(50);
                table.getColumnModel().getColumn(1).setWidth(15);
                table.getColumnModel().getColumn(0).setHeaderValue("BAR");
                table.getColumnModel().getColumn(1).setHeaderValue("BEATS");
                JScrollPane scrollpane = new JScrollPane(table);
                frame.setContentPane(scrollpane);
                frame.setTitle("Time signitures");
                frame.pack();
                frame.setVisible(true);
            }
        });
    }
}

