/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu.midi;

import com.frinika.gui.AbstractDialogAction;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.partview.PartView;
import com.frinika.sequencer.gui.pianoroll.PianoRoll;
import com.frinika.sequencer.gui.selection.MidiSelection;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.NoteEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMidiAction
extends AbstractDialogAction {
    protected Collection<MultiEvent> events;
    protected long startTick;
    protected long lastTick;
    protected long endTick;

    public AbstractMidiAction(ProjectFrame frame, String actionId) {
        super(frame, actionId);
    }

    @Override
    public void performPrepare() {
        ProjectContainer project = this.frame.getProjectContainer();
        MidiSelection m = project.getMidiSelection();
        this.events = m.getSelected();
        if (this.events == null || this.events.isEmpty()) {
            this.cancel();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component focusOwner;
        if (!(EventQueue.getCurrentEvent().getSource() instanceof JMenuItem || (focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner()) instanceof PartView || focusOwner instanceof PianoRoll)) {
            return;
        }
        super.actionPerformed(e);
    }

    @Override
    protected void performAction() {
        ArrayList<MultiEvent> clones = new ArrayList<MultiEvent>();
        try {
            this.startTick = 0L;
            this.lastTick = 0L;
            this.endTick = 0L;
            for (MultiEvent ev : this.events) {
                MultiEvent clone = (MultiEvent)ev.clone();
                clones.add(clone);
                if (this.startTick == 0L || clone.getStartTick() < this.startTick) {
                    this.startTick = clone.getStartTick();
                }
                if (clone.getStartTick() > this.lastTick) {
                    this.lastTick = clone.getStartTick();
                }
                if (clone.getEndTick() <= this.endTick) continue;
                this.endTick = clone.getEndTick();
            }
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
        }
        this.modifyEvents(clones);
        Iterator clonesIterator = clones.iterator();
        for (MultiEvent ev : this.events) {
            ev.getPart().remove(ev);
            ev.restoreFromClone((EditHistoryRecordable)clonesIterator.next());
            ev.getPart().add(ev);
        }
    }

    public void modifyEvents(Collection<MultiEvent> events) {
        ArrayList<NoteEvent> notes = new ArrayList<NoteEvent>();
        for (MultiEvent me : events) {
            if (!(me instanceof NoteEvent)) continue;
            notes.add((NoteEvent)me);
        }
        this.modifyNoteEvents(notes);
    }

    public void modifyNoteEvents(Collection<NoteEvent> events) {
        for (NoteEvent note : events) {
            this.modifyNoteEvent(note);
        }
    }

    public abstract void modifyNoteEvent(NoteEvent var1);

    public MidiPart getMidiPart() {
        if (this.events != null && !this.events.isEmpty()) {
            return this.events.iterator().next().getMidiPart();
        }
        return null;
    }

    public MidiLane getMidiLane() {
        MidiPart part = this.getMidiPart();
        if (part != null) {
            return (MidiLane)part.getLane();
        }
        return null;
    }
}

