/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu.midi;

import com.frinika.gui.OptionsDialog;
import com.frinika.localization.CurrentLocale;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.menu.midi.MidiStepRecordActionDialog;
import com.frinika.sequencer.gui.partview.PartView;
import com.frinika.sequencer.gui.virtualkeyboard.VirtualKeyboard;
import com.frinika.sequencer.model.EditHistoryAction;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.NoteEvent;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;

public class MidiStepRecordAction
extends AbstractAction {
    private static final String actionId = "sequencer.midi.step_record";
    long step = 64L;
    long position;
    int lengthDiff = -4;
    int velocity = 100;
    boolean autoRecord = true;
    private ProjectFrame frame;
    private MidiStepRecordActionDialog dialog;
    MidiPart part;
    private static final String NOTES = "c d ef g a b";

    public MidiStepRecordAction(ProjectFrame frame) {
        super(CurrentLocale.getMessage(actionId));
        this.frame = frame;
    }

    public void actionPerformed(ActionEvent e) {
        if (!(EventQueue.getCurrentEvent().getSource() instanceof JMenuItem) && !(KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() instanceof PartView)) {
            return;
        }
        ProjectContainer project = this.frame.getProjectContainer();
        this.position = project.getSequencer().getTickPosition();
        this.part = project.getMidiSelection().getMidiPart();
        if (this.dialog == null) {
            this.dialog = new MidiStepRecordActionDialog(this.frame, this);
            OptionsDialog.centerOnScreen(this.dialog);
        }
        this.dialog.show();
    }

    int[] stepRecord(int[] notes) {
        MidiPart part = this.frame.getProjectContainer().getMidiSelection().getMidiPart();
        if (part != null) {
            ProjectContainer project = this.frame.getProjectContainer();
            TreeSet<Integer> inserted = new TreeSet<Integer>();
            project.getEditHistoryContainer().mark(CurrentLocale.getMessage(actionId));
            for (int i = 0; i < notes.length; ++i) {
                int n = notes[i];
                if (n == -1) continue;
                this.insertNote(n);
                inserted.add(n);
            }
            final long oldPosition = this.position;
            this.position += this.step;
            final long newPosition = this.position;
            this.frame.getProjectContainer().getSequencer().setTickPosition(this.position);
            project.getEditHistoryContainer().push(new EditHistoryAction(){

                public void undo() {
                    MidiStepRecordAction.this.frame.getProjectContainer().getSequencer().setTickPosition(oldPosition);
                }

                public void redo() {
                    MidiStepRecordAction.this.frame.getProjectContainer().getSequencer().setTickPosition(newPosition);
                }
            });
            project.getEditHistoryContainer().notifyEditHistoryListeners();
            int[] result = new int[inserted.size()];
            Iterator it = inserted.iterator();
            for (int i = 0; i < result.length; ++i) {
                result[i] = (Integer)it.next();
            }
            return result;
        }
        this.frame.message("Please select a part to record into.");
        return null;
    }

    String stepRecord(String s) {
        int[] notes = MidiStepRecordAction.parseNotes(s);
        int[] n = this.stepRecord(notes);
        if (n != null) {
            String r = MidiStepRecordAction.formatNotes(n);
            return r;
        }
        return null;
    }

    void insertNote(int note) {
        NoteEvent n = new NoteEvent(this.part, this.position, note, this.velocity, ((MidiLane)this.part.getLane()).getMidiChannel(), this.step + (long)this.lengthDiff);
        this.part.add(n);
    }

    static int[] parseNotes(String s) {
        StringTokenizer st = new StringTokenizer(s, " \t\n\r,;:", false);
        int[] notes = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            notes[i++] = MidiStepRecordAction.parseNote(st.nextToken());
        }
        return notes;
    }

    static String formatNotes(int[] notes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < notes.length; ++i) {
            String noteName = MidiStepRecordAction.formatNote(notes[i]);
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(noteName);
        }
        return sb.toString();
    }

    public static int parseNote(String s) {
        int octave;
        int mod = 0;
        int len = s.length();
        if (len == 0 || len > 3) {
            return -1;
        }
        char n = Character.toLowerCase(s.charAt(0));
        int note = NOTES.indexOf(n);
        if (note == -1) {
            return -1;
        }
        int octavePos = 1;
        switch (len) {
            case 1: {
                octave = VirtualKeyboard.Octave;
                break;
            }
            case 3: {
                char m = s.charAt(1);
                switch (m) {
                    case '-': {
                        break;
                    }
                    case '#': {
                        mod = 1;
                        break;
                    }
                    case 'b': {
                        mod = -1;
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
                octavePos = 2;
            }
            case 2: {
                char oc = s.charAt(octavePos);
                octave = oc - 48;
                if (octave >= 0 && octave <= 9) break;
                return -1;
            }
            default: {
                return -1;
            }
        }
        int result = note + mod + octave * 12;
        return result;
    }

    public static String formatNote(int note) {
        String s = VirtualKeyboard.getNoteString(note);
        if (s.charAt(1) == '-') {
            return new StringBuffer().append(s.charAt(0)).append(s.charAt(2)).toString();
        }
        return s;
    }
}

