/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu.midi;

import com.frinika.gui.AbstractDialog;
import com.frinika.gui.OptionsEditor;
import com.frinika.localization.CurrentLocale;
import com.frinika.midi.MidiInDeviceManager;
import com.frinika.project.ProjectContainer;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.SongPositionListener;
import com.frinika.sequencer.SwingSongPositionListenerWrapper;
import com.frinika.sequencer.gui.TimeFormat;
import com.frinika.sequencer.gui.TimeSelector;
import com.frinika.sequencer.gui.menu.midi.MidiStepRecordAction;
import com.frinika.sequencer.gui.selection.SelectionContainer;
import com.frinika.sequencer.gui.selection.SelectionListener;
import com.frinika.sequencer.midi.MidiMessageListener;
import com.frinika.sequencer.model.MidiLane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.HashSet;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MidiStepRecordActionDialog
extends AbstractDialog
implements OptionsEditor,
SongPositionListener,
SelectionListener,
MidiMessageListener {
    public static final long AUTO_RECORD_DELAY_INTERVAL = 1500L;
    private static final Font BUFFER_TEXT_FIELD_FONT_NORMAL = new Font("DialogInput", 0, 12);
    private static final Font BUFFER_TEXT_FIELD_FONT_ITALICS = new Font("DialogInput", 2, 12);
    private MidiStepRecordAction action;
    private ProjectFrame frame;
    private TimeSelector positionTimeSelector;
    private TimeSelector stepTimeSelector;
    private boolean bufferDirty = false;
    private MidiLane monitoredLane = null;
    private Collection<Integer> currentlyPressedNotes = new HashSet<Integer>();
    private AutoRecordThread autoRecordThread = null;
    private JCheckBox autoRecordCheckBox;
    private JTextField bufferTextField;
    private JPanel buttonsPanel;
    private JButton clearButton;
    private JButton closeButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSpinner lengthDiffSpinner;
    private JPanel mainPanel;
    private JPanel positionTimeSelectorPanel;
    private JButton recordButton;
    private JPanel stepPanel;
    private JButton undoButton;
    private JSpinner velocitySpinner;

    public MidiStepRecordActionDialog(ProjectFrame frame, MidiStepRecordAction action) {
        super(frame, CurrentLocale.getMessage("sequencer.midi.step_record"), false);
        this.frame = frame;
        this.action = action;
        MidiInDeviceManager.open();
        ProjectContainer project = frame.getProjectContainer();
        this.initComponents();
        this.positionTimeSelector = new TimeSelector(frame.getProjectContainer(), TimeFormat.BAR_BEAT_TICK);
        this.stepTimeSelector = new TimeSelector(frame.getProjectContainer(), TimeFormat.NOTE_LENGTH, true);
        this.stepTimeSelector.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ((MidiStepRecordActionDialog)MidiStepRecordActionDialog.this).action.step = MidiStepRecordActionDialog.this.stepTimeSelector.getTicks();
            }
        });
        this.positionTimeSelectorPanel.add(this.positionTimeSelector);
        this.stepPanel.add(this.stepTimeSelector);
        this.bufferTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                MidiStepRecordActionDialog.this.setBufferDirty(true);
            }
        });
        project.getSequencer().addSongPositionListener(new SwingSongPositionListenerWrapper(this));
        project.getSequencer().addMidiMessageListener(this);
        project.getMidiSelection().addSelectionListener(this);
        this.getRootPane().setDefaultButton(this.recordButton);
        this.pack();
        this.refresh();
    }

    public void refresh() {
        this.action.position = this.frame.getProjectContainer().getSequencer().getTickPosition();
        this.stepTimeSelector.setTicks(this.action.step);
        this.positionTimeSelector.setTicks(this.action.position);
        this.lengthDiffSpinner.setValue(this.action.lengthDiff);
        this.velocitySpinner.setValue(this.action.velocity);
        this.autoRecordCheckBox.setSelected(this.action.autoRecord);
        this.refreshAutoRecord();
        this.refreshPart();
    }

    private void refreshPart() {
        if (this.monitoredLane != null) {
            this.monitoredLane.removeMidiMessageListener(this);
        }
        this.action.part = this.frame.getProjectContainer().getMidiSelection().getMidiPart();
        if (this.action.part != null) {
            this.monitoredLane = (MidiLane)this.action.part.getLane();
            if (this.monitoredLane != null) {
                this.monitoredLane.addMidiMessageListener(this);
            }
        }
    }

    public void update() {
        this.action.step = this.stepTimeSelector.getTicks();
        this.action.position = this.positionTimeSelector.getTicks();
        this.action.lengthDiff = (Integer)this.lengthDiffSpinner.getValue();
        this.action.velocity = (Integer)this.velocitySpinner.getValue();
    }

    public void hide() {
        if (this.monitoredLane != null) {
            this.monitoredLane.removeMidiMessageListener(this);
        }
        super.hide();
    }

    void record() {
        this.refreshPart();
        String buffer = this.getBuffer();
        String actuallyRecorded = this.action.stepRecord(buffer);
        if (actuallyRecorded != null) {
            this.setBuffer(actuallyRecorded);
            this.setBufferDirty(false);
            this.currentlyPressedNotes.clear();
        }
    }

    void clear() {
        this.setBuffer("");
    }

    void undo() {
        this.frame.getProjectContainer().getEditHistoryContainer().getUndoMenuItem().doClick();
    }

    void close() {
        this.hide();
    }

    public void midiMessage(MidiMessage message) {
        ShortMessage shm;
        int cmd;
        if (message instanceof ShortMessage && ((cmd = (shm = (ShortMessage)message).getCommand()) == 144 || cmd == 128)) {
            int velocity = shm.getData2();
            if (velocity != 0 && cmd == 144) {
                if (this.isVisible()) {
                    if (this.currentlyPressedNotes.isEmpty()) {
                        this.clear();
                    }
                    int note = shm.getData1();
                    this.currentlyPressedNotes.add(note);
                    this.addToBuffer(note);
                    if (this.action.autoRecord) {
                        this.startAutoRecordInterval();
                    }
                }
            } else if (this.isVisible()) {
                int note = shm.getData1();
                this.currentlyPressedNotes.remove(note);
                if (!this.currentlyPressedNotes.isEmpty()) {
                    this.removeFromBuffer(note);
                }
            }
        }
    }

    public void selectionChanged(SelectionContainer selection) {
        this.refreshPart();
    }

    public void notifyTickPosition(long tick) {
        this.action.position = tick;
        this.positionTimeSelector.setTicks(tick);
    }

    public boolean requiresNotificationOnEachTick() {
        return false;
    }

    public void setBuffer(String s) {
        this.setBufferDirty(true);
        this.bufferTextField.setText(s);
    }

    public String getBuffer() {
        return this.bufferTextField.getText();
    }

    public void addToBuffer(String s) {
        String buffer = this.getBuffer();
        if (buffer.toLowerCase().indexOf(s.toLowerCase()) == -1) {
            if (buffer.length() > 0) {
                buffer = buffer + " ";
            }
            buffer = buffer + s;
            this.setBuffer(buffer);
        }
    }

    public void removeFromBuffer(String s) {
        String buffer = this.getBuffer() + " ";
        s = s + " ";
        int i = buffer.toLowerCase().indexOf(s.toLowerCase());
        if (i != -1) {
            buffer = buffer.substring(0, i) + buffer.substring(i + s.length());
            this.setBuffer(buffer.trim());
        }
    }

    public void addToBuffer(int note) {
        this.addToBuffer(MidiStepRecordAction.formatNote(note));
    }

    public void removeFromBuffer(int note) {
        this.removeFromBuffer(MidiStepRecordAction.formatNote(note));
    }

    private void setBufferDirty(boolean dirty) {
        if (dirty == this.bufferDirty) {
            return;
        }
        this.bufferDirty = dirty;
        if (dirty) {
            this.bufferTextField.setFont(BUFFER_TEXT_FIELD_FONT_NORMAL);
        } else {
            this.bufferTextField.setFont(BUFFER_TEXT_FIELD_FONT_ITALICS);
            this.bufferTextField.selectAll();
        }
        this.bufferTextField.repaint();
    }

    private void refreshAutoRecord() {
        this.action.autoRecord = this.autoRecordCheckBox.isSelected();
        if (this.action.autoRecord && this.bufferDirty) {
            this.record();
        }
    }

    private synchronized void startAutoRecordInterval() {
        long now = System.currentTimeMillis();
        long end = now + 1500L;
        if (this.autoRecordThread == null) {
            this.autoRecordThread = new AutoRecordThread();
            this.autoRecordThread.endTime = end;
            this.autoRecordThread.start();
        } else {
            this.autoRecordThread.endTime = end;
        }
    }

    private synchronized void stopAutoRecordInterval() {
        this.autoRecordThread = null;
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.stepPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.positionTimeSelectorPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.lengthDiffSpinner = new JSpinner();
        this.jLabel3 = new JLabel();
        this.velocitySpinner = new JSpinner();
        this.bufferTextField = new JTextField();
        this.buttonsPanel = new JPanel();
        this.autoRecordCheckBox = new JCheckBox();
        this.recordButton = new JButton();
        this.undoButton = new JButton();
        this.clearButton = new JButton();
        this.closeButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("Step");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.stepPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 8);
        this.mainPanel.add((Component)this.stepPanel, gridBagConstraints);
        this.jLabel4.setText("Position");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.positionTimeSelectorPanel, gridBagConstraints);
        this.jLabel2.setText("Length rel.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.lengthDiffSpinner.setModel(new SpinnerNumberModel(this.action.lengthDiff, -999, 999, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.lengthDiffSpinner, gridBagConstraints);
        this.jLabel3.setText("Velocity");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.velocitySpinner.setModel(new SpinnerNumberModel(this.action.velocity, 1, 127, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.mainPanel.add((Component)this.velocitySpinner, gridBagConstraints);
        this.bufferTextField.setFont(BUFFER_TEXT_FIELD_FONT_NORMAL);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 3, 10, 3);
        this.mainPanel.add((Component)this.bufferTextField, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.autoRecordCheckBox.setText("auto step");
        this.autoRecordCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.autoRecordCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.autoRecordCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MidiStepRecordActionDialog.this.autoRecordCheckBoxStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 3, 3);
        this.buttonsPanel.add((Component)this.autoRecordCheckBox, gridBagConstraints);
        this.recordButton.setForeground(Color.red);
        this.recordButton.setMnemonic('P');
        this.recordButton.setText("  Step  ");
        this.recordButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MidiStepRecordActionDialog.this.recordButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.buttonsPanel.add((Component)this.recordButton, gridBagConstraints);
        this.undoButton.setMnemonic('U');
        this.undoButton.setText(" Undo ");
        this.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MidiStepRecordActionDialog.this.undoButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 3);
        this.buttonsPanel.add((Component)this.undoButton, gridBagConstraints);
        this.clearButton.setMnemonic('C');
        this.clearButton.setText(" Clear ");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MidiStepRecordActionDialog.this.clearButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 3);
        this.buttonsPanel.add((Component)this.clearButton, gridBagConstraints);
        this.closeButton.setMnemonic('\u001b');
        this.closeButton.setText(" Close ");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MidiStepRecordActionDialog.this.closeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.buttonsPanel.add((Component)this.closeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        this.mainPanel.add((Component)this.buttonsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.mainPanel, gridBagConstraints);
        this.pack();
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.stopAutoRecordInterval();
        this.clear();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.stopAutoRecordInterval();
        this.close();
    }

    private void recordButtonActionPerformed(ActionEvent evt) {
        this.stopAutoRecordInterval();
        this.record();
    }

    private void undoButtonActionPerformed(ActionEvent evt) {
        this.stopAutoRecordInterval();
        this.undo();
    }

    private void autoRecordCheckBoxStateChanged(ChangeEvent evt) {
        this.refreshAutoRecord();
    }

    private class AutoRecordThread
    extends Thread {
        long endTime;

        private AutoRecordThread() {
        }

        public void run() {
            try {
                while (MidiStepRecordActionDialog.this.autoRecordThread == this && System.currentTimeMillis() < this.endTime) {
                    Thread.sleep(50L);
                }
                if (MidiStepRecordActionDialog.this.autoRecordThread == this) {
                    MidiStepRecordActionDialog.this.recordButton.doClick();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            MidiStepRecordActionDialog.this.stopAutoRecordInterval();
        }
    }
}

