/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.menu.midi;

import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.menu.midi.AbstractMidiAction;
import com.frinika.sequencer.gui.menu.midi.MidiVelocityActionEditor;
import com.frinika.sequencer.model.NoteEvent;
import java.util.Collection;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiVelocityAction
extends AbstractMidiAction {
    int startVelocity = 100;
    int endVelocity = 100;
    private long startTick;
    private long endTick;

    public MidiVelocityAction(ProjectFrame frame) {
        super(frame, "sequencer.midi.velocity");
    }

    @Override
    public void modifyNoteEvents(Collection<NoteEvent> events) {
        this.startTick = Long.MAX_VALUE;
        this.endTick = Long.MIN_VALUE;
        for (NoteEvent note : events) {
            if (note.getStartTick() < this.startTick) {
                this.startTick = note.getStartTick();
            }
            if (note.getStartTick() <= this.endTick) continue;
            this.endTick = note.getStartTick();
        }
        super.modifyNoteEvents(events);
    }

    @Override
    protected JComponent createGUI() {
        return new MidiVelocityActionEditor(this);
    }

    @Override
    public void modifyNoteEvent(NoteEvent note) {
        int diff = this.endVelocity - this.startVelocity;
        long dist = this.endTick - this.startTick;
        int v = this.startVelocity + (int)Math.round((double)diff * ((double)(note.getStartTick() - this.startTick) / (double)dist));
        if (v < 1) {
            v = 1;
        } else if (v > 127) {
            v = 127;
        }
        note.setVelocity(v);
    }
}

