/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.mixer;

import com.frinika.localization.CurrentLocale;
import com.frinika.project.SynthesizerDescriptor;
import com.frinika.project.mididevices.gui.MidiDevicesPanel;
import com.frinika.sequencer.gui.mixer.MidiChannelMixerSlot;
import com.frinika.sequencer.gui.mixer.SynthWrapper;
import com.frinika.synth.importers.soundfont.SoundFontFileFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Method;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MidiDeviceMixerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public MidiChannelMixerSlot[] mixerSlots = new MidiChannelMixerSlot[16];

    public MidiDeviceMixerPanel(final MidiDevicesPanel panel, final SynthWrapper synthWrapper) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        if (synthWrapper.getRealDevice() instanceof Synthesizer) {
            JButton loadSoundbankButton = new JButton(CurrentLocale.getMessage("mididevices.loadsoundbank"));
            loadSoundbankButton.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    try {
                        JFileChooser chooser = new JFileChooser();
                        chooser.setDialogTitle("Open soundfont");
                        chooser.setFileFilter(new SoundFontFileFilter());
                        if (chooser.showOpenDialog(null) == 0) {
                            File soundFontFile = chooser.getSelectedFile();
                            Soundbank soundbank = synthWrapper.getSoundbank(soundFontFile);
                            synthWrapper.loadAllInstruments(soundbank);
                            System.out.println("Soundbank loaded");
                            ((SynthesizerDescriptor)panel.getProject().getMidiDeviceDescriptor(synthWrapper)).setSoundBankFileName(soundFontFile.getAbsolutePath());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.add((Component)loadSoundbankButton, gc);
            MidiDevice dev = synthWrapper.getRealDevice();
            try {
                Method method = dev.getClass().getMethod("show", new Class[0]);
                JButton showSettingsButton = new JButton(CurrentLocale.getMessage("mididevices.show"));
                showSettingsButton.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent e) {
                        MidiDevice dev = synthWrapper.getRealDevice();
                        try {
                            Method method = dev.getClass().getMethod("show", new Class[0]);
                            method.invoke((Object)dev, new Object[0]);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                });
                this.add((Component)showSettingsButton, gc);
            }
            catch (SecurityException e1) {
            }
            catch (NoSuchMethodException e1) {
                // empty catch block
            }
        }
        JButton renameDeviceButton = new JButton(CurrentLocale.getMessage("mididevices.rename"));
        renameDeviceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String value = JOptionPane.showInputDialog(CurrentLocale.getMessage("mididevices.entername"));
                if (value == null) {
                    return;
                }
                panel.getProject().getMidiDeviceDescriptor(synthWrapper).setProjectName(value);
                panel.updateDeviceTabs();
            }
        });
        this.add((Component)renameDeviceButton, gc);
        gc.gridwidth = 0;
        JButton removeDeviceButton = new JButton(CurrentLocale.getMessage("mididevices.removedevice"));
        removeDeviceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                panel.remove(synthWrapper);
            }
        });
        this.add((Component)removeDeviceButton, gc);
        gc.gridwidth = 1;
        gc.fill = 3;
        gc.weighty = 1.0;
        for (int n = 0; n < this.mixerSlots.length; ++n) {
            this.mixerSlots[n] = new MidiChannelMixerSlot(synthWrapper, synthWrapper.getChannels()[n]);
            this.add((Component)this.mixerSlots[n], gc);
        }
        synthWrapper.gui = this;
    }
}

