/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.pianoroll;

import com.frinika.sequencer.model.ControllerEvent;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.NoteEvent;
import com.frinika.sequencer.model.PitchBendEvent;

public class ControllerHandle {
    String name;
    private int contrl;
    int minVal = 0;
    int maxVal = 127;
    int cmd;

    public ControllerHandle(String name, int min, int max, int cntrl, int cmd) {
        this.name = name;
        this.minVal = min;
        this.maxVal = max;
        this.contrl = cntrl;
        this.cmd = cmd;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVelocity() {
        return this.cmd == 144;
    }

    public MultiEvent createEvent(MidiPart part, long tick, int val) {
        assert (!this.isVelocity());
        if (this.cmd == 176) {
            return new ControllerEvent(part, tick, this.contrl, val);
        }
        if (this.cmd == 224) {
            return new PitchBendEvent(part, tick, val - this.minVal);
        }
        try {
            throw new Exception(" Should never happen ");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isValid(MultiEvent ev) {
        switch (this.cmd) {
            case 144: {
                return ev instanceof NoteEvent;
            }
            case 176: {
                if (!(ev instanceof ControllerEvent)) {
                    return false;
                }
                ControllerEvent ce = (ControllerEvent)ev;
                return this.contrl == ce.getControlNumber();
            }
            case 224: {
                return ev instanceof PitchBendEvent;
            }
        }
        try {
            throw new Exception(" unknown event type " + ev);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getController() {
        return this.contrl;
    }
}

