/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.pianoroll;

import com.frinika.project.ProjectContainer;
import com.frinika.sequencer.gui.ItemPanel;
import com.frinika.sequencer.gui.pianoroll.PianoRoll;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.Part;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class WarpToPartLeftAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    ProjectContainer project;
    static boolean ignoreWarp = false;
    ItemPanel panel;

    public WarpToPartLeftAction(ProjectContainer project, ItemPanel panel) {
        this.panel = panel;
        this.project = project;
    }

    public void actionPerformed(ActionEvent e) {
        double ticksToScreen;
        int newVal;
        if (ignoreWarp) {
            return;
        }
        Part focus = (Part)this.project.getPartSelection().getFocus();
        if (focus == null) {
            return;
        }
        long left = focus.getStartTick();
        long tick1 = left - (long)this.project.getSequence().getResolution();
        if (tick1 < 0L) {
            tick1 = 0L;
        }
        if ((newVal = (int)((double)tick1 * (ticksToScreen = this.panel.userToScreen))) < this.panel.getXRangeModel().getValue() || newVal > this.panel.getXRangeModel().getValue() + this.panel.getXRangeModel().getExtent()) {
            this.panel.getXRangeModel().setValue((int)((double)tick1 * ticksToScreen));
        }
        if (focus instanceof MidiPart) {
            int[] p = ((MidiPart)focus).getPitchRange();
            double midY = ((PianoRoll)this.panel).pitchToScreen((p[0] + p[1]) / 2);
            int val = (int)(midY - (double)this.panel.getYRangeModel().getExtent() * 0.5);
            this.panel.getYRangeModel().setValue(val);
        }
        if (!this.project.getSequencer().isRunning()) {
            this.project.getSequencer().setTickPosition(left);
        }
    }
}

