/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.transport;

import com.frinika.global.FrinikaConfig;
import com.frinika.localization.CurrentLocale;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.FrinikaSequencer;
import com.frinika.sequencer.SongPositionListener;
import com.frinika.sequencer.SwingSongPositionListenerWrapper;
import com.frinika.sequencer.gui.transport.RecordAction;
import com.frinika.sequencer.gui.transport.RewindAction;
import com.frinika.sequencer.gui.transport.StartStopAction;
import com.frinika.sequencer.model.util.TimeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class TransportPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    FrinikaSequencer sequencer;
    ProjectFrame projectFrame;
    StartStopAction startStopAction;
    RecordAction recordAction;
    RewindAction rewindAction;
    JLabel timeDisplay;
    private static final int BAR_BEAT_TICK = 1;
    private static final int FRAME = 2;
    private static final int TIME = 3;
    int displayMode = 1;
    private TimeUtils timeUtils;

    public TransportPanel(ProjectFrame projectFrame) {
        this.timeUtils = new TimeUtils(projectFrame.getProjectContainer());
        this.projectFrame = projectFrame;
        this.sequencer = projectFrame.getProjectContainer().getSequencer();
        this.startStopAction = new StartStopAction(projectFrame);
        this.rewindAction = new RewindAction(projectFrame);
        this.recordAction = new RecordAction(projectFrame);
        this.initComponents();
        projectFrame.getProjectContainer().getSequencer().addSongPositionListener(new SwingSongPositionListenerWrapper(new SongPositionListener(){

            public void notifyTickPosition(long tick) {
                TransportPanel.this.setTime();
            }

            public boolean requiresNotificationOnEachTick() {
                return false;
            }
        }));
    }

    void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        JButton previousButton = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/previous.png")));
        previousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TransportPanel.this.sequencer.setTickPosition(0L);
            }
        });
        this.add((Component)previousButton, gc);
        JButton stopButton = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/stop.png")));
        stopButton.addActionListener(this.startStopAction.stopAction);
        this.add((Component)stopButton, gc);
        JButton recordButton = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/record.png")));
        recordButton.addActionListener(this.recordAction);
        this.add((Component)recordButton, gc);
        JButton playButton = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/play.png")));
        playButton.addActionListener(this.startStopAction.startAction);
        this.add((Component)playButton, gc);
        JButton nextButton = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/next.png")));
        nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("Not implemented yet!");
            }
        });
        this.add((Component)nextButton, gc);
        this.timeDisplay = new JLabel();
        Font font = this.timeDisplay.getFont();
        Font newFont = font.deriveFont(1, font.getSize() + 5);
        this.timeDisplay.setFont(newFont);
        this.timeDisplay.setOpaque(true);
        this.timeDisplay.setBackground(Color.BLACK);
        this.timeDisplay.setForeground(Color.GREEN);
        this.timeDisplay.setBorder(BorderFactory.createMatteBorder(2, 16, 2, 16, Color.BLACK));
        gc.weightx = 1.0;
        this.timeDisplay.setHorizontalAlignment(0);
        final JPanel timeDisplayPanel = new JPanel();
        timeDisplayPanel.setLayout(new BorderLayout());
        timeDisplayPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        timeDisplayPanel.add(this.timeDisplay);
        this.add((Component)timeDisplayPanel, gc);
        timeDisplayPanel.setToolTipText(CurrentLocale.getMessage("transport.time.format.tip"));
        timeDisplayPanel.addMouseListener(new MouseListener(){
            JPopupMenu menu = new JPopupMenu();
            {
                JMenuItem item = new JMenuItem("bar.beat.tick");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TransportPanel.this.displayMode = 1;
                        TransportPanel.this.setTime();
                    }
                });
                this.menu.add(item);
                item = new JMenuItem("frames");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TransportPanel.this.displayMode = 2;
                        TransportPanel.this.setTime();
                    }
                });
                this.menu.add(item);
                item = new JMenuItem("time");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TransportPanel.this.displayMode = 3;
                        TransportPanel.this.setTime();
                    }
                });
                this.menu.add(item);
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                this.menu.show(timeDisplayPanel, 0, 0);
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        this.setTime();
    }

    void setTime() {
        switch (this.displayMode) {
            case 2: {
                int frames = (int)((double)this.sequencer.getMicrosecondPosition() / 1000000.0 * (double)FrinikaConfig.sampleRate);
                this.timeDisplay.setText(String.format("%07d", frames));
                break;
            }
            case 3: {
                long time = this.sequencer.getMicrosecondPosition() / 1000L;
                int secs = (int)(time / 1000L);
                int mins = secs / 60;
                int millis = (int)(time % 1000L);
                this.timeDisplay.setText(String.format("%02d.%02d.%03d", mins, secs %= 60, millis));
                break;
            }
            case 1: {
                long tick = this.sequencer.getTickPosition();
                this.timeDisplay.setText(this.timeUtils.tickToBarBeatTick(tick));
            }
        }
    }
}

