/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.virtualkeyboard;

import com.frinika.sequencer.gui.virtualkeyboard.VirtualKeyboard;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.sound.midi.Receiver;

public class NoteKeyThread
extends Thread {
    private Receiver receiver;
    int noteNumber;
    int velocity;
    int channel;
    NoteKeyThread[] noteKeyThreads;
    Vector<KeyEvent> keyEvents = new Vector();

    public NoteKeyThread(NoteKeyThread[] noteKeyThreads, Receiver receiver, int noteNumber, int channel, int velocity) {
        this.receiver = receiver;
        this.noteNumber = noteNumber;
        this.velocity = velocity;
        this.channel = channel;
        this.noteKeyThreads = noteKeyThreads;
        VirtualKeyboard.noteOn(receiver, noteNumber, channel, velocity);
        this.start();
    }

    public synchronized void addKeyEvent(KeyEvent evt) {
        this.keyEvents.add(evt);
        this.notify();
    }

    public synchronized void run() {
        boolean keepPlay = true;
        while (keepPlay) {
            if (this.keyEvents.size() == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            do {
                keepPlay = this.keyEvents.get(0).getID() != 402;
                this.keyEvents.remove(0);
                try {
                    this.wait(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (this.keyEvents.size() > 0);
        }
        VirtualKeyboard.noteOff(this.receiver, this.noteNumber, this.channel);
        this.noteKeyThreads[this.noteNumber] = null;
    }
}

