/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.gui.virtualkeyboard;

import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;

public final class VirtualKeyboard {
    public static int Octave = 4;
    static final String[] noteNames = new String[]{"C-", "C#", "D-", "D#", "E-", "F-", "F#", "G-", "G#", "A-", "A#", "B-"};

    public static String getNoteString(int note) {
        if (note >= 0) {
            return noteNames[note % 12] + note / 12;
        }
        return "";
    }

    private static int addOctave(int note) {
        return Octave * 12 + note;
    }

    public static int keyToInt(char c) throws Exception {
        switch (c) {
            case 'z': {
                return VirtualKeyboard.addOctave(-12);
            }
            case 's': {
                return VirtualKeyboard.addOctave(-11);
            }
            case 'x': {
                return VirtualKeyboard.addOctave(-10);
            }
            case 'd': {
                return VirtualKeyboard.addOctave(-9);
            }
            case 'c': {
                return VirtualKeyboard.addOctave(-8);
            }
            case 'v': {
                return VirtualKeyboard.addOctave(-7);
            }
            case 'g': {
                return VirtualKeyboard.addOctave(-6);
            }
            case 'b': {
                return VirtualKeyboard.addOctave(-5);
            }
            case 'h': {
                return VirtualKeyboard.addOctave(-4);
            }
            case 'n': {
                return VirtualKeyboard.addOctave(-3);
            }
            case 'j': {
                return VirtualKeyboard.addOctave(-2);
            }
            case 'm': {
                return VirtualKeyboard.addOctave(-1);
            }
            case 'q': {
                return VirtualKeyboard.addOctave(0);
            }
            case '2': {
                return VirtualKeyboard.addOctave(1);
            }
            case 'w': {
                return VirtualKeyboard.addOctave(2);
            }
            case '3': {
                return VirtualKeyboard.addOctave(3);
            }
            case 'e': {
                return VirtualKeyboard.addOctave(4);
            }
            case 'r': {
                return VirtualKeyboard.addOctave(5);
            }
            case '5': {
                return VirtualKeyboard.addOctave(6);
            }
            case 't': {
                return VirtualKeyboard.addOctave(7);
            }
            case '6': {
                return VirtualKeyboard.addOctave(8);
            }
            case 'y': {
                return VirtualKeyboard.addOctave(9);
            }
            case '7': {
                return VirtualKeyboard.addOctave(10);
            }
            case 'u': {
                return VirtualKeyboard.addOctave(11);
            }
            case 'i': {
                return VirtualKeyboard.addOctave(12);
            }
            case '9': {
                return VirtualKeyboard.addOctave(13);
            }
            case 'o': {
                return VirtualKeyboard.addOctave(14);
            }
            case '0': {
                return VirtualKeyboard.addOctave(15);
            }
            case 'p': {
                return VirtualKeyboard.addOctave(16);
            }
        }
        throw new Exception();
    }

    public static void noteOn(Receiver recv, int note, int channel, int velocity) {
        try {
            ShortMessage msg = new ShortMessage();
            msg.setMessage(144, channel, note, velocity);
            recv.send(msg, -1L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void noteOff(Receiver recv, int note, int channel) {
        try {
            ShortMessage msg = new ShortMessage();
            msg.setMessage(144, channel, note, 0);
            recv.send(msg, -1L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

