/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.midi.groovepattern.gui;

import com.frinika.gui.AbstractDialog;
import com.frinika.project.gui.ProjectFrame;
import com.frinika.sequencer.gui.selection.PartSelection;
import com.frinika.sequencer.midi.groovepattern.GroovePatternFromSequence;
import com.frinika.sequencer.midi.groovepattern.GroovePatternManager;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.Part;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GroovePatternManagerDialog
extends AbstractDialog {
    private static Map<ProjectFrame, GroovePatternManagerDialog> instances = new HashMap<ProjectFrame, GroovePatternManagerDialog>();
    private GroovePatternManager manager;
    private JButton closeButton;
    private JButton editButton;
    private JButton exportButton;
    private JButton importButton;
    private JList itemsList;
    private JScrollPane itemsScrollPane;
    private JPanel mainPanel;
    private JButton newButton;
    private JButton removeButton;

    public static GroovePatternManagerDialog getDialog(ProjectFrame frame) {
        GroovePatternManagerDialog d = instances.get(frame);
        if (d == null) {
            d = new GroovePatternManagerDialog(frame, GroovePatternManager.getInstance());
            instances.put(frame, d);
        }
        return d;
    }

    public static void showDialog(ProjectFrame frame) {
        GroovePatternManagerDialog.getDialog(frame).show();
    }

    public GroovePatternManagerDialog(ProjectFrame parent, GroovePatternManager manager) {
        super(parent, "Groove Patterns", true);
        this.manager = manager;
        this.initComponents();
        this.refresh();
        this.setSize(600, 400);
        AbstractDialog.centerOnScreen(this);
        Point p = this.getLocation();
        this.setLocation(p.x + 100, p.y + 100);
    }

    public void show() {
        this.refresh();
        super.show();
    }

    private void refresh() {
        this.refreshItemsList();
    }

    private void refreshItemsList() {
        int index = this.itemsList.getSelectedIndex();
        Collection<GroovePatternFromSequence> patterns = this.manager.getUserGroovePatterns();
        Vector<GroovePatternFromSequence> items = new Vector<GroovePatternFromSequence>();
        for (GroovePatternFromSequence gp : patterns) {
            items.add(gp);
        }
        this.itemsList.setListData(items);
        if (index >= 0) {
            this.itemsList.setSelectedIndex(index);
            this.itemsList.ensureIndexIsVisible(index);
        }
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.itemsScrollPane = new JScrollPane();
        this.itemsList = new JList();
        this.newButton = new JButton();
        this.importButton = new JButton();
        this.exportButton = new JButton();
        this.removeButton = new JButton();
        this.editButton = new JButton();
        this.closeButton = new JButton();
        this.setTitle("Groove Patterns");
        this.mainPanel.setLayout(new GridBagLayout());
        this.itemsList.setSelectionMode(0);
        this.itemsScrollPane.setViewportView(this.itemsList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.itemsScrollPane, gridBagConstraints);
        this.newButton.setMnemonic('N');
        this.newButton.setText("New");
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroovePatternManagerDialog.this.newButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.newButton, gridBagConstraints);
        this.importButton.setMnemonic('I');
        this.importButton.setText("Import...");
        this.importButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroovePatternManagerDialog.this.importButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.importButton, gridBagConstraints);
        this.exportButton.setMnemonic('x');
        this.exportButton.setText("Export...");
        this.exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroovePatternManagerDialog.this.exportButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.exportButton, gridBagConstraints);
        this.removeButton.setMnemonic('R');
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroovePatternManagerDialog.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.removeButton, gridBagConstraints);
        this.editButton.setMnemonic('E');
        this.editButton.setText("Edit...");
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroovePatternManagerDialog.this.editButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.editButton, gridBagConstraints);
        this.closeButton.setMnemonic('C');
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroovePatternManagerDialog.this.closeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.closeButton, gridBagConstraints);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.pack();
    }

    private void exportButtonActionPerformed(ActionEvent evt) {
        String filename;
        GroovePatternFromSequence sel = (GroovePatternFromSequence)this.itemsList.getSelectedValue();
        if (sel != null && (filename = this.frame.promptFile(null, ProjectFrame.FILE_FILTER_MIDIFILES, true)) != null) {
            File file = new File(filename);
            try {
                sel.saveAsMidiFile(file);
            }
            catch (IOException e) {
                this.frame.error(e);
            }
        }
    }

    public static void interactionImportGroovePatternFromMidiPartSelection(ProjectFrame frame) {
        GroovePatternManagerDialog.interactionImportGroovePatternFromMidiPartSelection(frame, null);
    }

    private static void interactionImportGroovePatternFromMidiPartSelection(ProjectFrame frame, GroovePatternManagerDialog dialog) {
        Part p;
        Collection c;
        PartSelection sel = frame.getProjectContainer().getPartSelection();
        if (sel != null && !(c = sel.getSelected()).isEmpty() && (p = (Part)c.iterator().next()) instanceof MidiPart) {
            String name = frame.prompt("Import selected Midi part as groove pattern.\nPlease enter a name for the new groove pattern:");
            if (name != null) {
                try {
                    GroovePatternFromSequence gp = GroovePatternManager.getInstance().importUserGroovePattern(name, (MidiPart)p);
                    if (dialog != null) {
                        dialog.refreshItemsList();
                        dialog.itemsList.setSelectedValue(gp.getName(), true);
                    }
                }
                catch (Exception e) {
                    frame.error(e);
                }
            }
            return;
        }
        frame.message("Please select a Midi part to import as groove pattern.");
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        GroovePatternManagerDialog.interactionImportGroovePatternFromMidiPartSelection(this.frame, this);
    }

    private void importButtonActionPerformed(ActionEvent evt) {
        String filename = this.frame.promptFile(null, ProjectFrame.FILE_FILTER_MIDIFILES);
        if (filename != null) {
            File file = new File(filename);
            try {
                GroovePatternFromSequence gp = GroovePatternManager.getInstance().importUserGroovePattern(file);
                this.refreshItemsList();
                this.itemsList.setSelectedValue(gp, true);
            }
            catch (Exception e) {
                this.frame.error(e);
            }
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        GroovePatternFromSequence sel = (GroovePatternFromSequence)this.itemsList.getSelectedValue();
        if (sel != null && this.frame.confirm("Really DELETE groove pattern '" + sel.getName() + "'?")) {
            try {
                GroovePatternManager.getInstance().removeUserGroovePattern(sel);
            }
            catch (IOException ioe) {
                this.frame.error(ioe);
            }
            this.refreshItemsList();
            this.itemsList.setSelectedIndex(-1);
        }
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        GroovePatternFromSequence sel = (GroovePatternFromSequence)this.itemsList.getSelectedValue();
        try {
            sel.openAsOwnProject();
            this.hide();
        }
        catch (Exception e) {
            this.frame.error(e);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.hide();
    }
}

