/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.sequencer.FrinikaTrackWrapper;
import com.frinika.sequencer.model.ChannelEvent;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.MidiPart;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.ShortMessage;

public class ControllerEvent
extends ChannelEvent {
    private static final long serialVersionUID = 1L;
    transient MidiEvent midiEvent;
    int controlNumber;
    int value;

    public ControllerEvent(FrinikaTrackWrapper track, long startTick, int controlNumber, int value) {
        super(track, startTick);
        this.controlNumber = controlNumber;
        this.value = value;
    }

    public ControllerEvent(MidiPart multiEventGroup, long startTick, int controlNumber, int value) {
        super(multiEventGroup, startTick);
        this.controlNumber = controlNumber;
        this.value = value;
    }

    public int getControlNumber() {
        return this.controlNumber;
    }

    public void setControlNumber(int controlNumber) {
        this.controlNumber = controlNumber;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public long getEndTick() {
        return this.startTick;
    }

    void commitRemoveImpl() {
        this.getTrack().remove(this.midiEvent);
    }

    public void commitAddImpl() {
        try {
            ShortMessage shm = new ShortMessage();
            shm.setMessage(176, this.channel, this.controlNumber, this.value);
            this.midiEvent = new MidiEvent(shm, this.startTick);
            this.getTrack().add(this.midiEvent);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public void restoreFromClone(EditHistoryRecordable object) {
        ControllerEvent evt = (ControllerEvent)object;
        this.part = evt.part;
        this.startTick = evt.startTick;
        this.controlNumber = evt.controlNumber;
        this.value = evt.value;
    }
}

