/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.localization.CurrentLocale;
import com.frinika.sequencer.model.EditHistoryAction;
import com.frinika.sequencer.model.EditHistoryListener;
import com.frinika.sequencer.model.EditHistoryMark;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.EditHistoryRecordableAction;
import com.frinika.sequencer.model.EditHistoryRecorder;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class EditHistoryContainer {
    private Vector<EditHistoryAction> editHistory = new Vector();
    private Vector<EditHistoryMark> editHistoryMarks = new Vector();
    private int redoMarkIndex = 0;
    private JMenuItem undoMenuItem;
    private JMenuItem redoMenuItem;
    private Vector<EditHistoryListener> editHistoryListeners = new Vector();
    private boolean recordingEnabled = true;
    private int savedPosition = 0;

    public EditHistoryContainer() {
        this.undoMenuItem = new JMenuItem();
        this.undoMenuItem.setText(CurrentLocale.getMessage("edithistorycontainer.editmenu.undo"));
        this.undoMenuItem.setEnabled(false);
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.undoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditHistoryContainer.this.undo();
            }
        });
        this.redoMenuItem = new JMenuItem();
        this.redoMenuItem.setText(CurrentLocale.getMessage("edithistorycontainer.editmenu.redo"));
        this.redoMenuItem.setEnabled(false);
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.redoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditHistoryContainer.this.redo();
            }
        });
    }

    public void push(EditHistoryRecorder recorder, int edit_history_type, EditHistoryRecordable event) {
        if (this.recordingEnabled) {
            this.editHistory.add(new EditHistoryRecordableAction(this, recorder, edit_history_type, event));
        }
    }

    public void push(EditHistoryAction editHistoryAction) {
        if (this.recordingEnabled) {
            this.editHistory.add(editHistoryAction);
        }
    }

    public void mark(String markString) {
        if (!this.recordingEnabled) {
            return;
        }
        if (this.redoMarkIndex < this.editHistoryMarks.size()) {
            int n;
            int startIndex = this.editHistoryMarks.get(this.redoMarkIndex).getEditHistoryIndex();
            int endIndex = this.redoMarkIndex < this.editHistoryMarks.size() - 1 ? this.editHistoryMarks.get(this.redoMarkIndex + 1).getEditHistoryIndex() : this.editHistory.size();
            for (n = startIndex; n < endIndex; ++n) {
                this.editHistory.remove(this.editHistory.size() - 1);
            }
            for (n = this.redoMarkIndex; n < this.editHistoryMarks.size(); ++n) {
                this.editHistoryMarks.remove(this.editHistoryMarks.size() - 1);
            }
        }
        this.editHistoryMarks.add(new EditHistoryMark(this.editHistory.size(), markString));
        this.redoMarkIndex = this.editHistoryMarks.size();
        this.updateMenuItems();
    }

    private void notifyEditHistoryListeners(EditHistoryAction[] editHistoryActionArray) {
        for (EditHistoryListener editHistoryListener : this.editHistoryListeners) {
            editHistoryListener.fireSequenceDataChanged(editHistoryActionArray);
        }
    }

    public void notifyEditHistoryListeners() {
        Vector<EditHistoryAction> editHistoryActions = new Vector<EditHistoryAction>();
        if (this.redoMarkIndex > 0) {
            int lastIndex = this.editHistoryMarks.get(this.redoMarkIndex - 1).getEditHistoryIndex();
            int currentIndex = this.redoMarkIndex == this.editHistoryMarks.size() ? this.editHistory.size() - 1 : this.editHistoryMarks.get(this.redoMarkIndex).getEditHistoryIndex() - 1;
            for (int n = currentIndex; n >= lastIndex; --n) {
                editHistoryActions.add(this.editHistory.get(n));
            }
        }
        EditHistoryAction[] editHistoryActionArray = new EditHistoryAction[editHistoryActions.size()];
        editHistoryActions.toArray(editHistoryActionArray);
        this.notifyEditHistoryListeners(editHistoryActionArray);
    }

    public void addEditHistoryListener(EditHistoryListener editHistoryListener) {
        this.editHistoryListeners.add(editHistoryListener);
    }

    public void removeEditHistoryListener(EditHistoryListener editHistoryListener) {
        this.editHistoryListeners.remove(editHistoryListener);
    }

    public void redo() {
        if (this.redoMarkIndex < this.editHistoryMarks.size()) {
            int startIndex = this.editHistoryMarks.get(this.redoMarkIndex).getEditHistoryIndex();
            int endIndex = this.redoMarkIndex < this.editHistoryMarks.size() - 1 ? this.editHistoryMarks.get(this.redoMarkIndex + 1).getEditHistoryIndex() : this.editHistory.size();
            EditHistoryAction[] editHistoryActionArray = new EditHistoryAction[endIndex - startIndex];
            for (int n = startIndex; n < endIndex; ++n) {
                this.editHistory.get(n).redo();
                editHistoryActionArray[n - startIndex] = this.editHistory.get(n);
            }
            ++this.redoMarkIndex;
            this.notifyEditHistoryListeners(editHistoryActionArray);
            this.updateMenuItems();
        }
    }

    public String getNextUndoMarkString() {
        if (this.redoMarkIndex > 0) {
            return this.editHistoryMarks.get(this.redoMarkIndex - 1).getMarkString();
        }
        return null;
    }

    public String getNextRedoMarkString() {
        if (this.redoMarkIndex < this.editHistoryMarks.size()) {
            return this.editHistoryMarks.get(this.redoMarkIndex).getMarkString();
        }
        return null;
    }

    public void undo() {
        if (this.redoMarkIndex > 0) {
            int lastIndex = this.editHistoryMarks.get(this.redoMarkIndex - 1).getEditHistoryIndex();
            int currentIndex = this.redoMarkIndex == this.editHistoryMarks.size() ? this.editHistory.size() - 1 : this.editHistoryMarks.get(this.redoMarkIndex).getEditHistoryIndex() - 1;
            EditHistoryAction[] editHistoryEntryArray = new EditHistoryRecordableAction[currentIndex - lastIndex + 1];
            for (int n = currentIndex; n >= lastIndex; --n) {
                this.editHistory.get(n).undo();
                if (!(this.editHistory.get(n) instanceof EditHistoryRecordableAction)) continue;
                editHistoryEntryArray[n - lastIndex] = ((EditHistoryRecordableAction)this.editHistory.get(n)).getInvertedClone();
            }
            --this.redoMarkIndex;
            this.notifyEditHistoryListeners(editHistoryEntryArray);
            this.updateMenuItems();
        }
    }

    public void updateMenuItems() {
        if (this.undoMenuItem != null) {
            String nextUndoMarkString = this.getNextUndoMarkString();
            if (nextUndoMarkString != null) {
                this.undoMenuItem.setText(CurrentLocale.getMessage("edithistorycontainer.editmenu.undo") + " " + nextUndoMarkString);
                this.undoMenuItem.setEnabled(true);
            } else {
                this.undoMenuItem.setText(CurrentLocale.getMessage("edithistorycontainer.editmenu.undo"));
                this.undoMenuItem.setEnabled(false);
            }
        }
        if (this.redoMenuItem != null) {
            String nextRedoMarkString = this.getNextRedoMarkString();
            if (nextRedoMarkString != null) {
                this.redoMenuItem.setText(CurrentLocale.getMessage("edithistorycontainer.editmenu.redo") + " " + nextRedoMarkString);
                this.redoMenuItem.setEnabled(true);
            } else {
                this.redoMenuItem.setText(CurrentLocale.getMessage("edithistorycontainer.editmenu.redo"));
                this.redoMenuItem.setEnabled(false);
            }
        }
    }

    public JMenuItem getRedoMenuItem() {
        return this.redoMenuItem;
    }

    public JMenuItem getUndoMenuItem() {
        return this.undoMenuItem;
    }

    public void setRedoMenuItem(JMenuItem redoMenuItem) {
        this.redoMenuItem = redoMenuItem;
    }

    public void setUndoMenuItem(JMenuItem undoMenuItem) {
        this.undoMenuItem = undoMenuItem;
    }

    public boolean hasChanges() {
        return this.redoMarkIndex != this.savedPosition;
    }

    public boolean isRecordingEnabled() {
        return this.recordingEnabled;
    }

    public void disableRecording() {
        this.recordingEnabled = false;
    }

    public void enableRecording() {
        this.recordingEnabled = true;
    }

    public void updateSavedPosition() {
        this.savedPosition = this.redoMarkIndex;
        this.notifyEditHistoryListeners();
    }
}

