/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;

public class MetaEvent
extends MultiEvent {
    private static final long serialVersionUID = 1L;
    transient MidiEvent metaEvent;
    int type;
    byte[] data;

    void commitRemoveImpl() {
        this.getTrack().remove(this.metaEvent);
    }

    public void commitAddImpl() {
        try {
            this.metaEvent = new MidiEvent(this.getMessage(), this.startTick);
            this.getTrack().add(this.metaEvent);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public void restoreFromClone(EditHistoryRecordable object) {
        MetaEvent evt = (MetaEvent)object;
        this.part = evt.part;
        this.startTick = evt.startTick;
        this.type = evt.type;
        this.data = evt.data;
    }

    public MetaEvent(MidiPart part, long startTick) {
        super(part, startTick);
    }

    public long getEndTick() {
        return 0L;
    }

    public void setMessage(int type, byte[] data) {
        this.type = type;
        this.data = data;
    }

    public void setMessage(MetaMessage message) {
        this.type = message.getType();
        this.data = message.getData();
    }

    public MetaMessage getMessage() throws InvalidMidiDataException {
        MetaMessage msg = new MetaMessage();
        msg.setMessage(this.type, this.data, this.data.length);
        return msg;
    }
}

