/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.sequencer.FrinikaTrackWrapper;
import com.frinika.sequencer.gui.partview.PartView;
import com.frinika.sequencer.model.CommitListener;
import com.frinika.sequencer.model.EditHistoryContainer;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.Ghost;
import com.frinika.sequencer.model.Lane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEvent;
import com.frinika.sequencer.model.Selectable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiPartGhost
extends MidiPart
implements Ghost,
CommitListener {
    private static final long serialVersionUID = 1L;
    MidiPart referredPart;
    transient Map<MultiEvent, MultiEvent> committedEvents = new HashMap<MultiEvent, MultiEvent>();

    public MidiPartGhost(MidiPart referredPart, Lane lane) {
        this();
        this.referredPart = referredPart;
        this.name = "Ghost of " + referredPart.name;
        this.lane = lane;
        referredPart.addCommitListener(this);
    }

    public MidiPartGhost(MidiPart referredPart, long deltaTicks) {
        this(referredPart, referredPart.getLane());
        this.setStartTick(referredPart.getStartTick() + deltaTicks);
        this.setEndTick(referredPart.getEndTick() + deltaTicks);
    }

    private MidiPartGhost() {
    }

    @Override
    public MidiPart getReferredPart() {
        return this.referredPart;
    }

    public void setReferredPart(MidiPart referredPart) {
        this.referredPart = referredPart;
    }

    public long getDistance() {
        return this.getStartTick() - this.getReferredPart().getStartTick();
    }

    @Override
    public void add(MultiEvent ev) {
    }

    @Override
    public void attach() {
        super.attach();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MidiPartGhost clone = new MidiPartGhost();
        clone.referredPart = this.referredPart;
        clone.name = this.name;
        clone.lane = this.lane;
        clone.setStartTick(this.getStartTick());
        clone.setEndTick(this.getEndTick());
        clone.selected = false;
        return clone;
    }

    @Override
    public void commitEventsAdd() {
        if (this.multiEvents == null) {
            return;
        }
        long distance = this.getDistance();
        for (MultiEvent multiEvent : this.getReferredPart().getMultiEvents()) {
            this.commitAddClone(multiEvent);
        }
    }

    @Override
    public synchronized void commitEventsRemove() {
        for (MultiEvent event : this.committedEvents.values()) {
            event.commitRemove();
        }
        this.committedEvents.clear();
    }

    @Override
    public void commitAddPerformed(MultiEvent event) {
        this.commitAddClone(event);
    }

    @Override
    public synchronized void commitRemovePerformed(MultiEvent event) {
        this.commitRemoveClone(event);
    }

    protected MultiEvent commitAddClone(MultiEvent multiEvent) {
        try {
            MultiEvent newEvent = (MultiEvent)multiEvent.clone();
            newEvent.part = this;
            newEvent.startTick += this.getDistance();
            newEvent.commitAdd();
            if (this.committedEvents == null) {
                this.committedEvents = new HashMap<MultiEvent, MultiEvent>();
            }
            this.committedEvents.put(multiEvent, newEvent);
            return newEvent;
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            return null;
        }
    }

    protected void commitRemoveClone(MultiEvent multiEvent) {
        MultiEvent clone = this.committedEvents.remove(multiEvent);
        if (clone != null) {
            clone.commitRemove();
        }
    }

    @Override
    public void copyBy(double deltaTick, Lane dst) {
        MidiPartGhost clone = new MidiPartGhost(this.getReferredPart(), dst);
        clone.setStartTick((double)this.getStartTick() + deltaTick);
        clone.setEndTick((double)this.getEndTick() + deltaTick);
    }

    @Override
    public Selectable deepCopy(Selectable parent) {
        try {
            MidiPartGhost clone = (MidiPartGhost)this.clone();
            if (parent == null) {
                clone.lane = this.lane;
            }
            clone.name = "Copy of " + this.name;
            clone.color = this.color;
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            return null;
        }
    }

    @Override
    public void deepMove(long tick) {
        this.setStartTick(this.getStartTick() + tick);
        this.setEndTick(this.getEndTick() + tick);
    }

    @Override
    public void detach() {
        super.detach();
    }

    @Override
    public void drawThumbNail(Graphics2D g, Rectangle rect, PartView panel) {
        int xShift = (int)panel.userToScreen(this.getDistance());
        g.translate(xShift, 0);
        this.getReferredPart().drawThumbNail(g, rect, panel);
        g.translate(-xShift, 0);
    }

    @Override
    public EditHistoryContainer getEditHistoryContainer() {
        return this.getReferredPart().getEditHistoryContainer();
    }

    @Override
    public int getMidiChannel() {
        return this.getReferredPart().getMidiChannel();
    }

    @Override
    public SortedSet<MultiEvent> getMultiEvents() {
        return super.getMultiEvents();
    }

    @Override
    public SortedSet<MultiEvent> getMultiEventSubset(long startTick, long endTick) {
        return super.getMultiEventSubset(startTick, endTick);
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public int[] getPitchRange() {
        return this.getReferredPart().getPitchRange();
    }

    @Override
    public FrinikaTrackWrapper getTrack() {
        return super.getTrack();
    }

    @Override
    public void importFromMidiTrack(long startTickArg, long endTickArg) {
    }

    @Override
    public void moveContentsBy(double dTick, Lane dstLane) {
        super.moveContentsBy(dTick, dstLane);
    }

    @Override
    protected void moveItemsBy(long deltaTick) {
        this.commitEventsRemove();
        this.commitEventsAdd();
    }

    @Override
    public void onLoad() {
        super.onLoad();
    }

    @Override
    public void rebuildMultiEventEndTickComparables() {
        super.rebuildMultiEventEndTickComparables();
    }

    @Override
    public void remove(MultiEvent multiEvent) {
    }

    @Override
    public void restoreFromClone(EditHistoryRecordable o) {
        MidiPartGhost clone = (MidiPartGhost)o;
        this.referredPart = clone.referredPart;
        this.lane = clone.lane;
        this.name = clone.name;
        this.setStartTick(clone.getStartTick());
        this.setEndTick(clone.getEndTick());
        this.selected = false;
    }

    @Override
    public void setBoundsFromEvents() {
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public void addToModel() {
        super.addToModel();
    }

    @Override
    public void displayStructure(String prefix, PrintStream out) {
        super.displayStructure(prefix, out);
    }

    @Override
    public Color getColor() {
        return this.getReferredPart().getColor();
    }

    @Override
    public long getDurationInTicks() {
        return this.getReferredPart().getDurationInTicks();
    }

    @Override
    public long getEndTick() {
        return this.getStartTick() + this.getDurationInTicks();
    }

    @Override
    public Rectangle getEventBounds() {
        return this.getReferredPart().getEventBounds();
    }

    @Override
    public Lane getLane() {
        return super.getLane();
    }

    @Override
    public long getStartTick() {
        return super.getStartTick();
    }

    @Override
    public boolean isSelected() {
        return super.isSelected();
    }

    @Override
    public long leftTickForMove() {
        return super.leftTickForMove();
    }

    @Override
    public void moveBy(long deltaTick) {
        super.moveBy(deltaTick);
    }

    @Override
    public void removeFromModel() {
        this.getReferredPart().removeCommitListener(this);
        this.commitEventsRemove();
        super.removeFromModel();
    }

    @Override
    public long rightTickForMove() {
        return super.rightTickForMove();
    }

    @Override
    public void setEndTick(double tick) {
        super.setEndTick(tick);
    }

    @Override
    public void setSelected(boolean b) {
        super.setSelected(b);
    }

    @Override
    public void setStartTick(double tick) {
        super.setStartTick(tick);
    }
}

