/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.sequencer.FrinikaTrackWrapper;
import com.frinika.sequencer.gui.Item;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.MidiLane;
import com.frinika.sequencer.model.MidiPart;
import com.frinika.sequencer.model.MultiEventEndTickComparable;
import com.frinika.sequencer.model.Selectable;
import java.io.Serializable;

public abstract class MultiEvent
implements Comparable,
Serializable,
EditHistoryRecordable,
Item,
Selectable,
Cloneable {
    private static final long serialVersionUID = 1L;
    static transient long multiEventCounter = 1L;
    MidiPart part;
    long multiEventID = 0L;
    protected long startTick;
    private Integer trackerColumn;
    transient boolean selected = false;
    transient MultiEventEndTickComparable multiEventEndTickComparable = null;
    transient boolean zombie = true;

    protected MultiEvent(long startTick) {
        this.startTick = startTick;
    }

    public MultiEvent(FrinikaTrackWrapper track, long startTick) {
        this.startTick = startTick;
        this.multiEventID = multiEventCounter++;
    }

    public MultiEvent(MidiPart part, long startTick) {
        this.part = part;
        this.startTick = startTick;
        this.multiEventID = multiEventCounter++;
    }

    public long getStartTick() {
        return this.startTick;
    }

    public abstract long getEndTick();

    public void setStartTick(long startTick) {
        this.startTick = startTick;
    }

    public final FrinikaTrackWrapper getTrack() {
        return ((MidiLane)this.part.lane).getTrack();
    }

    public MidiPart getMidiPart() {
        return this.part;
    }

    void commitRemove() {
        this.commitRemoveImpl();
        this.getMidiPart().fireCommitRemove(this);
    }

    public void commitAdd() {
        this.commitAddImpl();
        this.getMidiPart().fireCommitAdd(this);
    }

    abstract void commitRemoveImpl();

    abstract void commitAddImpl();

    public void commitChanges() {
        this.commitRemove();
        this.commitAdd();
    }

    public int compareTo(Object obj) {
        int ret = new Long(this.startTick).compareTo(new Long(((MultiEvent)obj).getStartTick()));
        if (ret == 0 && obj != this) {
            return new Long(this.multiEventID).compareTo(new Long(((MultiEvent)obj).multiEventID));
        }
        return ret;
    }

    public void setSelected(boolean yes) {
        if (this.selected == yes) {
            return;
        }
        this.selected = yes;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public MultiEvent detachedCopy() {
        MultiEvent ev = null;
        try {
            ev = (MultiEvent)this.clone();
            ev.part = null;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return ev;
    }

    public Selectable deepCopy(Selectable parent) {
        MultiEvent ev = null;
        try {
            ev = (MultiEvent)this.clone();
            ev.part = parent != null ? (MidiPart)parent : this.part;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return ev;
    }

    public MidiPart getPart() {
        return this.part;
    }

    public int getValue() {
        return 0;
    }

    public void setValue(int val) {
    }

    public int getValueUI() {
        return this.getValue();
    }

    public void setValueUI(int val) {
        this.setValue(val);
    }

    public void deepMove(long tick) {
        this.startTick += tick;
    }

    public void removeFromModel() {
        this.part.remove(this);
    }

    public void addToModel() {
        this.part.add(this);
    }

    public long leftTickForMove() {
        return this.startTick;
    }

    public long rightTickForMove() {
        return this.startTick;
    }

    public Integer getTrackerColumn() {
        return this.trackerColumn;
    }

    public void setTrackerColumn(int column) {
        this.trackerColumn = column;
    }

    public MultiEventEndTickComparable getMultiEventEndTickComparable() {
        if (this.multiEventEndTickComparable == null) {
            this.multiEventEndTickComparable = new MultiEventEndTickComparable(this);
        }
        return this.multiEventEndTickComparable;
    }

    public Object clone() throws CloneNotSupportedException {
        MultiEvent evt = (MultiEvent)super.clone();
        evt.multiEventID = multiEventCounter++;
        evt.setSelected(false);
        return evt;
    }

    public boolean isZombie() {
        return this.zombie;
    }
}

