/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model;

import com.frinika.sequencer.FrinikaTrackWrapper;
import com.frinika.sequencer.model.ChannelEvent;
import com.frinika.sequencer.model.EditHistoryRecordable;
import com.frinika.sequencer.model.MidiPart;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.ShortMessage;

public class PitchBendEvent
extends ChannelEvent {
    private static final long serialVersionUID = 1L;
    transient MidiEvent midiEvent;
    int value;

    public PitchBendEvent(FrinikaTrackWrapper track, long startTick, int value) {
        super(track, startTick);
        this.value = value;
    }

    public PitchBendEvent(MidiPart multiEventGroup, long startTick, int value) {
        super(multiEventGroup, startTick);
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getValueUI() {
        return this.value - 8192;
    }

    public void setValueUI(int value) {
        this.value = value + 8192;
    }

    public long getEndTick() {
        return this.startTick;
    }

    void commitRemoveImpl() {
        this.getTrack().remove(this.midiEvent);
    }

    public void commitAddImpl() {
        try {
            ShortMessage shm = new ShortMessage();
            shm.setMessage(224, this.channel, this.value & 0x3F, this.value >> 7);
            this.midiEvent = new MidiEvent(shm, this.startTick);
            this.getTrack().add(this.midiEvent);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public void restoreFromClone(EditHistoryRecordable object) {
        PitchBendEvent evt = (PitchBendEvent)object;
        this.part = evt.part;
        this.startTick = evt.startTick;
        this.value = evt.value;
    }
}

