/*
 * Decompiled with CFR 0.152.
 */
package com.frinika.sequencer.model.audio;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.sound.sampled.AudioFormat;
import uk.org.toot.audio.core.AudioBuffer;
import uk.org.toot.audio.core.AudioProcess;

public class AudioWriter
implements AudioProcess {
    private RandomAccessFile fis;
    int count = 0;
    File file = null;
    private int nChannel;
    private byte[] byteBuffer;

    public AudioWriter(File file, AudioFormat format) throws IOException {
        this.file = file;
        this.fis = new RandomAccessFile(file, "rw");
        this.fis.setLength(0L);
        this.fis.seek(0L);
        this.fis.write("RIFF".getBytes(), 0, 4);
        this.writeInt(36, this.fis);
        this.fis.write("WAVE".getBytes(), 0, 4);
        this.fis.write("fmt ".getBytes(), 0, 4);
        this.writeInt(16, this.fis);
        this.writeShort(1, this.fis);
        this.nChannel = format.getChannels();
        this.writeShort(this.nChannel, this.fis);
        this.writeInt((int)format.getFrameRate(), this.fis);
        this.writeInt((int)format.getFrameRate() * format.getChannels() * 2, this.fis);
        this.writeShort((short)format.getChannels() * 2, this.fis);
        this.writeShort(16, this.fis);
        this.fis.write("data".getBytes(), 0, 4);
        this.writeInt(0, this.fis);
    }

    private void writeShort(int i, RandomAccessFile fis2) throws IOException {
        byte[] buff = new byte[]{(byte)(0xFF & i), (byte)(0xFF & i >> 8)};
        this.fis.write(buff, 0, 2);
    }

    private void writeInt(int i, RandomAccessFile fis2) throws IOException {
        byte[] buff = new byte[]{(byte)(0xFF & i), (byte)(0xFF & i >> 8), (byte)(0xFF & i >> 16), (byte)(0xFF & i >> 24)};
        this.fis.write(buff, 0, 4);
    }

    public void write(byte[] byteBuffer, int offSet, int n) throws IOException {
        this.fis.write(byteBuffer, offSet, n);
        this.count += n;
    }

    public void close() {
        if (this.fis == null) {
            return;
        }
        if (this.count == 0) {
            this.discard();
            return;
        }
        long fileSize = 0L;
        try {
            fileSize = this.fis.getFilePointer();
            this.fis.seek(4L);
            this.writeInt((int)(fileSize - 8L), this.fis);
            this.fis.seek(40L);
            this.writeInt(this.count, this.fis);
            this.fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Closing " + this.file + "  size/count:" + fileSize + "/" + this.count);
        this.fis = null;
    }

    public void discard() {
        if (this.fis == null) {
            return;
        }
        try {
            this.fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.fis = null;
        this.file.delete();
        this.file = null;
    }

    protected void finalize() {
        if (this.fis == null) {
            return;
        }
        this.close();
    }

    public int processAudio(AudioBuffer buffer) {
        int n;
        if (this.byteBuffer == null || this.byteBuffer.length != buffer.getSampleCount() * 2 * this.nChannel) {
            this.byteBuffer = new byte[buffer.getSampleCount() * 2 * this.nChannel];
        }
        int nSamp = buffer.getSampleCount();
        int count = 0;
        if (this.nChannel == 2) {
            float[] left = buffer.getChannel(0);
            float[] right = buffer.getChannel(1);
            for (n = 0; n < nSamp; ++n) {
                short leftI = (short)(left[n] * 32768.0f);
                short rightI = (short)(right[n] * 32768.0f);
                this.byteBuffer[count++] = (byte)(0xFF & leftI);
                this.byteBuffer[count++] = (byte)(0xFF & leftI >> 8);
                this.byteBuffer[count++] = (byte)(0xFF & rightI);
                this.byteBuffer[count++] = (byte)(0xFF & rightI >> 8);
            }
        } else {
            float[] left = buffer.getChannel(0);
            for (n = 0; n < nSamp; ++n) {
                short leftI = (short)(left[n] * 32768.0f);
                this.byteBuffer[count++] = (byte)(0xFF & leftI);
                this.byteBuffer[count++] = (byte)(0xFF & leftI >> 8);
            }
        }
        try {
            this.write(this.byteBuffer, 0, count);
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public File getFile() {
        return this.file;
    }

    public void open() {
    }
}

